/*
 * Decompiled with CFR 0.152.
 */
package alfio.config;

import alfio.manager.system.ConfigurationManager;
import alfio.manager.system.ExternalConfiguration;
import alfio.manager.user.UserManager;
import alfio.repository.EventRepository;
import alfio.repository.system.ConfigurationRepository;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Duration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration(proxyBeanMethods=false)
public class BaseConfiguration {
    @Bean
    ConfigurationManager configurationManager(ConfigurationRepository configurationRepository, UserManager userManager, EventRepository eventRepository, ExternalConfiguration externalConfiguration, Environment environment) {
        Cache cache = Caffeine.newBuilder().expireAfterWrite(Duration.ofMinutes(1L)).build();
        return new ConfigurationManager(configurationRepository, userManager, eventRepository, externalConfiguration, environment, cache);
    }

    @Bean
    ObjectMapper objectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        return mapper;
    }
}

