/*
 * Decompiled with CFR 0.152.
 */
package alfio.config;

import alfio.manager.system.ConfigurationManager;
import alfio.manager.system.DataMigrator;
import alfio.model.system.ConfigurationKeys;
import alfio.model.user.Role;
import alfio.model.user.User;
import alfio.repository.user.AuthorityRepository;
import alfio.repository.user.UserRepository;
import alfio.util.PasswordGenerator;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Component;

@Component
public class ConfigurationStatusChecker
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationStatusChecker.class);
    private final ConfigurationManager configurationManager;
    private final UserRepository userRepository;
    private final AuthorityRepository authorityRepository;
    private final PasswordEncoder passwordEncoder;
    private final String version;
    private final DataMigrator dataMigrator;

    public ConfigurationStatusChecker(ConfigurationManager configurationManager, UserRepository userRepository, AuthorityRepository authorityRepository, PasswordEncoder passwordEncoder, @Value(value="${alfio.version}") String version, DataMigrator dataMigrator) {
        this.configurationManager = configurationManager;
        this.authorityRepository = authorityRepository;
        this.userRepository = userRepository;
        this.passwordEncoder = passwordEncoder;
        this.version = version;
        this.dataMigrator = dataMigrator;
    }

    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        boolean initCompleted = this.configurationManager.getForSystem(ConfigurationKeys.INIT_COMPLETED).getValueAsBooleanOrDefault();
        if (!initCompleted) {
            String adminPassword = PasswordGenerator.generateRandomPassword();
            this.userRepository.create("admin", this.passwordEncoder.encode((CharSequence)adminPassword), "The", "Administrator", "admin@localhost", true, User.Type.INTERNAL, null, null);
            this.authorityRepository.create("admin", Role.ADMIN.getRoleName());
            log.info("*******************************************************");
            log.info("   This is the first time you're running alf.io");
            log.info("   here the generated admin credentials:");
            log.info("   {} ", (Object)adminPassword);
            log.info("*******************************************************");
            this.configurationManager.saveSystemConfiguration(ConfigurationKeys.INIT_COMPLETED, "true");
            Optional.ofNullable(System.getProperty("maps.clientApiKey")).ifPresent(clientApiKey -> this.configurationManager.saveSystemConfiguration(ConfigurationKeys.MAPS_CLIENT_API_KEY, clientApiKey));
            Optional.ofNullable(System.getProperty("recaptcha.apiKey")).ifPresent(clientApiKey -> this.configurationManager.saveSystemConfiguration(ConfigurationKeys.RECAPTCHA_API_KEY, clientApiKey));
            Optional.ofNullable(System.getProperty("recaptcha.secret")).ifPresent(clientApiKey -> this.configurationManager.saveSystemConfiguration(ConfigurationKeys.RECAPTCHA_SECRET, clientApiKey));
        }
        log.info("performing migration from previous version, if any");
        try {
            this.dataMigrator.migrateEventsToCurrentVersion();
            log.info("done.");
            log.info("initialized alf.io version {} ", (Object)this.version);
        }
        catch (Exception e) {
            log.error("unable to perform data migration. Please report this issue.", (Throwable)e);
        }
    }
}

