/*
 * Decompiled with CFR 0.152.
 */
package alfio.config;

import alfio.config.DataSourceConfiguration;
import alfio.config.support.ArrayColumnMapper;
import alfio.config.support.EnumTypeColumnMapper;
import alfio.config.support.JSONColumnMapper;
import alfio.config.support.PlatformProvider;
import alfio.extension.ExtensionService;
import alfio.job.Jobs;
import alfio.job.executor.AssignTicketToSubscriberJobExecutor;
import alfio.job.executor.BillingDocumentJobExecutor;
import alfio.job.executor.ReservationJobExecutor;
import alfio.job.executor.RetryFailedExtensionJobExecutor;
import alfio.job.executor.RetryFailedReservationConfirmationExecutor;
import alfio.manager.AdminReservationRequestManager;
import alfio.manager.BillingDocumentManager;
import alfio.manager.DemoModeDataManager;
import alfio.manager.FileDownloadManager;
import alfio.manager.FileUploadManager;
import alfio.manager.NotificationManager;
import alfio.manager.PurchaseContextFieldManager;
import alfio.manager.ReservationFinalizer;
import alfio.manager.SpecialPriceTokenGenerator;
import alfio.manager.TicketReservationManager;
import alfio.manager.UploadedResourceManager;
import alfio.manager.WaitingQueueSubscriptionProcessor;
import alfio.manager.i18n.MessageSourceManager;
import alfio.manager.system.AdminJobManager;
import alfio.manager.system.ConfigurationManager;
import alfio.repository.EventDeleterRepository;
import alfio.repository.EventRepository;
import alfio.repository.OrganizationDeleterRepository;
import alfio.repository.PurchaseContextFieldRepository;
import alfio.repository.SubscriptionRepository;
import alfio.repository.TicketCategoryRepository;
import alfio.repository.system.AdminJobQueueRepository;
import alfio.repository.system.ConfigurationRepository;
import alfio.repository.user.OrganizationRepository;
import alfio.repository.user.UserRepository;
import alfio.repository.user.join.UserOrganizationRepository;
import alfio.util.ClockProvider;
import alfio.util.CustomResourceBundleMessageSource;
import alfio.util.Json;
import alfio.util.TemplateManager;
import ch.digitalfondue.npjt.EnableNpjt;
import ch.digitalfondue.npjt.mapper.ColumnMapperFactory;
import ch.digitalfondue.npjt.mapper.ParameterConverter;
import com.zaxxer.hikari.HikariDataSource;
import java.net.http.HttpClient;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Profile;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.EmptySqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration(proxyBeanMethods=false)
@EnableTransactionManagement
@EnableScheduling
@EnableAsync
@ComponentScan(basePackages={"alfio.manager", "alfio.extension"})
@EnableNpjt(basePackages={"alfio.repository"})
public class DataSourceConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DataSourceConfiguration.class);
    private static final Set<PlatformProvider> PLATFORM_PROVIDERS = EnumSet.complementOf(EnumSet.of(PlatformProvider.DEFAULT));

    @Bean
    @Profile(value={"!integration-test", "travis"})
    public PlatformProvider getCloudProvider(Environment environment) {
        return PLATFORM_PROVIDERS.stream().filter(p -> p.isHosting(environment)).findFirst().orElse(PlatformProvider.DEFAULT);
    }

    @Bean
    @Profile(value={"!integration-test", "travis"})
    public DataSource getDataSource(Environment env, PlatformProvider platform) {
        if (platform == PlatformProvider.CLOUD_FOUNDRY || platform == PlatformProvider.DRY_RUN) {
            return new FakeCFDataSource();
        }
        HikariDataSource dataSource = new HikariDataSource();
        dataSource.setJdbcUrl(platform.getUrl(env));
        dataSource.setUsername(platform.getUsername(env));
        dataSource.setPassword(platform.getPassword(env));
        dataSource.setDriverClassName("org.postgresql.Driver");
        dataSource.setMaximumPoolSize(platform.getMaxActive(env));
        dataSource.setMinimumIdle(platform.getMinIdle(env));
        dataSource.setConnectionTimeout(1000L);
        log.debug("Connection pool properties: max active {}, initial size {}", (Object)dataSource.getMaximumPoolSize(), (Object)dataSource.getMinimumIdle());
        boolean isSuperAdmin = Boolean.TRUE.equals(new NamedParameterJdbcTemplate((DataSource)dataSource).queryForObject("select usesuper from pg_user where usename = CURRENT_USER", (SqlParameterSource)EmptySqlParameterSource.INSTANCE, Boolean.class));
        if (isSuperAdmin) {
            log.warn("You're accessing the database using a superuser. This is highly discouraged since it will disable the row security policy checks.");
        }
        return dataSource;
    }

    @Bean
    public PlatformTransactionManager platformTransactionManager(DataSource dataSource) {
        return new CustomDataSourceTransactionManager(dataSource);
    }

    @Bean
    public NamedParameterJdbcTemplate namedParameterJdbcTemplate(DataSource dataSource) {
        return new NamedParameterJdbcTemplate(dataSource);
    }

    @Bean
    public List<ColumnMapperFactory> getAdditionalColumnMappers() {
        return Arrays.asList(new JSONColumnMapper.Factory(), new ArrayColumnMapper.Factory(), new EnumTypeColumnMapper.Factory());
    }

    @Bean
    public List<ParameterConverter> getAdditionalParameterConverters() {
        return Arrays.asList(new JSONColumnMapper.Converter(), new ArrayColumnMapper.Converter(), new EnumTypeColumnMapper.Converter());
    }

    @Bean
    @Profile(value={"!integration-test"})
    public Supplier<Executor> getNewSingleThreadExecutorSupplier() {
        return Executors::newSingleThreadExecutor;
    }

    @Bean
    public Flyway migrator(DataSource dataSource, Environment environment) {
        boolean dryRun = environment.acceptsProfiles(Profiles.of((String[])new String[]{"app-cds"}));
        FluentConfiguration configuration = Flyway.configure();
        String tableName = configuration.getTable();
        if (!dryRun) {
            JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
            Integer matches = (Integer)jdbcTemplate.queryForObject("select count(*) from information_schema.tables where table_name = 'schema_version'", Integer.class);
            tableName = matches != null && matches > 0 ? "schema_version" : configuration.getTable();
        }
        configuration.table(tableName).dataSource(dataSource).validateOnMigrate(false).target(MigrationVersion.LATEST).outOfOrder(true).locations(new String[]{"alfio/db/PGSQL/"});
        Flyway migration = new Flyway((org.flywaydb.core.api.configuration.Configuration)configuration);
        if (!dryRun) {
            migration.migrate();
        }
        return migration;
    }

    @Bean
    public PasswordEncoder getPasswordEncoder() {
        return new BCryptPasswordEncoder();
    }

    @Bean
    public MessageSourceManager messageSourceManager(ConfigurationRepository configurationRepository) {
        CustomResourceBundleMessageSource source = new CustomResourceBundleMessageSource();
        source.setBasenames(new String[]{"alfio.i18n.public", "alfio.i18n.admin"});
        source.setDefaultEncoding(StandardCharsets.UTF_8.displayName());
        source.setFallbackToSystemLocale(false);
        source.setAlwaysUseMessageFormat(true);
        return new MessageSourceManager(source, configurationRepository);
    }

    @Bean
    public Json getJson() {
        return new Json();
    }

    @Bean
    public TemplateManager getTemplateManager(MessageSourceManager messageSourceManager, UploadedResourceManager uploadedResourceManager, ConfigurationManager configurationManager, PurchaseContextFieldManager purchaseContextFieldManager) {
        return new TemplateManager(messageSourceManager, uploadedResourceManager, configurationManager, purchaseContextFieldManager);
    }

    @Bean
    public HttpClient getHttpClient() {
        return HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).executor(Executors.newCachedThreadPool((ThreadFactory)new BasicThreadFactory.Builder().namingPattern("httpClient-thread-%d").build())).build();
    }

    @Bean
    @Profile(value={"!integration-test"})
    public FileDownloadManager fileDownloadManager(HttpClient httpClient) {
        return new FileDownloadManager(httpClient);
    }

    @Bean
    @DependsOn(value={"migrator"})
    @Profile(value={"!disable-jobs"})
    public Jobs jobs(AdminReservationRequestManager adminReservationRequestManager, FileUploadManager fileUploadManager, NotificationManager notificationManager, SpecialPriceTokenGenerator specialPriceTokenGenerator, WaitingQueueSubscriptionProcessor waitingQueueSubscriptionProcessor, TicketReservationManager ticketReservationManager, AdminJobManager adminJobManager) {
        return new Jobs(adminReservationRequestManager, fileUploadManager, notificationManager, specialPriceTokenGenerator, ticketReservationManager, waitingQueueSubscriptionProcessor, adminJobManager);
    }

    @Bean
    AdminJobManager adminJobManager(AdminJobQueueRepository adminJobQueueRepository, PlatformTransactionManager transactionManager, ClockProvider clockProvider, ReservationJobExecutor reservationJobExecutor, BillingDocumentJobExecutor billingDocumentJobExecutor, AssignTicketToSubscriberJobExecutor assignTicketToSubscriberJobExecutor, RetryFailedExtensionJobExecutor retryFailedExtensionJobExecutor, RetryFailedReservationConfirmationExecutor retryFailedReservationConfirmationExecutor) {
        return new AdminJobManager(List.of(reservationJobExecutor, billingDocumentJobExecutor, assignTicketToSubscriberJobExecutor, retryFailedExtensionJobExecutor, retryFailedReservationConfirmationExecutor), adminJobQueueRepository, transactionManager, clockProvider);
    }

    @Bean
    ReservationJobExecutor reservationJobExecutor(TicketReservationManager ticketReservationManager) {
        return new ReservationJobExecutor(ticketReservationManager);
    }

    @Bean
    BillingDocumentJobExecutor billingDocumentJobExecutor(BillingDocumentManager billingDocumentManager, TicketReservationManager ticketReservationManager, EventRepository eventRepository, NotificationManager notificationManager, OrganizationRepository organizationRepository) {
        return new BillingDocumentJobExecutor(billingDocumentManager, ticketReservationManager, eventRepository, notificationManager, organizationRepository);
    }

    @Bean
    AssignTicketToSubscriberJobExecutor assignTicketToSubscriberJobExecutor(AdminReservationRequestManager requestManager, ConfigurationManager configurationManager, SubscriptionRepository subscriptionRepository, EventRepository eventRepository, ClockProvider clockProvider, TicketCategoryRepository ticketCategoryRepository, PurchaseContextFieldRepository purchaseContextFieldRepository) {
        return new AssignTicketToSubscriberJobExecutor(requestManager, configurationManager, subscriptionRepository, eventRepository, clockProvider, ticketCategoryRepository, purchaseContextFieldRepository);
    }

    @Bean
    RetryFailedExtensionJobExecutor retryFailedExtensionJobExecutor(ExtensionService extensionService) {
        return new RetryFailedExtensionJobExecutor(extensionService);
    }

    @Bean
    RetryFailedReservationConfirmationExecutor retryFailedReservationConfirmationExecutor(ReservationFinalizer reservationFinalizer, Json json) {
        return new RetryFailedReservationConfirmationExecutor(reservationFinalizer, json);
    }

    @Bean
    @Profile(value={"demo"})
    DemoModeDataManager demoModeDataManager(UserRepository userRepository, UserOrganizationRepository userOrganizationRepository, OrganizationRepository organizationRepository, EventDeleterRepository eventDeleterRepository, EventRepository eventRepository, ConfigurationManager configurationManager, OrganizationDeleterRepository organizationDeleterRepository) {
        return new DemoModeDataManager(userRepository, userOrganizationRepository, organizationRepository, eventDeleterRepository, eventRepository, configurationManager, organizationDeleterRepository);
    }
}

