/*
 * Decompiled with CFR 0.152.
 */
package alfio.config;

import alfio.config.ApplicationPropertiesConfiguration;
import alfio.config.DataSourceConfiguration;
import alfio.config.MvcConfiguration;
import alfio.config.WebSecurityConfig;
import alfio.util.DefaultExceptionHandler;
import com.openhtmltopdf.util.XRLog;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import java.util.Objects;
import java.util.logging.Level;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.filter.CharacterEncodingFilter;
import org.springframework.web.servlet.support.AbstractAnnotationConfigDispatcherServletInitializer;

public class Initializer
extends AbstractAnnotationConfigDispatcherServletInitializer {
    public static final String PROFILE_APP_CDS = "app-cds";
    public static final String PROFILE_DEV = "dev";
    public static final String PROFILE_INTEGRATION_TEST = "integration-test";
    public static final String PROFILE_LIVE = "!dev";
    static final String PROFILE_SPRING_BOOT = "spring-boot";
    public static final String PROFILE_DEMO = "demo";
    public static final String PROFILE_OPENID = "openid";
    public static final String PROFILE_DISABLE_JOBS = "disable-jobs";
    public static final String API_V2_PUBLIC_PATH = "/api/v2/public/";
    public static final String XSRF_TOKEN = "XSRF-TOKEN";

    public void onStartup(ServletContext servletContext) throws ServletException {
        super.onStartup(servletContext);
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultExceptionHandler());
        CharacterEncodingFilter cef = new CharacterEncodingFilter();
        cef.setEncoding("UTF-8");
        cef.setForceEncoding(true);
        FilterRegistration.Dynamic characterEncodingFilter = servletContext.addFilter("CharacterEncodingFilter", (Filter)cef);
        characterEncodingFilter.setAsyncSupported(true);
        characterEncodingFilter.addMappingForUrlPatterns(null, false, new String[]{"/*"});
        XRLog.setLevel((String)XRLog.EXCEPTION, (Level)Level.WARNING);
        XRLog.setLoggingEnabled((boolean)false);
    }

    protected WebApplicationContext createRootApplicationContext() {
        ConfigurableWebApplicationContext ctx = (ConfigurableWebApplicationContext)super.createRootApplicationContext();
        Objects.requireNonNull(ctx, "Something really bad is happening...");
        return ctx;
    }

    protected Class<?>[] getRootConfigClasses() {
        return new Class[]{ApplicationPropertiesConfiguration.class, DataSourceConfiguration.class, WebSecurityConfig.class};
    }

    protected Class<?>[] getServletConfigClasses() {
        return new Class[]{MvcConfiguration.class};
    }

    protected String[] getServletMappings() {
        return new String[]{"/"};
    }
}

