/*
 * Decompiled with CFR 0.152.
 */
package alfio.config;

import alfio.config.MvcConfiguration;
import alfio.config.support.HeaderPublisherFilter;
import alfio.manager.system.ConfigurationManager;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.http.CacheControl;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.jdbc.config.annotation.web.http.EnableJdbcHttpSession;
import org.springframework.session.security.SpringSessionBackedSessionRegistry;
import org.springframework.session.web.http.CookieHttpSessionIdResolver;
import org.springframework.session.web.http.CookieSerializer;
import org.springframework.session.web.http.HeaderHttpSessionIdResolver;
import org.springframework.session.web.http.HttpSessionIdResolver;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.view.AbstractUrlBasedView;
import org.springframework.web.servlet.view.UrlBasedViewResolver;

@Configuration(proxyBeanMethods=false)
@ComponentScan(basePackages={"alfio.controller", "alfio.config"})
@EnableWebMvc
@EnableJdbcHttpSession(maxInactiveIntervalInSeconds=14400, tableName="ALFIO_SPRING_SESSION")
public class MvcConfiguration
implements WebMvcConfigurer {
    private final Environment environment;
    private final String alfioVersion;
    private final ObjectMapper objectMapper;

    public MvcConfiguration(Environment environment, @Value(value="${alfio.version}") String alfioVersion, ObjectMapper objectMapper) {
        this.environment = environment;
        this.alfioVersion = alfioVersion;
        this.objectMapper = objectMapper;
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        boolean isLive = this.environment.acceptsProfiles(Profiles.of((String[])new String[]{"!dev"}));
        int cacheMinutes = isLive ? 15 : 0;
        CacheControl defaultCacheControl = CacheControl.maxAge((Duration)Duration.ofDays(isLive ? 10L : 0L)).mustRevalidate();
        registry.addResourceHandler(new String[]{"/resources/font/*", this.alfioVersion + "/resources/font/*"}).addResourceLocations(new String[]{"classpath:/font/"}).setCachePeriod(Integer.valueOf(cacheMinutes * 60)).setCacheControl(defaultCacheControl);
        registry.addResourceHandler(new String[]{"/resources/images/**", this.alfioVersion + "/resources/images/**"}).addResourceLocations(new String[]{"classpath:/images/"}).setCachePeriod(Integer.valueOf(cacheMinutes * 60)).setCacheControl(defaultCacheControl);
        registry.addResourceHandler(new String[]{this.alfioVersion + "/resources/**"}).addResourceLocations(new String[]{"classpath:/alfio-admin-v1/"}).setCachePeriod(Integer.valueOf(cacheMinutes * 60)).setCacheControl(defaultCacheControl);
        registry.addResourceHandler(new String[]{"/frontend-public/**"}).addResourceLocations(new String[]{"classpath:/resources/alfio-public-frontend/"}).setCachePeriod(Integer.valueOf(cacheMinutes * 60)).setCacheControl(CacheControl.maxAge((Duration)Duration.ofDays(60L)));
        registry.addResourceHandler(new String[]{this.alfioVersion + "/frontend-admin/**"}).addResourceLocations(new String[]{"classpath:/resources/alfio-admin-frontend/"}).setCachePeriod(Integer.valueOf(cacheMinutes * 60)).setCacheControl(CacheControl.maxAge((Duration)Duration.ofDays(60L)));
    }

    @Bean
    public ExcludeSessionRepositoryFilter excludeSessionRepositoryFilter() {
        return new ExcludeSessionRepositoryFilter(this.alfioVersion);
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.add((HttpMessageConverter<?>)this.jacksonMessageConverter(this.objectMapper));
        StringHttpMessageConverter converter = new StringHttpMessageConverter();
        converter.setSupportedMediaTypes(Collections.singletonList(MediaType.ALL));
        converters.add((HttpMessageConverter<?>)converter);
    }

    private MappingJackson2HttpMessageConverter jacksonMessageConverter(ObjectMapper objectMapper) {
        MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter();
        converter.setObjectMapper(objectMapper);
        return converter;
    }

    @Bean
    public HeaderPublisherFilter headerPublisherFilter(ConfigurationManager configurationManager) {
        return new HeaderPublisherFilter(configurationManager);
    }

    @Bean
    public ViewResolver viewResolver() {
        UrlBasedViewResolver resolver = new UrlBasedViewResolver();
        resolver.setViewClass(AbstractUrlBasedView.class);
        return resolver;
    }

    @Bean
    public SpringSessionBackedSessionRegistry<?> sessionRegistry(FindByIndexNameSessionRepository<?> sessionRepository) {
        return new SpringSessionBackedSessionRegistry(sessionRepository);
    }

    @Bean
    public HttpSessionIdResolver httpSessionIdResolver(CookieSerializer cookieSerializer) {
        AntPathRequestMatcher publicRequestMatcher = new AntPathRequestMatcher("/api/v2/public/**");
        HeaderHttpSessionIdResolver headerSessionIdResolver = HeaderHttpSessionIdResolver.xAuthToken();
        CookieHttpSessionIdResolver cookieSessionIdResolver = new CookieHttpSessionIdResolver();
        cookieSessionIdResolver.setCookieSerializer(cookieSerializer);
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

