/*
 * Decompiled with CFR 0.152.
 */
package alfio.config;

import alfio.config.authentication.support.OpenIdPrincipal;
import jakarta.servlet.http.HttpServletRequest;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

/*
 * Exception performing whole class analysis ignored.
 */
class RoleAndOrganizationsTransactionPreparer {
    private static final Logger log = LoggerFactory.getLogger(RoleAndOrganizationsTransactionPreparer.class);
    private static final OrRequestMatcher IS_PUBLIC_URLS = new OrRequestMatcher(new RequestMatcher[]{new AntPathRequestMatcher("/resources/**"), new AntPathRequestMatcher("/webjars/**"), new AntPathRequestMatcher("/event/**"), new AntPathRequestMatcher("/"), new AntPathRequestMatcher("/file/**"), new AntPathRequestMatcher("/api/events/**"), new AntPathRequestMatcher("/api/webhook/**"), new AntPathRequestMatcher("/api/payment/**"), new AntPathRequestMatcher("/api/pass/**"), new AntPathRequestMatcher("/api/v2/info"), new AntPathRequestMatcher("/api/v2/public/**"), new AntPathRequestMatcher("/session-expired"), new AntPathRequestMatcher("/authentication")});
    private static final String QUERY_ORG_FOR_USER = "(select organization.id from organization inner join j_user_organization on org_id = organization.id where j_user_organization.user_id = (select ba_user.id from ba_user where ba_user.username = ?))  union (select organization.id from organization where 'ROLE_ADMIN' in (select role from ba_user inner join authority on ba_user.username = authority.username where ba_user.username = ?))";

    private RoleAndOrganizationsTransactionPreparer() {
    }

    private static boolean isCurrentlyInAPublicUrlRequest() {
        HttpServletRequest request = Objects.requireNonNull((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        return IS_PUBLIC_URLS.matches(request);
    }

    private static boolean isInAHttpRequest() {
        return RequestContextHolder.getRequestAttributes() != null;
    }

    private static boolean isLoggedUser() {
        SecurityContext context = SecurityContextHolder.getContext();
        if (context != null && context.getAuthentication() != null) {
            return !"anonymousUser".equals(context.getAuthentication().getName());
        }
        return false;
    }

    private static boolean isPublic() {
        OAuth2AuthenticationToken oauth;
        Authentication authentication;
        SecurityContext context = SecurityContextHolder.getContext();
        if (context != null && (authentication = context.getAuthentication()) instanceof OAuth2AuthenticationToken && (authentication = (oauth = (OAuth2AuthenticationToken)authentication).getPrincipal()) instanceof OpenIdPrincipal) {
            OpenIdPrincipal principal = (OpenIdPrincipal)authentication;
            return principal.user().isPublicUser();
        }
        return false;
    }

    private static boolean isAdmin() {
        if (RoleAndOrganizationsTransactionPreparer.isLoggedUser()) {
            return SecurityContextHolder.getContext().getAuthentication().getAuthorities().stream().map(GrantedAuthority::getAuthority).anyMatch(authority -> authority.equals("ROLE_SYSTEM_API_CLIENT") || authority.equals("ROLE_ADMIN"));
        }
        return false;
    }

    public static void prepareTransactionalConnection(Connection connection) throws SQLException {
        boolean mustCheck;
        if (!RoleAndOrganizationsTransactionPreparer.isInAHttpRequest()) {
            return;
        }
        boolean bl = mustCheck = !RoleAndOrganizationsTransactionPreparer.isCurrentlyInAPublicUrlRequest() && RoleAndOrganizationsTransactionPreparer.isLoggedUser() && !RoleAndOrganizationsTransactionPreparer.isPublic() && !RoleAndOrganizationsTransactionPreparer.isAdmin();
        if (!mustCheck) {
            return;
        }
        try (Statement s = connection.createStatement();){
            s.execute("reset alfio.checkRowAccess");
        }
        s = connection.createStatement();
        try {
            s.execute("reset alfio.currentUserOrgs");
        }
        finally {
            if (s != null) {
                s.close();
            }
        }
        TreeSet<Integer> orgIds = new TreeSet<Integer>();
        try (Statement s = connection.prepareStatement("(select organization.id from organization inner join j_user_organization on org_id = organization.id where j_user_organization.user_id = (select ba_user.id from ba_user where ba_user.username = ?))  union (select organization.id from organization where 'ROLE_ADMIN' in (select role from ba_user inner join authority on ba_user.username = authority.username where ba_user.username = ?))");){
            String username = SecurityContextHolder.getContext().getAuthentication().getName();
            s.setString(1, username);
            s.setString(2, username);
            try (ResultSet rs = s.executeQuery();){
                while (rs.next()) {
                    orgIds.add(rs.getInt(1));
                }
            }
        }
        if (orgIds.isEmpty()) {
            log.warn("orgIds is empty, was not able to apply currentUserOrgs");
        } else {
            s = connection.createStatement();
            try {
                s.execute("set local alfio.checkRowAccess = true");
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
            s = connection.createStatement();
            try {
                String formattedOrgIds = orgIds.stream().map(orgId -> Integer.toString(orgId)).collect(Collectors.joining(","));
                s.execute("set local alfio.currentUserOrgs = '" + formattedOrgIds + "'");
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
    }
}

