/*
 * Decompiled with CFR 0.152.
 */
package alfio.config;

import alfio.config.support.ContextAwareCookieSerializer;
import alfio.util.ClockProvider;
import com.openhtmltopdf.util.XRLog;
import jakarta.servlet.Filter;
import java.time.Clock;
import java.util.logging.Level;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.flyway.FlywayAutoConfiguration;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceTransactionManagerAutoConfiguration;
import org.springframework.boot.autoconfigure.mustache.MustacheAutoConfiguration;
import org.springframework.boot.autoconfigure.quartz.QuartzAutoConfiguration;
import org.springframework.boot.autoconfigure.security.servlet.UserDetailsServiceAutoConfiguration;
import org.springframework.boot.autoconfigure.session.SessionAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.HttpEncodingAutoConfiguration;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.session.web.http.CookieSerializer;
import org.springframework.web.filter.CharacterEncodingFilter;

@EnableAutoConfiguration(exclude={MustacheAutoConfiguration.class, FlywayAutoConfiguration.class, JacksonAutoConfiguration.class, HttpEncodingAutoConfiguration.class, SessionAutoConfiguration.class, QuartzAutoConfiguration.class, DataSourceTransactionManagerAutoConfiguration.class, UserDetailsServiceAutoConfiguration.class})
@Configuration(proxyBeanMethods=false)
public class SpringBootInitializer {
    @Bean
    public ServletContextInitializer servletContextInitializer() {
        return servletContext -> {
            XRLog.setLevel((String)XRLog.EXCEPTION, (Level)Level.WARNING);
            XRLog.setLoggingEnabled((boolean)false);
        };
    }

    @Bean
    public CookieSerializer cookieSerializer(Environment environment) {
        return new ContextAwareCookieSerializer(environment);
    }

    @Bean
    public Filter characterEncodingFilter() {
        CharacterEncodingFilter cef = new CharacterEncodingFilter();
        cef.setEncoding("UTF-8");
        cef.setForceEncoding(true);
        return cef;
    }

    @Bean
    public ClockProvider clockProvider() {
        return ClockProvider.init((Clock)Clock.systemUTC());
    }
}

