/*
 * Decompiled with CFR 0.152.
 */
package alfio.config;

import alfio.config.BaseConfiguration;
import alfio.config.DataSourceConfiguration;
import alfio.config.MvcConfiguration;
import alfio.config.SpringBootInitializer;
import alfio.config.WebSecurityConfig;
import alfio.util.DefaultExceptionHandler;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;

public class SpringBootLauncher {
    private static final Logger log = LoggerFactory.getLogger(SpringBootLauncher.class);

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultExceptionHandler());
        String profiles = System.getProperty("spring.profiles.active", "");
        SpringApplication application = new SpringApplication(new Class[]{SpringBootInitializer.class, BaseConfiguration.class, DataSourceConfiguration.class, WebSecurityConfig.class, MvcConfiguration.class});
        ArrayList<String> additionalProfiles = new ArrayList<String>();
        additionalProfiles.add("spring-boot");
        if ("true".equals(System.getenv("ALFIO_DEMO_ENABLED"))) {
            additionalProfiles.add("demo");
        }
        application.setAdditionalProfiles(additionalProfiles.toArray(new String[0]));
        ConfigurableApplicationContext applicationContext = application.run(args);
        ConfigurableEnvironment environment = applicationContext.getEnvironment();
        log.info("profiles: requested {}, active {}", (Object)profiles, (Object)String.join((CharSequence)", ", environment.getActiveProfiles()));
    }
}

