/*
 * Decompiled with CFR 0.152.
 */
package alfio.config.authentication;

import alfio.config.authentication.support.APIKeyAuthFilter;
import alfio.config.authentication.support.APITokenAuthentication;
import alfio.config.authentication.support.RequestTypeMatchers;
import alfio.config.authentication.support.WrongAccountTypeException;
import alfio.model.system.ConfigurationKeys;
import alfio.model.user.User;
import alfio.repository.system.ConfigurationRepository;
import alfio.repository.user.AuthorityRepository;
import alfio.repository.user.UserRepository;
import alfio.util.ClockProvider;
import jakarta.servlet.Filter;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.util.matcher.RequestMatcher;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration(proxyBeanMethods=false)
public class APITokenAuthWebSecurity {
    public static final String API_KEY = "Api key ";
    private final UserRepository userRepository;
    private final AuthorityRepository authorityRepository;
    private final ConfigurationRepository configurationRepository;

    public APITokenAuthWebSecurity(UserRepository userRepository, AuthorityRepository authorityRepository, ConfigurationRepository configurationRepository) {
        this.userRepository = userRepository;
        this.authorityRepository = authorityRepository;
        this.configurationRepository = configurationRepository;
    }

    @Bean
    @Order(value=-2147483648)
    public SecurityFilterChain configure(HttpSecurity http) throws Exception {
        APIKeyAuthFilter filter = new APIKeyAuthFilter();
        filter.setAuthenticationManager(authentication -> {
            String apiKey = (String)authentication.getPrincipal();
            Optional systemApiKeyOptional = this.configurationRepository.findOptionalByKey(ConfigurationKeys.SYSTEM_API_KEY.name());
            if (systemApiKeyOptional.isPresent() && APITokenAuthWebSecurity.apiKeyMatches((String)apiKey, (alfio.model.system.Configuration)((alfio.model.system.Configuration)systemApiKeyOptional.get()))) {
                return new APITokenAuthentication(authentication.getPrincipal(), authentication.getCredentials(), List.of(new SimpleGrantedAuthority("ROLE_SYSTEM_API_CLIENT")));
            }
            User user = (User)this.userRepository.findByUsername(apiKey).orElseThrow(() -> new BadCredentialsException("Api key " + apiKey + " don't exists"));
            if (!user.isEnabled()) {
                throw new DisabledException("Api key " + apiKey + " is disabled");
            }
            if (User.Type.API_KEY != user.getType()) {
                throw new WrongAccountTypeException("Wrong account type for username " + apiKey);
            }
            if (!user.isCurrentlyValid(ZonedDateTime.now(ClockProvider.clock()))) {
                throw new DisabledException("Api key " + apiKey + " is expired");
            }
            return new APITokenAuthentication(authentication.getPrincipal(), authentication.getCredentials(), this.authorityRepository.findRoles(apiKey).stream().map(SimpleGrantedAuthority::new).toList());
        });
        return (SecurityFilterChain)http.securityMatchers(matchers -> matchers.requestMatchers(new RequestMatcher[]{RequestTypeMatchers::isTokenAuthentication})).sessionManagement(management -> management.sessionCreationPolicy(SessionCreationPolicy.STATELESS)).csrf(AbstractHttpConfigurer::disable).authorizeHttpRequests(APITokenAuthWebSecurity::configureMatchers).addFilter((Filter)filter).build();
    }

    private static void configureMatchers(AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry auth) {
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.requestMatchers(new String[]{"/api/v1/admin/system/**"})).hasRole("SYSTEM_API_CLIENT").requestMatchers(new String[]{"/api/v1/admin/**"})).hasRole("API_CLIENT").requestMatchers(new String[]{"/admin/api/check-in/event/*/attendees"})).hasRole("SUPERVISOR").requestMatchers(new String[]{"/admin/api/check-in/*/label-layout"})).hasAnyRole(new String[]{"OPERATOR", "SUPERVISOR", "SPONSOR"}).requestMatchers(new String[]{"/admin/api/check-in/**"})).hasAnyRole(new String[]{"OPERATOR", "SUPERVISOR"}).requestMatchers(HttpMethod.GET, new String[]{"/admin/api/events"})).hasAnyRole(new String[]{"OPERATOR", "SUPERVISOR", "SPONSOR"}).requestMatchers(HttpMethod.GET, new String[]{"/admin/api/user-type", "/admin/api/user/details"})).hasAnyRole(new String[]{"OPERATOR", "SUPERVISOR", "SPONSOR"}).requestMatchers(new String[]{"/admin/api/**"})).denyAll().requestMatchers(HttpMethod.POST, new String[]{"/api/attendees/sponsor-scan"})).hasRole("SPONSOR").requestMatchers(HttpMethod.GET, new String[]{"/api/attendees/*/ticket/*"})).hasAnyRole(new String[]{"OPERATOR", "SUPERVISOR", "SPONSOR"}).requestMatchers(new String[]{"/**"})).authenticated();
    }

    private static boolean apiKeyMatches(String input, alfio.model.system.Configuration systemApiKeyConfiguration) {
        return MessageDigest.isEqual(input.getBytes(StandardCharsets.UTF_8), systemApiKeyConfiguration.getValue().getBytes(StandardCharsets.UTF_8));
    }
}

