/*
 * Decompiled with CFR 0.152.
 */
package alfio.config.authentication;

import alfio.config.authentication.OpenIdUserSynchronizer;
import alfio.config.authentication.support.OpenIdAlfioUser;
import alfio.config.authentication.support.OpenIdLoginSuccessHandler;
import alfio.config.authentication.support.OpenIdPrincipal;
import alfio.config.authentication.support.PaymentProviderConnectFilter;
import alfio.config.authentication.support.PreAuthCookieWriterFilter;
import alfio.config.authentication.support.PublicOpenIdRequestResolver;
import alfio.config.authentication.support.RecaptchaLoginFilter;
import alfio.config.authentication.support.UserCreatorBeforeLoginFilter;
import alfio.config.authentication.support.UserProvidedClientRegistrationRepository;
import alfio.config.challenge.CFTurnstileVerificationFilter;
import alfio.config.support.ContextAwareCookieSerializer;
import alfio.manager.RecaptchaService;
import alfio.manager.openid.OpenIdConfiguration;
import alfio.manager.payment.MollieConnectManager;
import alfio.manager.payment.StripeConnectManager;
import alfio.manager.system.ConfigurationManager;
import alfio.manager.user.UserManager;
import alfio.model.system.ConfigurationKeys;
import alfio.model.user.User;
import alfio.util.Json;
import alfio.util.TemplateManager;
import jakarta.servlet.Filter;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.ChannelSecurityConfigurer;
import org.springframework.security.config.annotation.web.configurers.CsrfConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.config.annotation.web.configurers.LogoutConfigurer;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserService;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestRedirectFilter;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.provisioning.JdbcUserDetailsManager;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.NegatedRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestHeaderRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.session.security.SpringSessionBackedSessionRegistry;
import org.springframework.session.web.http.CookieSerializer;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
abstract class AbstractFormBasedWebSecurity {
    public static final String AUTHENTICATE = "/authenticate";
    private static final Logger log = LoggerFactory.getLogger(AbstractFormBasedWebSecurity.class);
    private static final List<String> OWNERSHIP_REQUIRED = List.of("/admin/api/overridable-template", "/admin/api/additional-services", "/admin/api/events/*/additional-field", "/admin/api/event/*/additional-services/", "/admin/api/overridable-template/", "/admin/api/events/*/promo-code", "/admin/api/reservation/event/*/reservations/list", "/admin/api/event/*/email/", "/admin/api/event/*/waiting-queue/load", "/admin/api/events/*/pending-payments", "/admin/api/events/*/export", "/admin/api/events/*/sponsor-scan/export", "/admin/api/events/*/invoices/**", "/admin/api/reservation/*/*/*/audit", "/admin/api/subscription/*/email/", "/admin/api/organization/*/subscription/**", "/admin/api/reservation/subscription/**");
    private final Environment environment;
    protected final UserManager userManager;
    private final RecaptchaService recaptchaService;
    private final ConfigurationManager configurationManager;
    private final CsrfTokenRepository csrfTokenRepository;
    private final DataSource dataSource;
    protected final PasswordEncoder passwordEncoder;
    private final SpringSessionBackedSessionRegistry<?> sessionRegistry;
    protected final OpenIdUserSynchronizer openIdUserSynchronizer;
    protected final ContextAwareCookieSerializer cookieSerializer;
    protected final TemplateManager templateManager;

    protected AbstractFormBasedWebSecurity(Environment environment, UserManager userManager, RecaptchaService recaptchaService, ConfigurationManager configurationManager, CsrfTokenRepository csrfTokenRepository, DataSource dataSource, PasswordEncoder passwordEncoder, SpringSessionBackedSessionRegistry<?> sessionRegistry, OpenIdUserSynchronizer openIdUserSynchronizer, CookieSerializer cookieSerializer, TemplateManager templateManager) {
        this.environment = environment;
        this.userManager = userManager;
        this.recaptchaService = recaptchaService;
        this.configurationManager = configurationManager;
        this.csrfTokenRepository = csrfTokenRepository;
        this.dataSource = dataSource;
        this.passwordEncoder = passwordEncoder;
        this.sessionRegistry = sessionRegistry;
        this.openIdUserSynchronizer = openIdUserSynchronizer;
        this.cookieSerializer = (ContextAwareCookieSerializer)cookieSerializer;
        this.templateManager = templateManager;
    }

    @Bean
    public SecurityFilterChain publicOpenId(HttpSecurity http) throws Exception {
        AbstractFormBasedWebSecurity.configureExceptionHandling((HttpSecurity)http);
        AbstractFormBasedWebSecurity.configureCsrf((HttpSecurity)http, (T configurer) -> configurer.csrfTokenRepository(this.csrfTokenRepository));
        http.securityMatcher((RequestMatcher)new AntPathRequestMatcher("/openid/**")).headers(headers -> headers.frameOptions(HeadersConfigurer.FrameOptionsConfig::disable)).authorizeHttpRequests(auth -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.anyRequest()).authenticated()).sessionManagement(management -> management.maximumSessions(-1).sessionRegistry((SessionRegistry)this.sessionRegistry));
        UserProvidedClientRegistrationRepository registrationRepository = new UserProvidedClientRegistrationRepository(this.configurationManager);
        http.oauth2Login(oauth -> oauth.loginPage("/openid/authentication").loginProcessingUrl("/openid/callback").clientRegistrationRepository((ClientRegistrationRepository)registrationRepository).authorizationEndpoint(auth -> auth.authorizationRequestResolver((OAuth2AuthorizationRequestResolver)new PublicOpenIdRequestResolver(registrationRepository))).userInfoEndpoint(uie -> uie.oidcUserService(this.publicOidcUserService(this.configurationManager))).successHandler((AuthenticationSuccessHandler)new OpenIdLoginSuccessHandler(this.templateManager, this.cookieSerializer)));
        http.addFilterBefore((Filter)new PreAuthCookieWriterFilter(this.cookieSerializer, (RequestMatcher)new AntPathRequestMatcher("/openid/authentication")), OAuth2AuthorizationRequestRedirectFilter.class);
        AbstractFormBasedWebSecurity.disableRequestCacheParameter((HttpSecurity)http);
        return (SecurityFilterChain)http.build();
    }

    @Bean
    public SecurityFilterChain filterChain(HttpSecurity http, StripeConnectManager stripeConnectManager, MollieConnectManager mollieConnectManager) throws Exception {
        if (this.environment.acceptsProfiles(Profiles.of((String[])new String[]{"!dev"}))) {
            http.requiresChannel(channel -> ((ChannelSecurityConfigurer.RequiresChannelUrl)channel.requestMatchers(new String[]{"/healthz"})).requiresInsecure()).requiresChannel(channel -> ((ChannelSecurityConfigurer.RequiresChannelUrl)channel.requestMatchers(new String[]{"/**"})).requiresSecure());
        }
        AbstractFormBasedWebSecurity.configureExceptionHandling((HttpSecurity)http);
        AbstractFormBasedWebSecurity.configureCsrf((HttpSecurity)http, (T configurer) -> configurer.csrfTokenRepository(this.csrfTokenRepository));
        http.headers(headers -> headers.frameOptions(HeadersConfigurer.FrameOptionsConfig::disable)).authorizeHttpRequests(AbstractFormBasedWebSecurity::authorizeRequests).sessionManagement(management -> management.maximumSessions(-1).sessionRegistry((SessionRegistry)this.sessionRegistry));
        this.setupAuthenticationEndpoint(http);
        http.addFilterBefore((Filter)new RecaptchaLoginFilter(this.recaptchaService, "/authenticate", "/authentication?recaptchaFailed", this.configurationManager), UsernamePasswordAuthenticationFilter.class).addFilterBefore((Filter)new CFTurnstileVerificationFilter(this.configurationManager, (RequestMatcher)new OrRequestMatcher(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((HttpMethod)HttpMethod.POST, (String)"/api/v2/public/event/{name}/reserve-tickets"), AntPathRequestMatcher.antMatcher((HttpMethod)HttpMethod.POST, (String)"/api/v2/public/subscription/{id}")})), RecaptchaLoginFilter.class).addFilterAfter((Filter)new PaymentProviderConnectFilter(this.templateManager, this.userManager, stripeConnectManager, mollieConnectManager), CFTurnstileVerificationFilter.class);
        if (this.environment.acceptsProfiles(Profiles.of((String[])new String[]{"demo"}))) {
            http.addFilterAfter((Filter)new UserCreatorBeforeLoginFilter(this.userManager, "/authenticate"), RecaptchaLoginFilter.class);
        }
        AbstractFormBasedWebSecurity.disableRequestCacheParameter((HttpSecurity)http);
        return (SecurityFilterChain)http.addFilterAfter(this.csrfPublisherFilter(), CsrfFilter.class).build();
    }

    private static void disableRequestCacheParameter(HttpSecurity http) throws Exception {
        HttpSessionRequestCache requestCache = new HttpSessionRequestCache();
        requestCache.setMatchingRequestParameterName(null);
        http.requestCache(cache -> cache.requestCache((RequestCache)requestCache));
    }

    private OAuth2UserService<OidcUserRequest, OidcUser> publicOidcUserService(ConfigurationManager configurationManager) {
        OidcUserService delegate = new OidcUserService();
        return userRequest -> {
            OidcUser oidcUser = delegate.loadUser(userRequest);
            OpenIdAlfioUser alfioUser = new OpenIdAlfioUser(null, oidcUser.getSubject(), oidcUser.getEmail(), User.Type.PUBLIC, Set.of(), Map.of());
            OpenIdConfiguration configuration = (OpenIdConfiguration)Json.fromJson((String)((ConfigurationManager.MaybeConfiguration)configurationManager.getPublicOpenIdConfiguration().get(ConfigurationKeys.OPENID_CONFIGURATION_JSON)).getRequiredValue(), OpenIdConfiguration.class);
            boolean signedUp = this.openIdUserSynchronizer.syncUser(oidcUser, alfioUser, configuration);
            return new OpenIdPrincipal(List.of(), oidcUser.getIdToken(), oidcUser.getUserInfo(), alfioUser, AbstractFormBasedWebSecurity.buildLogoutUrl((OpenIdConfiguration)configuration), signedUp);
        };
    }

    protected void setupAuthenticationEndpoint(HttpSecurity http) throws Exception {
        http.authenticationManager(this.createAuthenticationManager()).formLogin(login -> ((FormLoginConfigurer)((FormLoginConfigurer)login.loginPage("/authentication").loginProcessingUrl("/authenticate")).defaultSuccessUrl("/admin")).failureUrl("/authentication?failed")).logout(LogoutConfigurer::permitAll);
    }

    private JdbcUserDetailsManager createUserDetailsManager() {
        JdbcUserDetailsManager userDetailsManager = new JdbcUserDetailsManager(this.dataSource);
        userDetailsManager.setUsersByUsernameQuery("select username, password, enabled from ba_user where username = ?");
        userDetailsManager.setAuthoritiesByUsernameQuery("select username, role from authority where username = ?");
        return userDetailsManager;
    }

    protected final AuthenticationManager createAuthenticationManager() {
        JdbcUserDetailsManager userDetailsManager = this.createUserDetailsManager();
        DaoAuthenticationProvider daoAuthenticationProvider = new DaoAuthenticationProvider();
        daoAuthenticationProvider.setPasswordEncoder(this.passwordEncoder);
        daoAuthenticationProvider.setUserDetailsService((UserDetailsService)userDetailsManager);
        return new ProviderManager(List.of(daoAuthenticationProvider));
    }

    private Filter csrfPublisherFilter() {
        return (servletRequest, servletResponse, filterChain) -> {
            HttpServletRequest req = (HttpServletRequest)servletRequest;
            HttpServletResponse res = (HttpServletResponse)servletResponse;
            String reqUri = req.getRequestURI();
            if ((reqUri.startsWith("/api/v2/public/") || reqUri.startsWith("/admin/api") || reqUri.startsWith("/api/v2/admin/") || reqUri.equals("/authentication-status")) && "GET".equalsIgnoreCase(req.getMethod())) {
                CsrfToken token = (CsrfToken)req.getAttribute("_csrf");
                if (token != null) {
                    String csrfToken = token.getToken();
                    res.addHeader("XSRF-TOKEN", csrfToken);
                    if (!reqUri.startsWith("/api/v2/public/")) {
                        this.addCookie(res, csrfToken);
                    }
                } else {
                    log.warn("Expected CSRF token for request {} but none found.", (Object)reqUri);
                }
            }
            filterChain.doFilter(servletRequest, servletResponse);
        };
    }

    private static void authorizeRequests(AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry auth) {
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((String)"/api/v1/admin/**")})).denyAll().requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((HttpMethod)HttpMethod.GET, (String)"/admin/api/users/current")})).hasAnyRole(new String[]{"ADMIN", "OWNER", "SUPERVISOR"}).requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((HttpMethod)HttpMethod.POST, (String)"/admin/api/users/check"), AntPathRequestMatcher.antMatcher((HttpMethod)HttpMethod.POST, (String)"/admin/api/users/current/edit"), AntPathRequestMatcher.antMatcher((HttpMethod)HttpMethod.POST, (String)"/admin/api/users/current/update-password")})).hasAnyRole(new String[]{"ADMIN", "OWNER", "SUPERVISOR"}).requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((String)"/admin/api/configuration/**"), AntPathRequestMatcher.antMatcher((String)"/admin/api/users/**")})).hasAnyRole(new String[]{"ADMIN", "OWNER"}).requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((String)"/admin/api/organizations/new"), AntPathRequestMatcher.antMatcher((String)"/admin/api/system/**")})).hasRole("ADMIN").requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((String)"/admin/api/check-in/**")})).hasAnyRole(new String[]{"ADMIN", "OWNER", "SUPERVISOR"}).requestMatchers((RequestMatcher[])OWNERSHIP_REQUIRED.stream().map(u -> AntPathRequestMatcher.antMatcher((HttpMethod)HttpMethod.GET, (String)u)).toArray(RequestMatcher[]::new))).hasAnyRole(new String[]{"ADMIN", "OWNER"}).requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((HttpMethod)HttpMethod.GET, (String)"/admin/api/**")})).hasAnyRole(new String[]{"ADMIN", "OWNER", "SUPERVISOR"}).requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((HttpMethod)HttpMethod.POST, (String)"/admin/api/reservation/event/*/new"), AntPathRequestMatcher.antMatcher((HttpMethod)HttpMethod.POST, (String)"/admin/api/reservation/event/*/*")})).hasAnyRole(new String[]{"ADMIN", "OWNER", "SUPERVISOR"}).requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((HttpMethod)HttpMethod.PUT, (String)"/admin/api/reservation/event/*/*/notify"), AntPathRequestMatcher.antMatcher((HttpMethod)HttpMethod.PUT, (String)"/admin/api/reservation/event/*/*/notify-attendees"), AntPathRequestMatcher.antMatcher((HttpMethod)HttpMethod.PUT, (String)"/admin/api/reservation/event/*/*/confirm")})).hasAnyRole(new String[]{"ADMIN", "OWNER", "SUPERVISOR"}).requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((String)"/admin/api/**")})).hasAnyRole(new String[]{"ADMIN", "OWNER"}).requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((String)"/admin/**/export/**")})).hasAnyRole(new String[]{"ADMIN", "OWNER"}).requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((String)"/admin/**")})).hasAnyRole(new String[]{"ADMIN", "OWNER", "SUPERVISOR"}).requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((String)"/api/attendees/**")})).denyAll().requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((String)"/callback")})).permitAll().requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((String)"/**")})).permitAll();
    }

    private static void configureExceptionHandling(HttpSecurity http) throws Exception {
        http.exceptionHandling(handling -> handling.accessDeniedHandler((request, response, accessDeniedException) -> {
            if (!response.isCommitted()) {
                if ("XMLHttpRequest".equals(request.getHeader("X-Requested-With"))) {
                    response.setStatus(403);
                } else if (!response.isCommitted()) {
                    response.setStatus(403);
                    RequestDispatcher dispatcher = request.getRequestDispatcher("/session-expired");
                    dispatcher.forward((ServletRequest)request, (ServletResponse)response);
                }
            }
        }).defaultAuthenticationEntryPointFor((request, response, ex) -> response.sendError(401), (RequestMatcher)new RequestHeaderRequestMatcher("X-Requested-With", "XMLHttpRequest"))).headers(headers -> headers.cacheControl(HeadersConfigurer.CacheControlConfig::disable));
    }

    private static void configureCsrf(HttpSecurity http, Consumer<CsrfConfigurer<HttpSecurity>> additionalConfiguration) throws Exception {
        http.csrf(c -> {
            Pattern methodsPattern = Pattern.compile("^(GET|HEAD|TRACE|OPTIONS)$");
            Predicate<HttpServletRequest> csrfAllowListPredicate = r -> r.getRequestURI().startsWith("/api/webhook/") || r.getRequestURI().startsWith("/api/payment/webhook/") || methodsPattern.matcher(r.getMethod()).matches();
            csrfAllowListPredicate = csrfAllowListPredicate.or(r -> r.getRequestURI().equals("/report-csp-violation"));
            c.requireCsrfProtectionMatcher((RequestMatcher)new NegatedRequestMatcher(csrfAllowListPredicate::test));
            additionalConfiguration.accept((CsrfConfigurer<HttpSecurity>)c);
        });
    }

    private void addCookie(HttpServletResponse res, String csrfToken) {
        Cookie cookie = new Cookie("XSRF-TOKEN", csrfToken);
        cookie.setPath("/");
        boolean prod = this.environment.acceptsProfiles(Profiles.of((String[])new String[]{"!dev"}));
        cookie.setSecure(prod);
        if (prod) {
            cookie.setAttribute("SameSite", "Strict");
        }
        res.addCookie(cookie);
    }

    protected Environment environment() {
        return this.environment;
    }

    protected ConfigurationManager configurationManager() {
        return this.configurationManager;
    }

    protected static String buildLogoutUrl(OpenIdConfiguration openIdConfiguration) {
        UriComponents uri = UriComponentsBuilder.newInstance().scheme("https").host(openIdConfiguration.domain()).path(openIdConfiguration.logoutUrl()).queryParam("redirect_uri", new Object[]{openIdConfiguration.logoutRedirectUrl()}).build();
        return uri.toString();
    }
}

