/*
 * Decompiled with CFR 0.152.
 */
package alfio.config.authentication;

import alfio.config.authentication.AbstractFormBasedWebSecurity;
import alfio.config.authentication.OpenIdUserSynchronizer;
import alfio.config.authentication.support.OpenIdAlfioUser;
import alfio.config.authentication.support.OpenIdLoginSuccessHandler;
import alfio.config.authentication.support.OpenIdPrincipal;
import alfio.config.authentication.support.PreAuthCookieWriterFilter;
import alfio.manager.RecaptchaService;
import alfio.manager.openid.OpenIdConfiguration;
import alfio.manager.system.ConfigurationManager;
import alfio.manager.user.UserManager;
import alfio.model.user.Role;
import alfio.model.user.User;
import alfio.util.TemplateManager;
import jakarta.servlet.Filter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserService;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestRedirectFilter;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.session.security.SpringSessionBackedSessionRegistry;
import org.springframework.session.web.http.CookieSerializer;

/*
 * Exception performing whole class analysis ignored.
 */
@Profile(value={"openid"})
@Configuration(proxyBeanMethods=false)
@Order(value=1)
public class OpenIdAdminWebSecurity
extends AbstractFormBasedWebSecurity {
    private static final Logger log = LoggerFactory.getLogger(OpenIdAdminWebSecurity.class);
    private static final String ALFIO_ADMIN_IDP = "alfio-admin-idp";
    private static final String ADMIN_LOGIN_REDIRECT_PATH = "/oauth2/authorization/alfio-admin-idp";
    private static final String ADMIN_OPENID_CALLBACK_PATH = "/callback";

    public OpenIdAdminWebSecurity(Environment environment, UserManager userManager, RecaptchaService recaptchaService, ConfigurationManager configurationManager, CsrfTokenRepository csrfTokenRepository, DataSource dataSource, PasswordEncoder passwordEncoder, SpringSessionBackedSessionRegistry<?> sessionRegistry, OpenIdUserSynchronizer openIdUserSynchronizer, CookieSerializer cookieSerializer, TemplateManager templateManager) {
        super(environment, userManager, recaptchaService, configurationManager, csrfTokenRepository, dataSource, passwordEncoder, sessionRegistry, openIdUserSynchronizer, cookieSerializer, templateManager);
    }

    protected void setupAuthenticationEndpoint(HttpSecurity http) throws Exception {
        InMemoryClientRegistrationRepository clientRegistrationRepository = new InMemoryClientRegistrationRepository(new ClientRegistration[]{OpenIdConfiguration.from((Environment)this.environment(), (ConfigurationManager)this.configurationManager()).toClientRegistration("alfio-admin-idp", "{baseUrl}/callback", true)});
        http.oauth2Login(oauth -> oauth.loginProcessingUrl("/callback").clientRegistrationRepository((ClientRegistrationRepository)clientRegistrationRepository).userInfoEndpoint(uie -> uie.oidcUserService(this.oidcUserService(OpenIdConfiguration.from((Environment)this.environment(), (ConfigurationManager)this.configurationManager())))).successHandler((AuthenticationSuccessHandler)new OpenIdLoginSuccessHandler(this.templateManager, this.cookieSerializer))).addFilterBefore((Filter)new PreAuthCookieWriterFilter(this.cookieSerializer, (RequestMatcher)new AntPathRequestMatcher("/oauth2/authorization/alfio-admin-idp")), OAuth2AuthorizationRequestRedirectFilter.class);
    }

    private OAuth2UserService<OidcUserRequest, OidcUser> oidcUserService(OpenIdConfiguration openIdConfiguration) {
        OidcUserService delegate = new OidcUserService();
        return userRequest -> {
            OpenIdPrincipal principal;
            OidcUser oidcUser = delegate.loadUser(userRequest);
            List groupsList = (List)oidcUser.getClaim(openIdConfiguration.rolesParameter());
            log.trace("IdToken contains the following groups: {}", (Object)groupsList);
            List<String> groups = groupsList.stream().filter(group -> group.startsWith("ALFIO_")).toList();
            boolean isAdmin = groups.contains("ALFIO_ADMIN");
            if (isAdmin) {
                log.trace("User is admin");
                principal = new OpenIdPrincipal(List.of(new SimpleGrantedAuthority("ROLE_ADMIN")), oidcUser.getIdToken(), oidcUser.getUserInfo(), new OpenIdAlfioUser(null, oidcUser.getSubject(), oidcUser.getEmail(), User.Type.INTERNAL, Set.of(Role.ADMIN), null), OpenIdAdminWebSecurity.buildLogoutUrl((OpenIdConfiguration)openIdConfiguration), false);
            } else {
                principal = OpenIdAdminWebSecurity.parsePrincipal((OpenIdConfiguration)openIdConfiguration, groups, (OidcUser)oidcUser);
            }
            this.openIdUserSynchronizer.syncUser(oidcUser, principal.user(), openIdConfiguration);
            return principal;
        };
    }

    private static OpenIdPrincipal parsePrincipal(OpenIdConfiguration openIdConfiguration, List<String> groups, OidcUser oidcUser) {
        log.trace("User is NOT admin");
        if (groups.isEmpty()) {
            String message = "Users must have at least a group called ALFIO_ADMIN or ALFIO_BACKOFFICE";
            log.error(message);
            throw new RuntimeException(message);
        }
        List alfioOrganizationAuthorizationsRaw = (List)oidcUser.getClaim(openIdConfiguration.alfioGroupsParameter());
        log.trace("IdToken contains the following alfioGroups: {}", (Object)alfioOrganizationAuthorizationsRaw);
        Map alfioOrganizationAuthorizations = OpenIdAdminWebSecurity.extractOrganizationRoles((List)alfioOrganizationAuthorizationsRaw);
        Set alfioRoles = OpenIdAdminWebSecurity.extractAlfioRoles((Map)alfioOrganizationAuthorizations);
        Set mappedAuthorities = alfioRoles.stream().map(r -> new SimpleGrantedAuthority(r.getRoleName())).collect(Collectors.toSet());
        OpenIdAlfioUser alfioUser = new OpenIdAlfioUser(null, oidcUser.getSubject(), oidcUser.getEmail(), User.Type.INTERNAL, alfioRoles, alfioOrganizationAuthorizations);
        OpenIdPrincipal principal = new OpenIdPrincipal(mappedAuthorities, oidcUser.getIdToken(), oidcUser.getUserInfo(), alfioUser, OpenIdAdminWebSecurity.buildLogoutUrl((OpenIdConfiguration)openIdConfiguration), false);
        return principal;
    }

    private static Map<String, Set<String>> extractOrganizationRoles(List<String> alfioOrganizationAuthorizationsRaw) {
        HashMap<String, Set<String>> alfioOrganizationAuthorizations = new HashMap<String, Set<String>>();
        for (String alfioOrgAuth : alfioOrganizationAuthorizationsRaw) {
            String[] orgRole = Pattern.compile("/").split(alfioOrgAuth);
            String organization = orgRole[1];
            String role = orgRole[2];
            if (alfioOrganizationAuthorizations.containsKey(organization)) {
                ((Set)alfioOrganizationAuthorizations.get(organization)).add(role);
                continue;
            }
            HashSet<String> roles = new HashSet<String>();
            roles.add(role);
            alfioOrganizationAuthorizations.put(organization, roles);
        }
        return alfioOrganizationAuthorizations;
    }

    private static Set<Role> extractAlfioRoles(Map<String, Set<String>> alfioOrganizationAuthorizations) {
        HashSet<Role> alfioRoles = new HashSet<Role>();
        alfioOrganizationAuthorizations.keySet().stream().map(alfioOrganizationAuthorizations::get).forEach(authorizations -> authorizations.stream().map(auth -> Role.fromRoleName((String)("ROLE_" + auth))).forEach(alfioRoles::add));
        return alfioRoles;
    }
}

