/*
 * Decompiled with CFR 0.152.
 */
package alfio.config.authentication;

import alfio.config.authentication.support.OpenIdAlfioUser;
import alfio.manager.ExtensionManager;
import alfio.manager.openid.OpenIdConfiguration;
import alfio.manager.user.UserManager;
import alfio.model.user.Organization;
import alfio.model.user.Role;
import alfio.repository.user.AuthorityRepository;
import alfio.repository.user.OrganizationRepository;
import alfio.repository.user.UserRepository;
import alfio.repository.user.join.UserOrganizationRepository;
import alfio.util.PasswordGenerator;
import ch.digitalfondue.npjt.AffectedRowCountAndKey;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
@Transactional
public class OpenIdUserSynchronizer {
    private final TransactionTemplate transactionTemplate;
    private final PasswordEncoder passwordEncoder;
    private final UserManager userManager;
    private final UserRepository userRepository;
    private final UserOrganizationRepository userOrganizationRepository;
    private final NamedParameterJdbcTemplate jdbcTemplate;
    private final AuthorityRepository authorityRepository;
    private final OrganizationRepository organizationRepository;
    private final ExtensionManager extensionManager;

    public OpenIdUserSynchronizer(PlatformTransactionManager transactionManager, PasswordEncoder passwordEncoder, UserManager userManager, UserRepository userRepository, UserOrganizationRepository userOrganizationRepository, NamedParameterJdbcTemplate jdbcTemplate, AuthorityRepository authorityRepository, OrganizationRepository organizationRepository, ExtensionManager extensionManager) {
        this.transactionTemplate = new TransactionTemplate(transactionManager);
        this.passwordEncoder = passwordEncoder;
        this.userManager = userManager;
        this.userRepository = userRepository;
        this.userOrganizationRepository = userOrganizationRepository;
        this.jdbcTemplate = jdbcTemplate;
        this.authorityRepository = authorityRepository;
        this.organizationRepository = organizationRepository;
        this.extensionManager = extensionManager;
    }

    public boolean syncUser(OidcUser oidcUser, OpenIdAlfioUser internalUser, OpenIdConfiguration configuration) {
        return Boolean.TRUE.equals(this.transactionTemplate.execute(tr -> {
            String email = oidcUser.getEmail();
            boolean userSignedUp = false;
            if (!this.userManager.usernameExists(email)) {
                AffectedRowCountAndKey result = this.userRepository.create(email, this.passwordEncoder.encode((CharSequence)PasswordGenerator.generateRandomPassword()), OpenIdUserSynchronizer.retrieveClaimOrBlank((String)configuration.givenNameClaim(), (OidcUser)oidcUser), OpenIdUserSynchronizer.retrieveClaimOrBlank((String)configuration.familyNameClaim(), (OidcUser)oidcUser), email, true, internalUser.userType(), null, null);
                Validate.isTrue((result.getAffectedRowCount() == 1 ? 1 : 0) != 0, (String)"Error while creating user", (Object[])new Object[0]);
                if (internalUser.isPublicUser()) {
                    this.extensionManager.handlePublicUserSignUp(this.userRepository.findById(((Integer)result.getKey()).intValue()));
                }
                userSignedUp = true;
            }
            if (!internalUser.isPublicUser()) {
                this.updateRoles(internalUser.alfioRoles(), email);
                this.updateOrganizations(internalUser);
            }
            return userSignedUp;
        }));
    }

    private static String retrieveClaimOrBlank(String claim, OidcUser container) {
        if (claim == null) {
            return "";
        }
        return StringUtils.trimToEmpty((String)((String)container.getClaim(claim)));
    }

    private void updateOrganizations(OpenIdAlfioUser alfioUser) {
        int userId = (Integer)this.userRepository.findIdByUserName(alfioUser.email()).orElseThrow();
        Set databaseOrganizationIds = this.organizationRepository.findAllForUser(alfioUser.email()).stream().map(Organization::getId).collect(Collectors.toSet());
        if (alfioUser.isAdmin()) {
            if (!databaseOrganizationIds.isEmpty()) {
                this.userOrganizationRepository.removeOrganizationUserLinks(userId, databaseOrganizationIds);
            }
            return;
        }
        Set userOrg = alfioUser.alfioOrganizationAuthorizations().keySet();
        List organizationIds = !userOrg.isEmpty() ? this.organizationRepository.findOrganizationIdsByExternalId(userOrg) : List.of();
        Set organizationsToUnlink = databaseOrganizationIds.stream().filter(orgId -> !organizationIds.contains(orgId)).collect(Collectors.toSet());
        if (!organizationsToUnlink.isEmpty()) {
            this.userOrganizationRepository.removeOrganizationUserLinks(userId, organizationsToUnlink);
        }
        if (organizationIds.isEmpty()) {
            throw new IllegalStateException("The user needs to be ADMIN or have at least one organization linked");
        }
        MapSqlParameterSource[] params = (MapSqlParameterSource[])organizationIds.stream().filter(orgId -> !databaseOrganizationIds.contains(orgId)).map(id -> new MapSqlParameterSource("userId", (Object)userId).addValue("organizationId", id)).toArray(MapSqlParameterSource[]::new);
        this.jdbcTemplate.batchUpdate(this.userOrganizationRepository.bulkCreate(), (SqlParameterSource[])params);
    }

    private void updateRoles(Set<Role> roles, String username) {
        this.authorityRepository.revokeAll(username);
        MapSqlParameterSource[] rolesToAdd = (MapSqlParameterSource[])roles.stream().map(r -> new MapSqlParameterSource("username", (Object)username).addValue("role", (Object)r.getRoleName())).toArray(MapSqlParameterSource[]::new);
        this.jdbcTemplate.batchUpdate(this.authorityRepository.grantAll(), (SqlParameterSource[])rolesToAdd);
    }
}

