/*
 * Decompiled with CFR 0.152.
 */
package alfio.config.authentication.support;

import alfio.model.user.Role;
import alfio.model.user.User;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;

public record OpenIdAlfioUser(String idToken, String subject, String email, User.Type userType, Set<Role> alfioRoles, Map<String, Set<String>> alfioOrganizationAuthorizations) implements Serializable
{
    private final String idToken;
    private final String subject;
    private final String email;
    private final User.Type userType;
    private final Set<Role> alfioRoles;
    private final Map<String, Set<String>> alfioOrganizationAuthorizations;

    public OpenIdAlfioUser(String idToken, String subject, String email, User.Type userType, Set<Role> alfioRoles, Map<String, Set<String>> alfioOrganizationAuthorizations) {
        this.idToken = idToken;
        this.subject = subject;
        this.email = email;
        this.userType = userType;
        this.alfioRoles = alfioRoles;
        this.alfioOrganizationAuthorizations = alfioOrganizationAuthorizations;
    }

    public boolean isAdmin() {
        return this.userType == User.Type.INTERNAL && this.alfioRoles.contains(Role.ADMIN);
    }

    public boolean isPublicUser() {
        return this.userType == User.Type.PUBLIC;
    }

    public String idToken() {
        return this.idToken;
    }

    public String subject() {
        return this.subject;
    }

    public String email() {
        return this.email;
    }

    public User.Type userType() {
        return this.userType;
    }

    public Set<Role> alfioRoles() {
        return this.alfioRoles;
    }

    public Map<String, Set<String>> alfioOrganizationAuthorizations() {
        return this.alfioOrganizationAuthorizations;
    }
}

