/*
 * Decompiled with CFR 0.152.
 */
package alfio.config.authentication.support;

import alfio.config.support.ContextAwareCookieSerializer;
import alfio.util.TemplateManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationSuccessHandler;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.session.web.http.CookieSerializer;

public class OpenIdLoginSuccessHandler
extends SimpleUrlAuthenticationSuccessHandler {
    private final RequestCache requestCache = new HttpSessionRequestCache();
    private final TemplateManager templateManager;
    private final ContextAwareCookieSerializer cookieSerializer;

    public OpenIdLoginSuccessHandler(TemplateManager templateManager, ContextAwareCookieSerializer cookieSerializer) {
        this.templateManager = templateManager;
        this.cookieSerializer = cookieSerializer;
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException {
        SavedRequest savedRequest = this.requestCache.getRequest(request, response);
        String targetPath = savedRequest == null || StringUtils.isBlank((CharSequence)savedRequest.getRedirectUrl()) ? "/" : URI.create(savedRequest.getRedirectUrl()).getPath();
        this.clearAuthenticationAttributes(request);
        this.cookieSerializer.writePreAuthCookieValue(new CookieSerializer.CookieValue(request, response, ""));
        response.setContentType("text/html");
        response.setStatus(200);
        this.templateManager.renderHtml((Resource)new ClassPathResource("/alfio/templates/openid-redirect.ms"), Map.of("redirectPath", targetPath), (Writer)response.getWriter());
        response.flushBuffer();
    }
}

