/*
 * Decompiled with CFR 0.152.
 */
package alfio.config.authentication.support;

import alfio.config.authentication.support.OpenIdAlfioUser;
import java.util.Collection;
import java.util.Objects;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;
import org.springframework.security.oauth2.core.oidc.OidcUserInfo;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;

public class OpenIdPrincipal
extends DefaultOidcUser {
    private static final long serialVersionUID = -3305276997530613807L;
    private final OpenIdAlfioUser alfioUser;
    private final String idpLogoutRedirectionUrl;
    private final boolean signedUp;

    public OpenIdPrincipal(Collection<? extends GrantedAuthority> authorities, OidcIdToken idToken, OidcUserInfo userInfo, OpenIdAlfioUser alfioUser, String idpLogoutRedirectionUrl, boolean signedUp) {
        super(authorities, idToken, userInfo);
        this.alfioUser = alfioUser;
        this.idpLogoutRedirectionUrl = idpLogoutRedirectionUrl;
        this.signedUp = signedUp;
    }

    public OpenIdAlfioUser user() {
        return this.alfioUser;
    }

    public String idpLogoutRedirectionUrl() {
        return this.idpLogoutRedirectionUrl;
    }

    public String getName() {
        return this.user().email();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OpenIdPrincipal that = (OpenIdPrincipal)o;
        return Objects.equals(this.alfioUser, that.alfioUser) && Objects.equals(this.idpLogoutRedirectionUrl, that.idpLogoutRedirectionUrl);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.alfioUser, this.idpLogoutRedirectionUrl);
    }

    public boolean isSignedUp() {
        return this.signedUp;
    }
}

