/*
 * Decompiled with CFR 0.152.
 */
package alfio.config.authentication.support;

import alfio.config.authentication.support.PaymentProviderConnectFilter;
import alfio.manager.payment.MollieConnectManager;
import alfio.manager.payment.OAuthPaymentProviderConnector;
import alfio.manager.payment.StripeConnectManager;
import alfio.manager.user.UserManager;
import alfio.util.TemplateManager;
import alfio.util.oauth2.AccessTokenResponseDetails;
import alfio.util.oauth2.AuthorizationRequestDetails;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatchers;
import org.springframework.web.filter.GenericFilterBean;
import org.springframework.web.servlet.FlashMap;
import org.springframework.web.servlet.FlashMapManager;
import org.springframework.web.servlet.support.SessionFlashMapManager;

/*
 * Exception performing whole class analysis ignored.
 */
public class PaymentProviderConnectFilter
extends GenericFilterBean {
    private static final Logger log = LoggerFactory.getLogger(PaymentProviderConnectFilter.class);
    private static final String CONNECT_ORG = ".connect.org";
    private static final String CONNECT_STATE_PREFIX = ".connect.state.";
    public static final String MOLLIE = "mollie";
    public static final String ADMIN = "/admin";
    public static final String ERROR_MESSAGE = "errorMessage";
    private final TemplateManager templateManager;
    private final RequestMatcher requestMatcher;
    private final RequestMatcher authorizeRequestMatcher;
    private final UserManager userManager;
    private final FlashMapManager flashMapManager;
    private final StripeConnectManager stripeConnectManager;
    private final MollieConnectManager mollieConnectManager;

    public PaymentProviderConnectFilter(TemplateManager templateManager, UserManager userManager, StripeConnectManager stripeConnectManager, MollieConnectManager mollieConnectManager) {
        this.templateManager = templateManager;
        this.userManager = userManager;
        this.stripeConnectManager = stripeConnectManager;
        this.mollieConnectManager = mollieConnectManager;
        this.requestMatcher = new AntPathRequestMatcher("/admin/configuration/payment/{provider}/connect/{orgId}");
        this.authorizeRequestMatcher = RequestMatchers.anyOf((RequestMatcher[])new RequestMatcher[]{new AntPathRequestMatcher("/admin/configuration/payment/stripe/authorize"), new AntPathRequestMatcher("/admin/configuration/payment/mollie/authorize")});
        this.flashMapManager = new SessionFlashMapManager();
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        RequestMatcher.MatchResult matcher = this.requestMatcher.matcher(request);
        if (matcher.isMatch()) {
            this.initializeConnect(matcher, request, response);
        } else if (this.authorizeRequestMatcher.matches(request)) {
            StateParams stateParams = PaymentProviderConnectFilter.getStateParams((HttpServletRequest)request);
            HttpSession session = request.getSession(false);
            if (stateParams.isValid() && session == null) {
                String redirectPath = request.getRequestURI() + "?" + request.getQueryString() + "&p=true";
                log.trace("Session is null. Request URI is: {}", (Object)redirectPath);
                response.setContentType("text/html");
                response.setStatus(200);
                this.templateManager.renderHtml((Resource)new ClassPathResource("/alfio/templates/openid-redirect.ms"), Map.of("redirectPath", redirectPath), (Writer)response.getWriter());
                response.flushBuffer();
                return;
            }
            if (session == null) {
                log.trace("Session is null and a first attempt has been already made. Giving up...");
            } else {
                this.handleConnectResponse(request, response, session, stateParams);
            }
        }
        chain.doFilter(req, res);
    }

    private static StateParams getStateParams(HttpServletRequest request) {
        String state = request.getParameter("state");
        String code = request.getParameter("code");
        String errorCode = request.getParameter("error");
        String errorDescription = request.getParameter("error_description");
        String processed = request.getParameter("p");
        return new StateParams(state, code, errorCode, errorDescription, processed);
    }

    private void handleConnectResponse(HttpServletRequest request, HttpServletResponse response, HttpSession session, StateParams stateParams) throws IOException {
        try {
            boolean isMollie = request.getRequestURI().equals("/admin/configuration/payment/mollie/authorize");
            String provider = isMollie ? "mollie" : "stripe";
            Integer orgId = (Integer)session.getAttribute(provider + ".connect.org");
            if (orgId == null || !this.userManager.isOwnerOfOrganization(SecurityContextHolder.getContext().getAuthentication().getName(), orgId.intValue())) {
                response.sendRedirect("/admin");
            } else {
                FlashMap flashMap = new FlashMap();
                session.removeAttribute(provider + ".connect.org");
                String persistedState = (String)session.getAttribute(provider + ".connect.state." + orgId);
                session.removeAttribute(provider + ".connect.state." + orgId);
                boolean stateVerified = Objects.equals(persistedState, stateParams.state);
                if (stateVerified && stateParams.code != null) {
                    AccessTokenResponseDetails connectResult = this.getConnector(provider).storeConnectedAccountId(stateParams.code, orgId.intValue());
                    if (connectResult.isSuccess()) {
                        response.sendRedirect("/admin/#/configuration/organization/" + orgId);
                    }
                } else if (stateVerified && StringUtils.isNotEmpty((CharSequence)stateParams.errorCode)) {
                    log.warn("error from {}. {}={}", new Object[]{provider, stateParams.errorCode, stateParams.errorDescription});
                    flashMap.put((Object)"errorMessage", (Object)Objects.toString(stateParams.errorDescription, stateParams.errorCode));
                    this.flashMapManager.saveOutputFlashMap(flashMap, request, response);
                    response.sendRedirect("/admin");
                } else {
                    flashMap.put((Object)"errorMessage", (Object)"Couldn't connect your account. Please retry.");
                    this.flashMapManager.saveOutputFlashMap(flashMap, request, response);
                    response.sendRedirect("/admin");
                }
            }
        }
        catch (RuntimeException e) {
            log.warn("Cannot complete connection with payment provider", (Throwable)e);
            FlashMap flashMap = new FlashMap();
            flashMap.put((Object)"errorMessage", (Object)"Couldn't connect your account. Please retry.");
            this.flashMapManager.saveOutputFlashMap(flashMap, request, response);
            response.sendRedirect("/admin");
        }
    }

    private void initializeConnect(RequestMatcher.MatchResult matcher, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Map variables = matcher.getVariables();
        int orgId = Integer.parseInt((String)variables.get("orgId"));
        String provider = (String)variables.get("provider");
        String username = SecurityContextHolder.getContext().getAuthentication().getName();
        if (("stripe".equals(provider) || "mollie".equals(provider)) && this.userManager.isOwnerOfOrganization(username, orgId)) {
            HttpSession session = Objects.requireNonNull(request.getSession(false));
            AuthorizationRequestDetails connectURL = this.getConnector(provider).getConnectURL(orgId);
            session.setAttribute(provider + ".connect.state." + orgId, (Object)connectURL.getState());
            session.setAttribute(provider + ".connect.org", (Object)orgId);
            response.sendRedirect(connectURL.getAuthorizationUrl());
        } else {
            response.sendRedirect("/admin");
        }
    }

    private OAuthPaymentProviderConnector getConnector(String providerAsString) {
        return "mollie".equals(providerAsString) ? this.mollieConnectManager : this.stripeConnectManager;
    }
}

