/*
 * Decompiled with CFR 0.152.
 */
package alfio.config.authentication.support;

import alfio.config.support.ContextAwareCookieSerializer;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.session.web.http.CookieSerializer;
import org.springframework.web.filter.OncePerRequestFilter;

public class PreAuthCookieWriterFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(PreAuthCookieWriterFilter.class);
    private final ContextAwareCookieSerializer cookieSerializer;
    private final RequestMatcher requestMatcher;

    public PreAuthCookieWriterFilter(ContextAwareCookieSerializer cookieSerializer, RequestMatcher preAuthRequestMatcher) {
        this.cookieSerializer = cookieSerializer;
        this.requestMatcher = preAuthRequestMatcher;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (this.requestMatcher.matches(request)) {
            log.trace("Request matches. Adding PreAuth cookie.");
            HttpSession session = Objects.requireNonNull(request.getSession(false));
            this.cookieSerializer.writePreAuthCookieValue(new CookieSerializer.CookieValue(request, response, session.getId()));
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

