/*
 * Decompiled with CFR 0.152.
 */
package alfio.config.authentication.support;

import alfio.config.authentication.support.UserProvidedClientRegistrationRepository;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.DefaultOAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;

public class PublicOpenIdRequestResolver
implements OAuth2AuthorizationRequestResolver {
    public static final String OPENID_AUTHENTICATION_PATH = "/openid/authentication";
    private final AntPathRequestMatcher authorizationRequestMatcher = new AntPathRequestMatcher("/openid/authentication");
    private final DefaultOAuth2AuthorizationRequestResolver delegate;

    public PublicOpenIdRequestResolver(UserProvidedClientRegistrationRepository repository) {
        this.delegate = new DefaultOAuth2AuthorizationRequestResolver((ClientRegistrationRepository)repository, OPENID_AUTHENTICATION_PATH);
    }

    public OAuth2AuthorizationRequest resolve(HttpServletRequest request) {
        if (this.authorizationRequestMatcher.matches(request)) {
            return this.resolve(request, "alfio-public-openid");
        }
        return null;
    }

    public OAuth2AuthorizationRequest resolve(HttpServletRequest request, String clientRegistrationId) {
        return this.delegate.resolve(request, clientRegistrationId);
    }
}

