/*
 * Decompiled with CFR 0.152.
 */
package alfio.config.authentication.support;

import alfio.manager.RecaptchaService;
import alfio.manager.system.ConfigurationManager;
import alfio.model.system.ConfigurationKeys;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.filter.GenericFilterBean;

public class RecaptchaLoginFilter
extends GenericFilterBean {
    private final RequestMatcher requestMatcher;
    private final RecaptchaService recaptchaService;
    private final String recaptchaFailureUrl;
    private final ConfigurationManager configurationManager;

    public RecaptchaLoginFilter(RecaptchaService recaptchaService, String loginProcessingUrl, String recaptchaFailureUrl, ConfigurationManager configurationManager) {
        this.requestMatcher = new AntPathRequestMatcher(loginProcessingUrl, "POST");
        this.recaptchaService = recaptchaService;
        this.recaptchaFailureUrl = recaptchaFailureUrl;
        this.configurationManager = configurationManager;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        if (this.requestMatcher.matches(req) && this.configurationManager.getForSystem(ConfigurationKeys.ENABLE_CAPTCHA_FOR_LOGIN).getValueAsBooleanOrDefault() && !this.recaptchaService.checkRecaptcha(null, req)) {
            res.sendRedirect(this.recaptchaFailureUrl);
            return;
        }
        chain.doFilter(request, response);
    }
}

