/*
 * Decompiled with CFR 0.152.
 */
package alfio.config.authentication.support;

import alfio.manager.user.UserManager;
import alfio.model.modification.OrganizationModification;
import alfio.model.user.Role;
import alfio.model.user.User;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.UUID;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.filter.GenericFilterBean;

public class UserCreatorBeforeLoginFilter
extends GenericFilterBean {
    private final UserManager userManager;
    private final RequestMatcher requestMatcher;

    public UserCreatorBeforeLoginFilter(UserManager userManager, String loginProcessingUrl) {
        this.userManager = userManager;
        this.requestMatcher = new AntPathRequestMatcher(loginProcessingUrl, "POST");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String username;
        HttpServletRequest req = (HttpServletRequest)request;
        if (this.requestMatcher.matches(req) && req.getParameter("username") != null && req.getParameter("password") != null && !this.userManager.usernameExists(username = req.getParameter("username"))) {
            OrganizationModification organizationModification = new OrganizationModification(null, UUID.randomUUID().toString(), username, username, null, null);
            int orgId = this.userManager.createOrganization(organizationModification, null);
            this.userManager.insertUser(orgId, username, "", "", username, Role.OWNER, User.Type.DEMO, req.getParameter("password"), null, null, null);
        }
        chain.doFilter(request, response);
    }
}

