/*
 * Decompiled with CFR 0.152.
 */
package alfio.config.authentication.support;

import alfio.manager.openid.OpenIdConfiguration;
import alfio.manager.system.ConfigurationManager;
import alfio.model.system.ConfigurationKeys;
import alfio.util.Json;
import java.util.Objects;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;

public class UserProvidedClientRegistrationRepository
implements ClientRegistrationRepository {
    public static final String PUBLIC_REGISTRATION_ID = "alfio-public-openid";
    public static final String OPENID_CALLBACK_PATH = "/openid/callback";
    private final ConfigurationManager configurationManager;

    public UserProvidedClientRegistrationRepository(ConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    public ClientRegistration findByRegistrationId(String registrationId) {
        if (!this.configurationManager.isPublicOpenIdEnabled()) {
            throw new AuthenticationCredentialsNotFoundException("openid is not enabled");
        }
        OpenIdConfiguration openIdConfiguration = Objects.requireNonNull((OpenIdConfiguration)Json.fromJson((String)((ConfigurationManager.MaybeConfiguration)this.configurationManager.getPublicOpenIdConfiguration().get(ConfigurationKeys.OPENID_CONFIGURATION_JSON)).getValueOrNull(), OpenIdConfiguration.class));
        return openIdConfiguration.toClientRegistration(PUBLIC_REGISTRATION_ID, "{baseUrl}/openid/callback", false);
    }
}

