/*
 * Decompiled with CFR 0.152.
 */
package alfio.config.challenge;

import alfio.config.challenge.CFTurnstileVerificationFilter;
import alfio.manager.system.ConfigurationManager;
import alfio.model.system.ConfigurationKeys;
import alfio.util.Json;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.client.RestClient;
import org.springframework.web.filter.OncePerRequestFilter;

public class CFTurnstileVerificationFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(CFTurnstileVerificationFilter.class);
    private static final URI SITEVERIFY = URI.create("https://challenges.cloudflare.com/turnstile/v0/siteverify");
    private final ConfigurationManager configurationManager;
    private final RequestMatcher requestMatcher;
    private final RestClient restClient;

    public CFTurnstileVerificationFilter(ConfigurationManager configurationManager, RequestMatcher requestMatcher) {
        this.configurationManager = configurationManager;
        this.requestMatcher = requestMatcher;
        this.restClient = RestClient.builder().baseUrl("https://challenges.cloudflare.com").build();
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (this.requestMatcher.matches(request)) {
            log.trace("Request matching. Checking if turnstile is enabled.");
            Map configuration = this.configurationManager.getTurnstileConfiguration();
            if (((ConfigurationManager.MaybeConfiguration)configuration.get(ConfigurationKeys.CF_TURNSTILE_ENABLED)).getValueAsBooleanOrDefault()) {
                log.trace("Turnstile is enabled. Proceeding with validation.");
                String challenge = request.getHeader("Alfio-Verification");
                if (!this.verifyChallenge(challenge, configuration, request)) {
                    log.trace("verification failed. Returning 403");
                    response.setHeader("Alfio-Verification-Missing", "turnstile");
                    response.sendError(HttpStatus.FORBIDDEN.value());
                    return;
                }
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private boolean verifyChallenge(String challenge, Map<ConfigurationKeys, ConfigurationManager.MaybeConfiguration> configuration, HttpServletRequest request) {
        boolean challengeEmpty = StringUtils.isBlank((CharSequence)challenge);
        if (challengeEmpty && this.preClearanceEnabledAndPresent(configuration, request)) {
            log.trace("Validation is SUCCESSFUL because cf-clearance is enabled and the relevant cookie is present in the request.");
            return true;
        }
        if (challengeEmpty) {
            log.trace("Validation is NOT SUCCESSFUL because token is missing.");
            return false;
        }
        String secret = configuration.get(ConfigurationKeys.CF_TURNSTILE_SECRET_KEY).getRequiredValue();
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put("secret", secret);
        payload.put("response", challenge);
        if (request.getHeader("CF-Connecting-IP") != null) {
            payload.put("remoteip", request.getHeader("CF-Connecting-IP"));
        }
        ResponseEntity response = ((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)this.restClient.post().uri(SITEVERIFY)).header("Content-Type", new String[]{"application/json"})).body((Object)Json.toJson(payload)).retrieve().toEntity(TurnstileResponse.class);
        log.trace("Received {} response from siteverify", (Object)response.getStatusCode());
        if (!response.getStatusCode().is2xxSuccessful()) {
            log.trace("Validation is NOT SUCCESSFUL because response from siteverify is not successful.");
            return false;
        }
        TurnstileResponse body = Objects.requireNonNull((TurnstileResponse)response.getBody());
        if (body.success) {
            log.trace("Validation is SUCCESSFUL.");
            return true;
        }
        log.debug("Validation is NOT SUCCESSFUL because siteverify reported token as not valid.");
        return false;
    }

    private boolean preClearanceEnabledAndPresent(Map<ConfigurationKeys, ConfigurationManager.MaybeConfiguration> configuration, HttpServletRequest request) {
        if (!configuration.get(ConfigurationKeys.CF_TURNSTILE_PRE_CLEARANCE).getValueAsBooleanOrDefault()) {
            return false;
        }
        return Arrays.stream(request.getCookies()).anyMatch(c -> c.getName().equals("cf_clearance") && StringUtils.isNotBlank((CharSequence)c.getValue()));
    }
}

