/*
 * Decompiled with CFR 0.152.
 */
package alfio.config.support;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.server.Cookie;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.session.web.http.CookieSerializer;
import org.springframework.session.web.http.DefaultCookieSerializer;

public class ContextAwareCookieSerializer
implements CookieSerializer {
    private static final Logger log = LoggerFactory.getLogger(ContextAwareCookieSerializer.class);
    private static final String COOKIE_NAME = "ALFIO_SESSION";
    private static final String PRE_AUTH_COOKIE_NAME = "ALFIO_SESSION_PREAUTH";
    private final DefaultCookieSerializer defaultCookieSerializer;
    private final DefaultCookieSerializer preAuthCookieSerializer;
    private final RequestMatcher authenticationRequestMatcher;

    public ContextAwareCookieSerializer(Environment environment) {
        boolean live = environment.acceptsProfiles(Profiles.of((String[])new String[]{"!dev"}));
        DefaultCookieSerializer serializer = new DefaultCookieSerializer();
        serializer.setCookieName(COOKIE_NAME);
        if (live) {
            serializer.setSameSite(Cookie.SameSite.STRICT.attributeValue());
            serializer.setUseSecureCookie(true);
            this.preAuthCookieSerializer = new DefaultCookieSerializer();
            this.preAuthCookieSerializer.setCookieName(PRE_AUTH_COOKIE_NAME);
            this.preAuthCookieSerializer.setUseSecureCookie(true);
            this.preAuthCookieSerializer.setSameSite(Cookie.SameSite.NONE.attributeValue());
            this.preAuthCookieSerializer.setCookieMaxAge(3600);
        } else {
            this.preAuthCookieSerializer = null;
        }
        this.defaultCookieSerializer = serializer;
        this.authenticationRequestMatcher = new OrRequestMatcher(new RequestMatcher[]{new AntPathRequestMatcher("/callback"), new AntPathRequestMatcher("/openid/callback")});
    }

    public void writeCookieValue(CookieSerializer.CookieValue cookieValue) {
        this.defaultCookieSerializer.writeCookieValue(cookieValue);
    }

    public List<String> readCookieValues(HttpServletRequest request) {
        List result = this.defaultCookieSerializer.readCookieValues(request);
        if (CollectionUtils.isEmpty((Collection)result) && this.preAuthCookieSerializer != null && this.authenticationRequestMatcher.matches(request)) {
            log.trace("Cannot load session cookie. Trying with PreAuth cookie.");
            result = this.preAuthCookieSerializer.readCookieValues(request);
            if (log.isTraceEnabled()) {
                log.trace("PreAuth cookie found: {}", (Object)(CollectionUtils.size((Object)result) > 0 ? 1 : 0));
            }
        }
        return result;
    }

    public void writePreAuthCookieValue(CookieSerializer.CookieValue cookieValue) {
        if (this.preAuthCookieSerializer != null) {
            log.trace("Writing PreAuth cookie");
            this.preAuthCookieSerializer.writeCookieValue(cookieValue);
        }
    }
}

