/*
 * Decompiled with CFR 0.152.
 */
package alfio.config.support;

import alfio.manager.system.ConfigurationManager;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class HeaderPublisherFilter
implements Filter {
    private final ConfigurationManager configurationManager;

    public HeaderPublisherFilter(ConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        if (httpServletRequest.getMethod().equals("GET") && httpServletRequest.getRequestURI().startsWith("/api/v2")) {
            httpServletResponse.setHeader("Alfio-OpenId-Enabled", Boolean.toString(this.configurationManager.isPublicOpenIdEnabled()));
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }
}

