/*
 * Decompiled with CFR 0.152.
 */
package alfio.config.support;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import org.springframework.core.env.Environment;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum PlatformProvider {
    DEFAULT,
    DRY_RUN/* Unavailable Anonymous Inner Class!! */,
    ELEPHANTSQL/* Unavailable Anonymous Inner Class!! */,
    OPENSHIFT/* Unavailable Anonymous Inner Class!! */,
    CLOUD_FOUNDRY/* Unavailable Anonymous Inner Class!! */,
    HEROKU/* Unavailable Anonymous Inner Class!! */,
    DOCKER/* Unavailable Anonymous Inner Class!! */,
    AWS_BEANSTALK/* Unavailable Anonymous Inner Class!! */,
    CLEVER_CLOUD/* Unavailable Anonymous Inner Class!! */;


    public String getUrl(Environment env) {
        return env.getRequiredProperty("datasource.url");
    }

    public String getUsername(Environment env) {
        return env.getRequiredProperty("datasource.username");
    }

    public String getPassword(Environment env) {
        return env.getRequiredProperty("datasource.password");
    }

    public int getMaxActive(Environment env) {
        return Optional.ofNullable(env.getProperty("datasource.connections.max-active")).map(Integer::parseInt).orElse(10);
    }

    public int getMinIdle(Environment env) {
        return Optional.ofNullable(env.getProperty("datasource.connections.min-idle")).map(Integer::parseInt).orElse(5);
    }

    public boolean isHosting(Environment env) {
        return true;
    }

    static URI resolveURI(Environment env, String propertyName) {
        try {
            return new URI(env.getRequiredProperty(propertyName));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    static boolean isCloudFoundry(Environment env) {
        return env.getProperty("VCAP_SERVICES") != null;
    }
}

