/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller;

import alfio.config.authentication.support.OpenIdPrincipal;
import alfio.controller.AdminIndexController;
import alfio.controller.Constants;
import alfio.controller.support.CSPConfigurer;
import alfio.manager.i18n.I18nManager;
import alfio.manager.system.ConfigurationManager;
import alfio.model.system.ConfigurationKeys;
import alfio.model.user.Role;
import alfio.util.Json;
import alfio.util.TemplateManager;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.samskivert.mustache.Mustache;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;

@Controller
public class AdminIndexController {
    private final ConfigurationManager configurationManager;
    private final Environment environment;
    private final CSPConfigurer cspConfigurer;
    private final TemplateManager templateManager;
    private final ManifestEntry manifestEntry;
    private final I18nManager i18nManager;
    static final Function<Map<String, Object>, Mustache.Lambda> RENDER_JSON = model -> (frag, out) -> {
        if (model == null) {
            out.write("null");
            return;
        }
        String property = frag.execute().strip();
        if (model.containsKey(property)) {
            out.write("'" + Json.toJson(model.get(property)) + "'");
        } else {
            out.write("null");
        }
    };

    public AdminIndexController(ConfigurationManager configurationManager, Environment environment, CSPConfigurer cspConfigurer, TemplateManager templateManager, ObjectMapper objectMapper, I18nManager i18nManager) throws IOException {
        this.configurationManager = configurationManager;
        this.environment = environment;
        this.cspConfigurer = cspConfigurer;
        this.templateManager = templateManager;
        this.i18nManager = i18nManager;
        ClassPathResource cpr = new ClassPathResource("/resources/alfio-admin-frontend/.vite/manifest.json");
        if (cpr.exists()) {
            try (InputStream descriptor = cpr.getInputStream();){
                this.manifestEntry = (ManifestEntry)((Map)objectMapper.readValue(descriptor, (TypeReference)new /* Unavailable Anonymous Inner Class!! */)).get("src/main.ts");
            }
        } else {
            this.manifestEntry = null;
        }
    }

    @GetMapping(value={"/admin", "/admin/"})
    public void adminHome(Model model, @Value(value="${alfio.version}") String version, HttpServletRequest request, HttpServletResponse response, Principal principal) throws IOException {
        model.addAttribute("alfioVersion", (Object)version);
        model.addAttribute("basicConfigurationNeeded", (Object)this.configurationManager.isBasicConfigurationNeeded());
        boolean isDBAuthentication = !(principal instanceof OAuth2AuthenticationToken);
        model.addAttribute("isDBAuthentication", (Object)isDBAuthentication);
        if (!isDBAuthentication) {
            OpenIdPrincipal openIdPrincipal = (OpenIdPrincipal)((OAuth2AuthenticationToken)principal).getPrincipal();
            String idpLogoutRedirectionUrl = openIdPrincipal.idpLogoutRedirectionUrl();
            model.addAttribute("idpLogoutRedirectionUrl", (Object)idpLogoutRedirectionUrl);
            model.addAttribute("username", (Object)openIdPrincipal.user().email());
        } else {
            model.addAttribute("idpLogoutRedirectionUrl", null);
            model.addAttribute("username", (Object)principal.getName());
        }
        List<String> authorities = SecurityContextHolder.getContext().getAuthentication().getAuthorities().stream().map(GrantedAuthority::getAuthority).toList();
        boolean isAdmin = authorities.contains(Role.ADMIN.getRoleName());
        model.addAttribute("isOwner", (Object)(isAdmin || authorities.contains(Role.OWNER.getRoleName()) ? 1 : 0));
        model.addAttribute("isAdmin", (Object)isAdmin);
        model.addAttribute("supportedLanguages", (Object)this.i18nManager.getAvailableLanguages());
        Constants.addCommonModelAttributes((Model)model, (HttpServletRequest)request, (String)version, (Environment)this.environment);
        model.addAttribute("displayProjectBanner", (Object)(isAdmin && this.configurationManager.getForSystem(ConfigurationKeys.SHOW_PROJECT_BANNER).getValueAsBooleanOrDefault() ? 1 : 0));
        model.addAttribute("litAdminStatic", (Object)(this.manifestEntry != null ? 1 : 0));
        if (this.manifestEntry != null) {
            model.addAttribute("lit-css", (Object)this.manifestEntry.css);
            model.addAttribute("lit-js", (Object)this.manifestEntry.file);
        }
        try (ServletOutputStream os = response.getOutputStream();){
            response.setContentType("text/html;charset=UTF-8");
            response.setCharacterEncoding("UTF-8");
            String nonce = this.cspConfigurer.addCspHeader(response, false);
            model.addAttribute("nonce", (Object)nonce);
            model.addAttribute("render-json", RENDER_JSON.apply(model.asMap()));
            this.templateManager.renderHtml((Resource)new ClassPathResource("alfio/web-templates/admin-index.ms"), model.asMap(), (OutputStream)os);
        }
    }
}

