/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller;

import alfio.controller.Constants;
import alfio.controller.support.CSPConfigurer;
import alfio.controller.support.UserStatus;
import alfio.manager.system.ConfigurationLevel;
import alfio.manager.system.ConfigurationManager;
import alfio.model.system.ConfigurationKeys;
import alfio.util.TemplateManager;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Principal;
import java.util.EnumSet;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class AuthenticationController {
    private static final String REDIRECT_ADMIN = "redirect:/admin/";
    private final ConfigurationManager configurationManager;
    private final Environment environment;
    private final CSPConfigurer cspConfigurer;
    private final TemplateManager templateManager;

    public AuthenticationController(ConfigurationManager configurationManager, Environment environment, CSPConfigurer cspConfigurer, TemplateManager templateManager) {
        this.configurationManager = configurationManager;
        this.environment = environment;
        this.cspConfigurer = cspConfigurer;
        this.templateManager = templateManager;
    }

    @GetMapping(value={"/authentication-status"})
    public ResponseEntity<UserStatus> authenticationStatus(Principal principal, @Value(value="${alfio.version}") String version) {
        return ResponseEntity.ok((Object)new UserStatus(principal != null, principal != null ? principal.getName() : null, version, Constants.demoModeEnabled((Environment)this.environment), Constants.devModeEnabled((Environment)this.environment), Constants.prodModeEnabled((Environment)this.environment)));
    }

    @GetMapping(value={"/authentication"})
    public void getLoginPage(@RequestParam(value="failed", required=false) String failed, @RequestParam(value="recaptchaFailed", required=false) String recaptchaFailed, Model model, Principal principal, HttpServletRequest request, HttpServletResponse response, @Value(value="${alfio.version}") String version) throws IOException {
        if (principal != null) {
            response.sendRedirect("/admin/");
            return;
        }
        model.addAttribute("failed", (Object)(failed != null ? 1 : 0));
        model.addAttribute("recaptchaFailed", (Object)(recaptchaFailed != null ? 1 : 0));
        model.addAttribute("hasRecaptchaApiKey", (Object)false);
        Constants.addCommonModelAttributes((Model)model, (HttpServletRequest)request, (String)version, (Environment)this.environment);
        model.addAttribute("request", (Object)request);
        Map configuration = this.configurationManager.getFor(EnumSet.of(ConfigurationKeys.RECAPTCHA_API_KEY, ConfigurationKeys.ENABLE_CAPTCHA_FOR_LOGIN), ConfigurationLevel.system());
        ((ConfigurationManager.MaybeConfiguration)configuration.get(ConfigurationKeys.RECAPTCHA_API_KEY)).getValue().filter(key -> ((ConfigurationManager.MaybeConfiguration)configuration.get(ConfigurationKeys.ENABLE_CAPTCHA_FOR_LOGIN)).getValueAsBooleanOrDefault()).ifPresent(key -> {
            model.addAttribute("hasRecaptchaApiKey", (Object)true);
            model.addAttribute("recaptchaApiKey", key);
        });
        try (ServletOutputStream os = response.getOutputStream();){
            response.setContentType("text/html;charset=UTF-8");
            response.setCharacterEncoding("UTF-8");
            String nonce = this.cspConfigurer.addCspHeader(response, false);
            model.addAttribute("nonce", (Object)nonce);
            this.templateManager.renderHtml((Resource)new ClassPathResource("alfio/web-templates/login.ms"), model.asMap(), (OutputStream)os);
        }
    }

    @PostMapping(value={"/authenticate"})
    public String doLogin() {
        return REDIRECT_ADMIN;
    }
}

