/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller;

import jakarta.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.ui.Model;

/*
 * Exception performing whole class analysis ignored.
 */
public interface Constants {
    public static final String TICKET_QR_CODE_URI = "/api/v2/public/event/{eventName}/ticket/{ticketIdentifier}/code.png";
    public static final String WALLET_API_BASE_URI = "/api/wallet/event/{eventName}/v1";
    public static final String PASS_API_BASE_URI = "/api/pass/event/{eventName}/v1";
    public static final String WALLET_API_GET_URI = "/version/passes/{uuid}";
    public static final String TICKET_PDF_URI = "/api/v2/public/event/{eventName}/ticket/{ticketIdentifier}/download-ticket";
    public static final String TEXT_HTML_CHARSET_UTF_8 = "text/html;charset=UTF-8";
    public static final String UTF_8 = "UTF-8";
    public static final String NONCE = "nonce";
    public static final String REDIRECT = "redirect:";
    public static final String EVENT_SHORT_NAME = "eventShortName";
    public static final String NOT_FOUND = "not-found";
    public static final String CONTENT = "content";
    public static final String PROPERTY = "property";

    public static void addCommonModelAttributes(Model model, HttpServletRequest request, String version, Environment environment) {
        String contextPath = StringUtils.appendIfMissing((String)request.getContextPath(), (CharSequence)"/", (CharSequence[])new CharSequence[0]) + version;
        model.addAttribute("contextPath", (Object)contextPath);
        model.addAttribute("demoModeEnabled", (Object)Constants.demoModeEnabled((Environment)environment));
        model.addAttribute("devModeEnabled", (Object)Constants.devModeEnabled((Environment)environment));
        model.addAttribute("prodModeEnabled", (Object)Constants.prodModeEnabled((Environment)environment));
        model.addAttribute("_csrf", request.getAttribute(CsrfToken.class.getName()));
    }

    public static boolean prodModeEnabled(Environment environment) {
        return Constants.profileActive((Environment)environment, (String)"!dev");
    }

    public static boolean devModeEnabled(Environment environment) {
        return Constants.profileActive((Environment)environment, (String)"dev");
    }

    public static boolean demoModeEnabled(Environment environment) {
        return Constants.profileActive((Environment)environment, (String)"demo");
    }

    private static boolean profileActive(Environment environment, String profile) {
        return environment.acceptsProfiles(Profiles.of((String[])new String[]{profile}));
    }
}

