/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller;

import alfio.manager.FileUploadManager;
import alfio.model.FileBlobMetadata;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Optional;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

@Controller
public class FileController {
    private final FileUploadManager manager;
    private static final String MAX_AGE_6_MONTH = "max-age=15778463";

    public FileController(FileUploadManager manager) {
        this.manager = manager;
    }

    @GetMapping(value={"/file/{digest}"})
    public void showFile(@PathVariable String digest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String digestNoneMatchHeader = request.getHeader("If-None-Match");
        if (digest.equals(digestNoneMatchHeader) && this.manager.hasCached(digest)) {
            response.setStatus(304);
            return;
        }
        Optional res = this.manager.findMetadata(digest);
        if (res.isPresent()) {
            FileBlobMetadata metadata = (FileBlobMetadata)res.get();
            if (digest.equals(digestNoneMatchHeader)) {
                response.setStatus(304);
            } else {
                response.setContentType(metadata.getContentType());
                response.setContentLength(metadata.getContentSize());
                response.setHeader("ETag", metadata.getId());
                response.setHeader("Cache-Control", MAX_AGE_6_MONTH);
                try (ServletOutputStream os = response.getOutputStream();){
                    this.manager.outputFile(digest, (OutputStream)os);
                }
            }
        } else {
            response.sendError(404);
        }
    }
}

