/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller;

import alfio.controller.IndexController;
import alfio.controller.support.DataPreloaderManager;
import alfio.model.TicketReservationStatusAndValidation;
import alfio.repository.EventRepository;
import alfio.repository.SubscriptionRepository;
import alfio.repository.TicketReservationRepository;
import alfio.util.RequestUtils;
import ch.digitalfondue.jfiveparse.Document;
import ch.digitalfondue.jfiveparse.JFiveParse;
import ch.digitalfondue.jfiveparse.Node;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.util.UriComponentsBuilder;

@Controller
public class IndexController {
    private static final String TEXT_HTML_CHARSET_UTF_8 = "text/html;charset=UTF-8";
    private static final String UTF_8 = "UTF-8";
    private final Document indexPage;
    private final Document openGraphPage;
    private final EventRepository eventRepository;
    private final TicketReservationRepository ticketReservationRepository;
    private final SubscriptionRepository subscriptionRepository;
    private final DataPreloaderManager dataPreloaderManager;

    public IndexController(EventRepository eventRepository, TicketReservationRepository ticketReservationRepository, SubscriptionRepository subscriptionRepository, DataPreloaderManager dataPreloaderManager) {
        this.eventRepository = eventRepository;
        this.ticketReservationRepository = ticketReservationRepository;
        this.subscriptionRepository = subscriptionRepository;
        this.dataPreloaderManager = dataPreloaderManager;
        try (InputStream idxIs = new ClassPathResource("alfio-public-frontend-index.html").getInputStream();
             InputStream idxOpenIs = new ClassPathResource("alfio/web-templates/event-open-graph-page.html").getInputStream();
             InputStreamReader idxIsR = new InputStreamReader(idxIs, StandardCharsets.UTF_8);
             InputStreamReader idxOpenGraphReader = new InputStreamReader(idxOpenIs, StandardCharsets.UTF_8);){
            this.indexPage = JFiveParse.parse((Reader)idxIsR);
            this.openGraphPage = JFiveParse.parse((Reader)idxOpenGraphReader);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @RequestMapping(value={"/"}, method={RequestMethod.HEAD})
    public ResponseEntity<String> replyToProxy() {
        return ResponseEntity.ok((Object)"Up and running!");
    }

    @GetMapping(value={"/healthz"})
    public ResponseEntity<String> replyToK8s() {
        return ResponseEntity.ok((Object)"Up and running!");
    }

    @GetMapping(value={"/", "/o/*", "/o/*/events-all", "/events-all", "/event/{eventShortName}", "/event/{eventShortName}/reservation/{reservationId}/book", "/event/{eventShortName}/reservation/{reservationId}/overview", "/event/{eventShortName}/reservation/{reservationId}/waitingPayment", "/event/{eventShortName}/reservation/{reservationId}/waiting-payment", "/event/{eventShortName}/reservation/{reservationId}/deferred-payment", "/event/{eventShortName}/reservation/{reservationId}/processing-payment", "/event/{eventShortName}/reservation/{reservationId}/success", "/event/{eventShortName}/reservation/{reservationId}/not-found", "/event/{eventShortName}/reservation/{reservationId}/error", "/event/{eventShortName}/ticket/{ticketId}/view", "/event/{eventShortName}/ticket/{ticketId}/update", "/event/{eventShortName}/ticket/{ticketId}/check-in/{ticketCodeHash}/waiting-room", "/subscriptions-all", "/o/*/subscriptions-all", "/subscription/{subscriptionId}", "/subscription/{subscriptionId}/reservation/{reservationId}/book", "/subscription/{subscriptionId}/reservation/{reservationId}/overview", "/subscription/{subscriptionId}/reservation/{reservationId}/waitingPayment", "/subscription/{subscriptionId}/reservation/{reservationId}/waiting-payment", "/subscription/{subscriptionId}/reservation/{reservationId}/deferred-payment", "/subscription/{subscriptionId}/reservation/{reservationId}/processing-payment", "/subscription/{subscriptionId}/reservation/{reservationId}/success", "/subscription/{subscriptionId}/reservation/{reservationId}/not-found", "/subscription/{subscriptionId}/reservation/{reservationId}/error", "/event/{eventShortName}/poll", "/event/{eventShortName}/poll/{pollId}", "/my-orders", "/my-profile"})
    public void replyToIndex(@PathVariable(value="eventShortName", required=false) String eventShortName, @PathVariable(required=false) String subscriptionId, @RequestHeader(value="User-Agent", required=false) String userAgent, @RequestParam(value="lang", required=false) String lang, ServletWebRequest request, HttpServletResponse response, HttpSession session, Authentication authentication) throws IOException {
        response.setContentType(TEXT_HTML_CHARSET_UTF_8);
        response.setCharacterEncoding(UTF_8);
        try (ServletOutputStream os = response.getOutputStream();
             OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os, StandardCharsets.UTF_8);){
            Document doc = this.dataPreloaderManager.generateIndexDocument(eventShortName, subscriptionId, userAgent, lang, request, response, session, authentication, this.openGraphPage, this.indexPage);
            JFiveParse.serialize((Node)doc, (Writer)osw);
        }
    }

    @GetMapping(value={"/event/{eventShortName}/reservation/{reservationId}"})
    public String redirectEventToReservation(@PathVariable(value="eventShortName") String eventShortName, @PathVariable String reservationId, @RequestParam(value="subscription", required=false) String subscriptionId) {
        if (this.eventRepository.existsByShortName(eventShortName)) {
            String reservationStatusUrlSegment = this.ticketReservationRepository.findOptionalStatusAndValidationById(reservationId).map(IndexController::reservationStatusToUrlMapping).orElse("not-found");
            return "redirect:" + UriComponentsBuilder.fromPath((String)"/event/{eventShortName}/reservation/{reservationId}/{status}").queryParamIfPresent("subscription", Optional.ofNullable(StringUtils.trimToNull((String)subscriptionId))).buildAndExpand(Map.of("eventShortName", eventShortName, "reservationId", reservationId, "status", reservationStatusUrlSegment)).toUriString();
        }
        return "redirect:/";
    }

    @GetMapping(value={"/subscription/{subscriptionId}/reservation/{reservationId}"})
    public String redirectSubscriptionToReservation(@PathVariable String subscriptionId, @PathVariable String reservationId) {
        if (this.subscriptionRepository.existsById(UUID.fromString(subscriptionId))) {
            String reservationStatusUrlSegment = this.ticketReservationRepository.findOptionalStatusAndValidationById(reservationId).map(IndexController::reservationStatusToUrlMapping).orElse("not-found");
            return "redirect:" + UriComponentsBuilder.fromPath((String)"/subscription/{subscriptionId}/reservation/{reservationId}/{status}").buildAndExpand(Map.of("subscriptionId", subscriptionId, "reservationId", reservationId, "status", reservationStatusUrlSegment)).toUriString();
        }
        return "redirect:/";
    }

    private static String reservationStatusToUrlMapping(TicketReservationStatusAndValidation status) {
        return switch (1.$SwitchMap$alfio$model$TicketReservation$TicketReservationStatus[status.getStatus().ordinal()]) {
            case 1 -> {
                if (Boolean.TRUE.equals(status.getValidated())) {
                    yield "overview";
                }
                yield "book";
            }
            case 2, 3 -> "success";
            case 4, 5 -> "waiting-payment";
            case 6 -> "deferred-payment";
            case 7, 8 -> "processing-payment";
            case 9, 10 -> "error";
            default -> "not-found";
        };
    }

    @GetMapping(value={"/event/{eventShortName}/code/{code}", "/e/{eventShortName}/c/{code}"})
    public String redirectCode(@PathVariable(value="eventShortName") String eventName, @PathVariable String code, @RequestHeader(value="User-Agent", required=false) String userAgent) {
        if (RequestUtils.isSocialMediaShareUA((String)userAgent)) {
            return "redirect:" + UriComponentsBuilder.fromPath((String)"/event/{eventShortName}").build(Map.of("eventShortName", eventName));
        }
        return "redirect:" + UriComponentsBuilder.fromPath((String)"/api/v2/public/event/{eventShortName}/code/{code}").build(Map.of("eventShortName", eventName, "code", code));
    }

    @GetMapping(value={"/e/{eventShortName}"})
    public String redirectEvent(@PathVariable(value="eventShortName") String eventName) {
        return "redirect:" + UriComponentsBuilder.fromPath((String)"/event/{eventShortName}").build(Map.of("eventShortName", eventName));
    }
}

