/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller;

import alfio.manager.CheckInManager;
import alfio.manager.ExtensionManager;
import alfio.manager.TicketReservationManager;
import alfio.manager.support.CheckInStatus;
import alfio.model.EventCheckInInfo;
import alfio.model.Ticket;
import alfio.model.checkin.EventWithCheckInInfo;
import alfio.model.metadata.OnlineConfiguration;
import alfio.util.EventUtil;
import java.beans.ConstructorProperties;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.time.ZoneId;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

@Controller
public class OnlineCheckInController {
    private static final Logger log = LoggerFactory.getLogger(OnlineCheckInController.class);
    private final TicketReservationManager ticketReservationManager;
    private final CheckInManager checkInManager;
    private final ExtensionManager extensionManager;

    @GetMapping(value={"/event/{shortName}/ticket/{publicUUID}/check-in/{ticketCodeHash}"})
    public String performCheckIn(@PathVariable(value="shortName") String eventShortName, @PathVariable UUID publicUUID, @PathVariable String ticketCodeHash) {
        return this.ticketReservationManager.fetchCompleteAndAssignedForOnlineCheckIn(eventShortName, publicUUID).flatMap(data -> {
            EventWithCheckInInfo event;
            Ticket ticket = data.getTicket();
            String ticketCode = ticket.ticketCode((event = data.getEventWithCheckInInfo()).getPrivateKey(), event.supportsQRCodeCaseInsensitive());
            if (MessageDigest.isEqual(DigestUtils.sha256Hex((String)ticketCode).getBytes(StandardCharsets.UTF_8), ticketCodeHash.getBytes(StandardCharsets.UTF_8))) {
                log.debug("code successfully validated for ticket {}", (Object)publicUUID);
                OnlineConfiguration categoryConfiguration = data.getCategoryMetadata().getOnlineConfiguration();
                OnlineConfiguration eventConfiguration = event.getMetadata().getOnlineConfiguration();
                Optional match = EventUtil.findMatchingLink((ZoneId)event.getZoneId(), (OnlineConfiguration)categoryConfiguration, (OnlineConfiguration)eventConfiguration);
                if (match.isPresent()) {
                    CheckInStatus checkInStatus = this.checkInManager.performCheckinForOnlineEvent(ticket, (EventCheckInInfo)event, data.getTicketCategory());
                    log.info("check-in status {} for ticket {}", (Object)checkInStatus, (Object)publicUUID);
                    if (checkInStatus == CheckInStatus.SUCCESS || checkInStatus == CheckInStatus.ALREADY_CHECK_IN && ticket.isCheckedIn()) {
                        Optional customUrlOptional = this.extensionManager.handleOnlineCheckInLink((String)match.get(), ticket, event, data.getTicketAdditionalInfo());
                        return customUrlOptional.or(() -> match);
                    }
                    log.info("denying check-in for ticket {} because check-in status was {}", (Object)publicUUID, (Object)checkInStatus);
                    return Optional.of("/event/" + event.getShortName() + "/ticket/" + publicUUID + "/update");
                }
                log.info("validation was successful, but cannot find a valid link for {}", (Object)publicUUID);
                return Optional.of("/event/" + event.getShortName() + "/ticket/" + publicUUID + "/check-in/" + ticketCodeHash + "/waiting-room");
            }
            log.warn("code validation failed for ticket {}", (Object)publicUUID);
            return Optional.empty();
        }).map(link -> "redirect:" + link).orElse("redirect:/");
    }

    @ConstructorProperties(value={"ticketReservationManager", "checkInManager", "extensionManager"})
    @Generated
    public OnlineCheckInController(TicketReservationManager ticketReservationManager, CheckInManager checkInManager, ExtensionManager extensionManager) {
        this.ticketReservationManager = ticketReservationManager;
        this.checkInManager = checkInManager;
        this.extensionManager = extensionManager;
    }
}

