/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api;

import alfio.controller.api.v2.user.support.ReservationAccessDenied;
import alfio.manager.support.AccessDeniedException;
import jakarta.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice(basePackages={"alfio.controller.api.admin", "alfio.controller.api.support", "alfio.controller.api.v1", "alfio.controller.api.v2"})
public class ApiControllerExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(ApiControllerExceptionHandler.class);

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public String exception(Exception ex) {
        log.error("unexpected exception", (Throwable)ex);
        return "unexpected exception";
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @ResponseStatus(value=HttpStatus.METHOD_NOT_ALLOWED)
    @ResponseBody
    public String requestNotSupported(HttpRequestMethodNotSupportedException ex, HttpServletRequest request) {
        log.warn("Request method {} not allowed for request {}", (Object)request.getMethod(), (Object)request.getRequestURI());
        return "method not supported";
    }

    @ExceptionHandler(value={HttpMessageConversionException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public String badRequest(HttpMessageConversionException e) {
        log.error("message conversion exception", (Throwable)e);
        return "bad request";
    }

    @ExceptionHandler(value={ReservationAccessDenied.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ResponseBody
    public String notAuthorized(ReservationAccessDenied rad) {
        log.trace("intercepted ReservationAccessDenied", (Throwable)rad);
        return "Access to this reservation has been denied";
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public String accessDenied(AccessDeniedException accessDeniedException) {
        log.trace("intercepted AccessDeniedException", (Throwable)accessDeniedException);
        return "Access to resource has been denied";
    }
}

