/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.admin;

import alfio.manager.AccessService;
import alfio.manager.PurchaseContextFieldManager;
import alfio.manager.PurchaseContextManager;
import alfio.model.DynamicFieldTemplate;
import alfio.model.FieldConfigurationAndAllDescriptions;
import alfio.model.PurchaseContext;
import alfio.model.RestrictedValueStats;
import alfio.model.modification.AdditionalFieldRequest;
import alfio.model.modification.EventModification;
import alfio.model.modification.TicketFieldDescriptionModification;
import alfio.model.result.ValidationResult;
import alfio.repository.DynamicFieldTemplateRepository;
import alfio.util.MiscUtils;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/api/{purchaseContextType}/{publicIdentifier}/additional-field"})
public class AdditionalFieldApiController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdditionalFieldApiController.class);
    private final PurchaseContextManager purchaseContextManager;
    private final PurchaseContextFieldManager purchaseContextFieldManager;
    private final AccessService accessService;
    private final DynamicFieldTemplateRepository dynamicFieldTemplateRepository;

    public AdditionalFieldApiController(PurchaseContextManager purchaseContextManager, PurchaseContextFieldManager purchaseContextFieldManager, AccessService accessService, DynamicFieldTemplateRepository dynamicFieldTemplateRepository) {
        this.purchaseContextManager = purchaseContextManager;
        this.purchaseContextFieldManager = purchaseContextFieldManager;
        this.accessService = accessService;
        this.dynamicFieldTemplateRepository = dynamicFieldTemplateRepository;
    }

    @GetMapping(value={"/templates"})
    public List<DynamicFieldTemplate> loadTemplates(@PathVariable PurchaseContext.PurchaseContextType purchaseContextType, @PathVariable String publicIdentifier) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Loading templates for {} {}", (Object)purchaseContextType, (Object)MiscUtils.removeTabsAndNewlines((String)publicIdentifier));
        }
        return this.dynamicFieldTemplateRepository.loadAll();
    }

    @GetMapping
    public List<FieldConfigurationAndAllDescriptions> getAllAdditionalField(@PathVariable PurchaseContext.PurchaseContextType purchaseContextType, @PathVariable String publicIdentifier, Principal principal) {
        this.accessService.checkPurchaseContextOwnership(principal, purchaseContextType, publicIdentifier);
        PurchaseContext purchaseContext = (PurchaseContext)this.purchaseContextManager.findBy(purchaseContextType, publicIdentifier).orElseThrow();
        Map descById = this.purchaseContextFieldManager.findDescriptionsGroupedByFieldId(purchaseContext);
        return this.purchaseContextFieldManager.findAdditionalFields(purchaseContext).stream().map(field -> new FieldConfigurationAndAllDescriptions(field, descById.getOrDefault(field.getId(), Collections.emptyList()))).toList();
    }

    @GetMapping(value={"/{id}/stats"})
    public List<RestrictedValueStats> getStats(@PathVariable PurchaseContext.PurchaseContextType purchaseContextType, @PathVariable String publicIdentifier, @PathVariable long id, Principal principal) {
        this.accessService.checkPurchaseContextOwnership(principal, purchaseContextType, publicIdentifier);
        return this.purchaseContextFieldManager.retrieveStats(id);
    }

    @PostMapping(value={"/new"})
    public ValidationResult addAdditionalField(@PathVariable PurchaseContext.PurchaseContextType purchaseContextType, @PathVariable String publicIdentifier, @RequestBody AdditionalFieldRequest field, Principal principal, Errors errors) {
        this.accessService.checkPurchaseContextOwnership(principal, purchaseContextType, publicIdentifier);
        PurchaseContext purchaseContext = (PurchaseContext)this.purchaseContextManager.findBy(purchaseContextType, publicIdentifier).orElseThrow();
        return this.purchaseContextFieldManager.validateAndAddField(purchaseContext, field, errors);
    }

    @PostMapping(value={"/descriptions"})
    public void saveAdditionalFieldDescriptions(@PathVariable PurchaseContext.PurchaseContextType purchaseContextType, @PathVariable String publicIdentifier, @RequestBody Map<String, TicketFieldDescriptionModification> descriptions, Principal principal) {
        this.accessService.checkPurchaseContextOwnershipAndTicketAdditionalFieldIds(principal, purchaseContextType, publicIdentifier, descriptions.values().stream().map(TicketFieldDescriptionModification::getTicketFieldConfigurationId).collect(Collectors.toSet()));
        this.purchaseContextFieldManager.updateFieldDescriptions(descriptions, this.purchaseContextManager.getOrganizationId(purchaseContextType, publicIdentifier));
    }

    @PostMapping(value={"/swap-position/{id1}/{id2}"})
    public void swapAdditionalFieldPosition(@PathVariable PurchaseContext.PurchaseContextType purchaseContextType, @PathVariable String publicIdentifier, @PathVariable long id1, @PathVariable long id2, Principal principal) {
        this.accessService.checkPurchaseContextOwnershipAndTicketAdditionalFieldIds(principal, purchaseContextType, publicIdentifier, Set.of(Long.valueOf(id1), Long.valueOf(id2)));
        this.purchaseContextFieldManager.swapAdditionalFieldPosition(id1, id2);
    }

    @PostMapping(value={"/set-position/{id}"})
    public void setAdditionalFieldPosition(@PathVariable PurchaseContext.PurchaseContextType purchaseContextType, @PathVariable String publicIdentifier, @PathVariable long id, @RequestParam(value="newPosition") int newPosition, Principal principal) {
        this.accessService.checkPurchaseContextOwnershipAndTicketAdditionalFieldIds(principal, purchaseContextType, publicIdentifier, Set.of(Long.valueOf(id)));
        this.purchaseContextFieldManager.setAdditionalFieldPosition(id, newPosition);
    }

    @DeleteMapping(value={"/{id}"})
    public void deleteAdditionalField(@PathVariable PurchaseContext.PurchaseContextType purchaseContextType, @PathVariable String publicIdentifier, @PathVariable long id, Principal principal) {
        this.accessService.checkPurchaseContextOwnershipAndTicketAdditionalFieldIds(principal, purchaseContextType, publicIdentifier, Set.of(Long.valueOf(id)));
        this.purchaseContextFieldManager.deleteAdditionalField(id);
    }

    @PostMapping(value={"/{id}"})
    public void updateAdditionalField(@PathVariable PurchaseContext.PurchaseContextType purchaseContextType, @PathVariable String publicIdentifier, @PathVariable long id, @RequestBody EventModification.UpdateAdditionalField field, Principal principal) {
        this.accessService.checkPurchaseContextOwnershipAndTicketAdditionalFieldIds(principal, purchaseContextType, publicIdentifier, Set.of(Long.valueOf(id)));
        this.purchaseContextFieldManager.updateAdditionalField(id, field, this.purchaseContextManager.getOrganizationId(purchaseContextType, publicIdentifier));
    }
}

