/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.admin;

import alfio.controller.api.support.AdditionalItemSwapRequest;
import alfio.manager.AccessService;
import alfio.manager.AdditionalServiceManager;
import alfio.manager.EventManager;
import alfio.model.AdditionalService;
import alfio.model.AdditionalServiceItem;
import alfio.model.ContentLanguage;
import alfio.model.Event;
import alfio.model.PriceContainer;
import alfio.model.modification.EventModification;
import alfio.model.result.ValidationResult;
import alfio.repository.EventRepository;
import alfio.util.ExportUtils;
import alfio.util.MonetaryUtil;
import alfio.util.Validator;
import jakarta.servlet.http.HttpServletResponse;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.security.Principal;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/admin/api"})
public class AdditionalServiceApiController {
    private static final Logger log = LoggerFactory.getLogger(AdditionalServiceApiController.class);
    private final EventManager eventManager;
    private final EventRepository eventRepository;
    private final AdditionalServiceManager additionalServiceManager;
    private final AccessService accessService;

    @ExceptionHandler(value={IllegalArgumentException.class})
    public ResponseEntity<String> handleBadRequest(Exception e) {
        log.warn("bad input detected", (Throwable)e);
        return new ResponseEntity((Object)"bad input parameters", (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<String> handleError(Exception e) {
        log.error("error", (Throwable)e);
        return new ResponseEntity((Object)"internal server error", (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @GetMapping(value={"/event/{eventId}/additional-services"})
    public List<EventModification.AdditionalService> loadAll(@PathVariable int eventId, Principal principal) {
        this.accessService.checkEventOwnership(principal, eventId);
        return this.eventRepository.findOptionalById(eventId).map(event -> this.additionalServiceManager.loadAllForEvent(eventId).stream().map(as -> EventModification.AdditionalService.from((AdditionalService)as).withText(this.additionalServiceManager.findAllTextByAdditionalServiceId(as.id())).withZoneId(event.getZoneId()).withPriceContainer(AdditionalServiceApiController.buildPriceContainer((Event)event, (AdditionalService)as)).build()).toList()).orElse(Collections.emptyList());
    }

    @GetMapping(value={"/event/{eventId}/additional-services/count"})
    public Map<Integer, Map<AdditionalServiceItem.AdditionalServiceItemStatus, Integer>> countUse(@PathVariable int eventId, Principal principal) {
        this.accessService.checkEventOwnership(principal, eventId);
        return this.additionalServiceManager.countUsageForEvent(eventId);
    }

    @PostMapping(value={"/event/{eventId}/additional-services/swap-position"})
    public void swapPosition(@PathVariable int eventId, @RequestBody AdditionalItemSwapRequest request, Principal principal) {
        this.accessService.checkEventOwnership(principal, eventId);
        this.additionalServiceManager.swapAdditionalServicesPosition(eventId, request.id1(), request.id2());
    }

    @PutMapping(value={"/event/{eventId}/additional-services/{additionalServiceId}"})
    @Transactional
    public ResponseEntity<EventModification.AdditionalService> update(@PathVariable int eventId, @PathVariable int additionalServiceId, @RequestBody EventModification.AdditionalService additionalService, BindingResult bindingResult, Principal principal) {
        this.accessService.checkEventOwnership(principal, eventId);
        Optional optional = this.additionalServiceManager.getOptionalById(additionalServiceId, eventId);
        Assert.isTrue((boolean)optional.isPresent(), (String)("No additional service with id " + additionalServiceId + " present in eventId " + eventId));
        AdditionalService existing = (AdditionalService)optional.get();
        Assert.isTrue((existing.availableQuantity() == -1 || additionalService.getAvailableQuantity() > 0 ? 1 : 0) != 0, (String)"Missing available quantity");
        ValidationResult validationResult = Validator.validateAdditionalService((EventModification.AdditionalService)additionalService, (Errors)bindingResult);
        Validate.isTrue((boolean)validationResult.isSuccess(), (String)"validation failed", (Object[])new Object[0]);
        Validate.isTrue((additionalServiceId == additionalService.getId() ? 1 : 0) != 0, (String)"wrong input", (Object[])new Object[0]);
        return this.eventRepository.findOptionalById(eventId).map(event -> {
            int result = this.additionalServiceManager.update(additionalServiceId, event, additionalService);
            Validate.isTrue((result <= 1 ? 1 : 0) != 0, (String)"too many records updated", (Object[])new Object[0]);
            Stream.concat(additionalService.getTitle().stream(), additionalService.getDescription().stream()).forEach(t -> {
                if (t.getId() != null) {
                    this.additionalServiceManager.updateText(t.getId(), t.getLocale(), t.getType(), t.getValue(), Integer.valueOf(additionalServiceId));
                } else {
                    this.additionalServiceManager.insertText(additionalService.getId(), t.getLocale(), t.getType(), t.getValue());
                }
            });
            return ResponseEntity.ok((Object)additionalService);
        }).orElseThrow(IllegalArgumentException::new);
    }

    @PostMapping(value={"/event/{eventId}/additional-services"})
    @Transactional
    public ResponseEntity<EventModification.AdditionalService> insert(@PathVariable int eventId, @RequestBody EventModification.AdditionalService additionalService, BindingResult bindingResult, Principal principal) {
        this.accessService.checkEventOwnership(principal, eventId);
        ValidationResult validationResult = Validator.validateAdditionalService((EventModification.AdditionalService)additionalService, (Errors)bindingResult);
        Validate.isTrue((boolean)validationResult.isSuccess(), (String)"validation failed", (Object[])new Object[0]);
        return this.eventRepository.findOptionalById(eventId).map(event -> ResponseEntity.ok((Object)this.additionalServiceManager.insertAdditionalService(event, additionalService))).orElseThrow(IllegalArgumentException::new);
    }

    @DeleteMapping(value={"/event/{eventId}/additional-services/{additionalServiceId}"})
    @Transactional
    public ResponseEntity<String> remove(@PathVariable int eventId, @PathVariable int additionalServiceId, Principal principal) {
        this.accessService.checkAdditionalServiceOwnership(principal, eventId, additionalServiceId);
        log.debug("{} is deleting additional service #{}", (Object)principal.getName(), (Object)additionalServiceId);
        this.additionalServiceManager.deleteAdditionalService(additionalServiceId, eventId);
        return ResponseEntity.ok((Object)"OK");
    }

    @GetMapping(value={"/events/{eventName}/additional-services/{type}/export"})
    public void exportAdditionalServices(@PathVariable String eventName, @PathVariable(value="type") AdditionalService.AdditionalServiceType additionalServiceType, HttpServletResponse response, Principal principal) throws IOException {
        this.accessService.checkEventOwnership(principal, eventName);
        Event event = (Event)this.eventManager.getOptionalByName(eventName, principal.getName()).orElseThrow();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
        List<String> header = List.of("ID", "Name", "Creation", "Last Update", "Status", "Reservation ID", "Reservation First name", "Reservation Last name", "Reservation Email address", "Paid Amount", "Currency", "VAT", "Discount");
        String locale = ((ContentLanguage)event.getContentLanguages().get(0)).getLanguage();
        Stream<String[]> rows = this.additionalServiceManager.exportItemsForEvent(additionalServiceType, event.getId(), locale).stream().map(item -> new String[]{item.getUuid(), item.getAdditionalServiceTitle(), item.getUtcCreation().withZoneSameInstant(event.getZoneId()).format(formatter), Objects.requireNonNullElse(item.getUtcLastModified(), item.getUtcCreation()).withZoneSameInstant(event.getZoneId()).format(formatter), item.getAdditionalServiceItemStatus().name(), item.getTicketsReservationUuid(), item.getFirstName(), item.getLastName(), item.getEmailAddress(), MonetaryUtil.formatCents((int)item.getFinalPriceCts(), (String)item.getCurrencyCode()), item.getCurrencyCode(), MonetaryUtil.formatCents((int)item.getVatCts(), (String)item.getCurrencyCode()), MonetaryUtil.formatCents((int)item.getDiscountCts(), (String)item.getCurrencyCode())});
        ExportUtils.exportExcel((String)(event.getShortName() + "-" + additionalServiceType.name() + ".xlsx"), (String)additionalServiceType.name(), (String[])((String[])header.toArray(String[]::new)), rows, (HttpServletResponse)response);
    }

    @PostMapping(value={"/additional-services/validate"})
    public ValidationResult checkAdditionalService(@RequestBody EventModification.AdditionalService additionalService, BindingResult bindingResult) {
        return Validator.validateAdditionalService((EventModification.AdditionalService)additionalService, (Errors)bindingResult);
    }

    private static PriceContainer buildPriceContainer(Event event, AdditionalService as) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @ConstructorProperties(value={"eventManager", "eventRepository", "additionalServiceManager", "accessService"})
    @Generated
    public AdditionalServiceApiController(EventManager eventManager, EventRepository eventRepository, AdditionalServiceManager additionalServiceManager, AccessService accessService) {
        this.eventManager = eventManager;
        this.eventRepository = eventRepository;
        this.additionalServiceManager = additionalServiceManager;
        this.accessService = accessService;
    }
}

