/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.admin;

import alfio.controller.api.support.PageAndContent;
import alfio.manager.AccessService;
import alfio.manager.PaymentManager;
import alfio.manager.PurchaseContextManager;
import alfio.manager.PurchaseContextSearchManager;
import alfio.manager.system.ConfigurationManager;
import alfio.model.PurchaseContext;
import alfio.model.ReservationPaymentDetail;
import alfio.model.modification.DateTimeModification;
import alfio.model.modification.TransactionMetadataModification;
import alfio.model.system.ConfigurationKeys;
import alfio.util.ExportUtils;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.security.Principal;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/admin/api/payments"})
public class AdminPaymentsApiController {
    private static final String[] EXPORT_COLUMNS = new String[]{"ID", "Name", "Email", "Type", "Amount", "Currency", "Payment Date/Time", "Notes"};
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private final PurchaseContextSearchManager purchaseContextSearchManager;
    private final PurchaseContextManager purchaseContextManager;
    private final PaymentManager paymentManager;
    private final ConfigurationManager configurationManager;
    private final AccessService accessService;

    public AdminPaymentsApiController(PurchaseContextSearchManager purchaseContextSearchManager, PurchaseContextManager purchaseContextManager, PaymentManager paymentManager, ConfigurationManager configurationManager, AccessService accessService) {
        this.purchaseContextSearchManager = purchaseContextSearchManager;
        this.purchaseContextManager = purchaseContextManager;
        this.paymentManager = paymentManager;
        this.configurationManager = configurationManager;
        this.accessService = accessService;
    }

    @GetMapping(value={"/{purchaseContextType}/{publicIdentifier}/list"})
    PageAndContent<List<ReservationPaymentDetail>> getPaymentsForPurchaseContext(@PathVariable PurchaseContext.PurchaseContextType purchaseContextType, @PathVariable String publicIdentifier, @RequestParam(value="page", required=false) Integer page, @RequestParam(value="search", required=false) String search, Principal principal) {
        return this.purchaseContextManager.findBy(purchaseContextType, publicIdentifier).map(purchaseContext -> {
            this.accessService.checkOrganizationOwnership(principal, Integer.valueOf(purchaseContext.getOrganizationId()));
            Pair res = this.purchaseContextSearchManager.findAllPaymentsFor(purchaseContext, page, search);
            return new PageAndContent((Object)((List)res.getLeft()), (Integer)res.getRight());
        }).orElseGet(() -> new PageAndContent(List.of(), Integer.valueOf(0)));
    }

    @PutMapping(value={"/{purchaseContextType}/{publicIdentifier}/reservation/{reservationId}"})
    ResponseEntity<String> updateTransactionData(@PathVariable PurchaseContext.PurchaseContextType purchaseContextType, @PathVariable String publicIdentifier, @PathVariable String reservationId, @RequestBody TransactionMetadataModification transactionMetadataModification, Principal principal) {
        try {
            return ResponseEntity.of(this.purchaseContextManager.findBy(purchaseContextType, publicIdentifier).map(purchaseContext -> {
                this.accessService.checkOrganizationOwnership(principal, Integer.valueOf(purchaseContext.getOrganizationId()));
                DateTimeModification timestampModification = transactionMetadataModification.getTimestamp();
                ZonedDateTime timestamp = timestampModification != null ? timestampModification.toZonedDateTime(purchaseContext.getZoneId()) : null;
                this.paymentManager.updateTransactionDetails(reservationId, transactionMetadataModification.getNotes(), timestamp, principal);
                return "OK";
            }));
        }
        catch (IllegalArgumentException ex) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)ex.getMessage());
        }
    }

    @GetMapping(value={"/{purchaseContextType}/{publicIdentifier}/download"})
    void exportPayments(@PathVariable PurchaseContext.PurchaseContextType purchaseContextType, @PathVariable String publicIdentifier, @RequestParam(value="search", required=false) String search, Principal principal, HttpServletResponse response) throws IOException {
        Optional purchaseContextOptional = this.purchaseContextManager.findBy(purchaseContextType, publicIdentifier);
        if (purchaseContextOptional.isPresent()) {
            PurchaseContext purchaseContext = (PurchaseContext)purchaseContextOptional.get();
            this.accessService.checkOrganizationOwnership(principal, Integer.valueOf(purchaseContext.getOrganizationId()));
            boolean useInvoiceNumber = this.configurationManager.getFor(ConfigurationKeys.USE_INVOICE_NUMBER_AS_ID, purchaseContext.getConfigurationLevel()).getValueAsBooleanOrDefault();
            Stream<String[]> data = this.purchaseContextSearchManager.findAllPaymentsForExport(purchaseContext, search).stream().map(d -> new String[]{useInvoiceNumber ? Objects.requireNonNullElse(StringUtils.trimToNull((String)d.getInvoiceNumber()), "N/A") : d.getId(), d.getFirstName() + " " + d.getLastName(), d.getEmail(), d.getPaymentMethod(), d.getPaidAmount(), d.getCurrencyCode(), AdminPaymentsApiController.formatTimestamp((PurchaseContext)purchaseContext, (String)d.getTransactionTimestamp()), d.getTransactionNotes()});
            ExportUtils.exportExcel((String)(purchaseContext.getDisplayName() + " payments.xlsx"), (String)"Payments", (String[])EXPORT_COLUMNS, data, (HttpServletResponse)response);
        } else {
            response.setContentType("text/plain");
            response.setStatus(HttpStatus.PRECONDITION_REQUIRED.value());
            response.getWriter().write("No payments found");
        }
    }

    private static String formatTimestamp(PurchaseContext purchaseContext, String timestamp) {
        return ZonedDateTime.parse(timestamp).withZoneSameInstant(purchaseContext.getZoneId()).format(DATE_TIME_FORMATTER);
    }
}

