/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.admin;

import alfio.controller.api.admin.AdminReservationApiController;
import alfio.controller.api.admin.SerializablePair;
import alfio.controller.api.support.BookingInfoTicket;
import alfio.controller.api.support.BookingInfoTicketLoader;
import alfio.controller.api.support.PageAndContent;
import alfio.manager.AccessService;
import alfio.manager.AdminReservationManager;
import alfio.manager.EventManager;
import alfio.manager.PurchaseContextManager;
import alfio.manager.PurchaseContextSearchManager;
import alfio.manager.TicketReservationManager;
import alfio.model.Audit;
import alfio.model.BillingDocument;
import alfio.model.Event;
import alfio.model.LightweightMailMessage;
import alfio.model.PurchaseContext;
import alfio.model.PurchaseContextFieldConfiguration;
import alfio.model.Ticket;
import alfio.model.TicketReservation;
import alfio.model.TransactionAndPaymentInfo;
import alfio.model.modification.AdminReservationModification;
import alfio.model.result.ErrorCode;
import alfio.model.result.Result;
import alfio.model.subscription.SubscriptionWithUsageDetails;
import alfio.util.FileUtil;
import jakarta.servlet.http.HttpServletResponse;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/admin/api/reservation"})
@RestController
public class AdminReservationApiController {
    private final AdminReservationManager adminReservationManager;
    private final EventManager eventManager;
    private final PurchaseContextManager purchaseContextManager;
    private final PurchaseContextSearchManager purchaseContextSearchManager;
    private final TicketReservationManager ticketReservationManager;
    private final BookingInfoTicketLoader bookingInfoTicketLoader;
    private final AccessService accessService;

    @PostMapping(value={"/{purchaseContextType}/{publicIdentifier}/new"})
    public Result<String> createNew(@PathVariable PurchaseContext.PurchaseContextType purchaseContextType, @PathVariable String publicIdentifier, @RequestBody AdminReservationModification reservation, Principal principal) {
        if (purchaseContextType != PurchaseContext.PurchaseContextType.event) {
            return Result.error((ErrorCode)ErrorCode.EventError.NOT_FOUND);
        }
        this.accessService.checkEventMembership(principal, publicIdentifier, AccessService.MEMBERSHIP_ROLES);
        return this.adminReservationManager.createReservation(reservation, publicIdentifier, principal.getName()).map(r -> ((TicketReservation)r.getLeft()).getId());
    }

    @GetMapping(value={"/{purchaseContextType}/{publicIdentifier}/reservations/all-status"})
    public TicketReservation.TicketReservationStatus[] getAllStatus(@PathVariable PurchaseContext.PurchaseContextType purchaseContextType, @PathVariable String publicIdentifier) {
        return TicketReservation.TicketReservationStatus.values();
    }

    @GetMapping(value={"/{purchaseContextType}/{publicIdentifier}/reservations/list"})
    public PageAndContent<List<TicketReservation>> findAll(@PathVariable PurchaseContext.PurchaseContextType purchaseContextType, @PathVariable String publicIdentifier, @RequestParam(value="page", required=false) Integer page, @RequestParam(value="search", required=false) String search, @RequestParam(value="status", required=false) List<TicketReservation.TicketReservationStatus> status, Principal principal) {
        return this.purchaseContextManager.findBy(purchaseContextType, publicIdentifier).map(purchaseContext -> {
            this.accessService.checkOrganizationOwnership(principal, Integer.valueOf(purchaseContext.getOrganizationId()));
            Pair res = this.purchaseContextSearchManager.findAllReservationsFor(purchaseContext, page, search, status);
            return new PageAndContent((Object)((List)res.getLeft()), (Integer)res.getRight());
        }).orElseGet(() -> new PageAndContent(Collections.emptyList(), Integer.valueOf(0)));
    }

    @PutMapping(value={"/{purchaseContextType}/{publicIdentifier}/{reservationId}/confirm"})
    public Result<TicketReservationDescriptor> confirmReservation(@PathVariable PurchaseContext.PurchaseContextType purchaseContextType, @PathVariable String publicIdentifier, @PathVariable String reservationId, Principal principal) {
        this.accessService.checkReservationMembership(principal, purchaseContextType, publicIdentifier, reservationId);
        return this.adminReservationManager.confirmReservation(purchaseContextType, publicIdentifier, reservationId, principal.getName(), AdminReservationModification.Notification.EMPTY).map(triple -> this.toReservationDescriptor(reservationId, triple));
    }

    @PostMapping(value={"/{purchaseContextType}/{publicIdentifier}/{reservationId}"})
    public Result<Boolean> updateReservation(@PathVariable PurchaseContext.PurchaseContextType purchaseContextType, @PathVariable String publicIdentifier, @PathVariable String reservationId, @RequestBody AdminReservationModification arm, Principal principal) {
        this.accessService.checkReservationMembership(principal, purchaseContextType, publicIdentifier, reservationId);
        return this.adminReservationManager.updateReservation(purchaseContextType, publicIdentifier, reservationId, arm, principal.getName());
    }

    @PutMapping(value={"/{purchaseContextType}/{publicIdentifier}/{reservationId}/notify"})
    public Result<Boolean> notifyReservation(@PathVariable PurchaseContext.PurchaseContextType purchaseContextType, @PathVariable String publicIdentifier, @PathVariable String reservationId, @RequestBody AdminReservationModification arm, Principal principal) {
        this.accessService.checkReservationMembership(principal, purchaseContextType, publicIdentifier, reservationId);
        return this.adminReservationManager.notify(purchaseContextType, publicIdentifier, reservationId, arm, principal.getName());
    }

    @PutMapping(value={"/event/{publicIdentifier}/{reservationId}/notify-attendees"})
    public Result<Boolean> notifyAttendees(@PathVariable String publicIdentifier, @PathVariable String reservationId, @RequestBody List<Integer> ids, Principal principal) {
        this.accessService.checkReservationMembership(principal, PurchaseContext.PurchaseContextType.event, publicIdentifier, reservationId);
        return this.adminReservationManager.notifyAttendees(publicIdentifier, reservationId, ids, principal.getName());
    }

    @GetMapping(value={"/{purchaseContextType}/{publicIdentifier}/{reservationId}/audit"})
    public Result<List<Audit>> getAudit(@PathVariable PurchaseContext.PurchaseContextType purchaseContextType, @PathVariable String publicIdentifier, @PathVariable String reservationId, Principal principal) {
        this.accessService.checkReservationMembership(principal, purchaseContextType, publicIdentifier, reservationId);
        return this.adminReservationManager.getAudit(purchaseContextType, publicIdentifier, reservationId, principal.getName());
    }

    @GetMapping(value={"/{purchaseContextType}/{publicIdentifier}/{reservationId}/billing-documents"})
    public Result<List<BillingDocument>> getBillingDocuments(@PathVariable PurchaseContext.PurchaseContextType purchaseContextType, @PathVariable String publicIdentifier, @PathVariable String reservationId, Principal principal) {
        this.accessService.checkReservationOwnership(principal, purchaseContextType, publicIdentifier, reservationId);
        return this.adminReservationManager.getBillingDocuments(publicIdentifier, reservationId, principal.getName());
    }

    @DeleteMapping(value={"/{purchaseContextType}/{publicIdentifier}/{reservationId}/billing-document/{documentId}"})
    public ResponseEntity<Boolean> invalidateBillingDocument(@PathVariable PurchaseContext.PurchaseContextType purchaseContextType, @PathVariable String publicIdentifier, @PathVariable String reservationId, @PathVariable long documentId, Principal principal) {
        this.accessService.checkBillingDocumentOwnership(principal, purchaseContextType, publicIdentifier, reservationId, documentId);
        Result invalidateResult = this.adminReservationManager.invalidateBillingDocument(reservationId, documentId, principal.getName());
        if (invalidateResult.isSuccess()) {
            return ResponseEntity.ok((Object)((Boolean)invalidateResult.getData()));
        }
        return ResponseEntity.badRequest().build();
    }

    @PutMapping(value={"/{purchaseContextType}/{publicIdentifier}/{reservationId}/billing-document/{documentId}/restore"})
    public ResponseEntity<Boolean> restoreBillingDocument(@PathVariable PurchaseContext.PurchaseContextType purchaseContextType, @PathVariable String publicIdentifier, @PathVariable String reservationId, @PathVariable long documentId, Principal principal) {
        this.accessService.checkReservationOwnership(principal, purchaseContextType, publicIdentifier, reservationId);
        Result restoreResult = this.adminReservationManager.restoreBillingDocument(reservationId, documentId, principal.getName());
        if (restoreResult.isSuccess()) {
            return ResponseEntity.ok((Object)((Boolean)restoreResult.getData()));
        }
        return ResponseEntity.badRequest().build();
    }

    @GetMapping(value={"/{purchaseContextType}/{publicIdentifier}/{reservationId}/billing-document/{documentId}"})
    public ResponseEntity<Void> getBillingDocument(@PathVariable PurchaseContext.PurchaseContextType purchaseContextType, @PathVariable String publicIdentifier, @PathVariable String reservationId, @PathVariable long documentId, Principal principal, HttpServletResponse response) {
        this.accessService.checkReservationOwnership(principal, purchaseContextType, publicIdentifier, reservationId);
        Result result = this.adminReservationManager.getSingleBillingDocumentAsPdf(purchaseContextType, publicIdentifier, reservationId, documentId, principal.getName()).map(res -> FileUtil.sendPdf((byte[])((byte[])res.getRight()), (HttpServletResponse)response, (String)publicIdentifier, (String)reservationId, (BillingDocument)((BillingDocument)res.getLeft())));
        if (result.isSuccess()) {
            return ResponseEntity.ok(null);
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/{purchaseContextType}/{publicIdentifier}/{reservationId}"})
    public Result<TicketReservationDescriptor> loadReservation(@PathVariable PurchaseContext.PurchaseContextType purchaseContextType, @PathVariable String publicIdentifier, @PathVariable String reservationId, Principal principal) {
        this.accessService.checkReservationMembership(principal, purchaseContextType, publicIdentifier, reservationId);
        return this.adminReservationManager.loadReservation(purchaseContextType, publicIdentifier, reservationId, principal.getName()).map(triple -> this.toReservationDescriptor(reservationId, triple));
    }

    @GetMapping(value={"/{purchaseContextType}/{publicIdentifier}/{reservationId}/ticket/{ticketId}"})
    public Result<Ticket> loadTicket(@PathVariable PurchaseContext.PurchaseContextType purchaseContextType, @PathVariable String publicIdentifier, @PathVariable String reservationId, @PathVariable int ticketId, Principal principal) {
        this.accessService.checkTicketMembership(principal, publicIdentifier, reservationId, ticketId);
        return this.adminReservationManager.loadReservation(purchaseContextType, publicIdentifier, reservationId, principal.getName()).flatMap(triple -> ((List)triple.getMiddle()).stream().filter(t -> t.getId() == ticketId).findFirst().map(Result::success).orElse(Result.error((ErrorCode)ErrorCode.custom((String)"not_found", (String)"not found"))));
    }

    @GetMapping(value={"/{purchaseContextType}/{publicIdentifier}/{reservationId}/tickets-with-additional-data"})
    public List<Integer> ticketsWithAdditionalData(@PathVariable PurchaseContext.PurchaseContextType purchaseContextType, @PathVariable String publicIdentifier, @PathVariable String reservationId, Principal principal) {
        if (purchaseContextType != PurchaseContext.PurchaseContextType.event) {
            return List.of();
        }
        this.accessService.checkReservationMembership(principal, purchaseContextType, publicIdentifier, reservationId);
        return this.adminReservationManager.getTicketIdsWithAdditionalData(purchaseContextType, publicIdentifier, reservationId);
    }

    @PostMapping(value={"/event/{publicIdentifier}/{reservationId}/remove-tickets"})
    public Result<RemoveResult> removeTickets(@PathVariable String publicIdentifier, @PathVariable String reservationId, @RequestBody RemoveTicketsModification toRemove, Principal principal) {
        this.accessService.checkReservationMembership(principal, PurchaseContext.PurchaseContextType.event, publicIdentifier, reservationId);
        List toRefund = toRemove.getRefundTo().entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toList());
        boolean issueCreditNote = (Boolean)this.adminReservationManager.removeTickets(publicIdentifier, reservationId, toRemove.getTicketIds(), toRefund, toRemove.getNotify().booleanValue(), toRemove.issueCreditNote.booleanValue(), principal.getName()).getData();
        return Result.success((Object)new RemoveResult(true, issueCreditNote));
    }

    @GetMapping(value={"/{purchaseContextType}/{publicIdentifier}/{reservationId}/payment-info"})
    public Result<TransactionAndPaymentInfo> getPaymentInfo(@PathVariable PurchaseContext.PurchaseContextType purchaseContextType, @PathVariable String publicIdentifier, @PathVariable String reservationId, Principal principal) {
        this.accessService.checkReservationMembership(principal, purchaseContextType, publicIdentifier, reservationId);
        return this.adminReservationManager.getPaymentInfo(reservationId);
    }

    @PostMapping(value={"/{purchaseContextType}/{publicIdentifier}/{reservationId}/cancel"})
    public Result<Boolean> removeReservation(@PathVariable PurchaseContext.PurchaseContextType purchaseContextType, @PathVariable String publicIdentifier, @PathVariable String reservationId, @RequestParam(value="refund") boolean refund, @RequestParam(value="notify", defaultValue="false") boolean notify, @RequestParam(value="issueCreditNote", defaultValue="false") boolean issueCreditNote, Principal principal) {
        this.accessService.checkReservationMembership(principal, purchaseContextType, publicIdentifier, reservationId);
        return this.adminReservationManager.removeReservation(purchaseContextType, publicIdentifier, reservationId, refund, notify, issueCreditNote, principal.getName());
    }

    @PostMapping(value={"/{purchaseContextType}/{publicIdentifier}/{reservationId}/credit"})
    public Result<Boolean> creditReservation(@PathVariable PurchaseContext.PurchaseContextType purchaseContextType, @PathVariable String publicIdentifier, @PathVariable String reservationId, @RequestParam(value="refund") boolean refund, @RequestParam(value="notify", defaultValue="false") boolean notify, Principal principal) {
        this.accessService.checkReservationOwnership(principal, purchaseContextType, publicIdentifier, reservationId);
        this.adminReservationManager.creditReservation(purchaseContextType, publicIdentifier, reservationId, refund, notify, principal.getName());
        return Result.success((Object)true);
    }

    @PutMapping(value={"/{purchaseContextType}/{publicIdentifier}/{reservationId}/regenerate-billing-document"})
    public Result<Boolean> regenerateBillingDocument(@PathVariable PurchaseContext.PurchaseContextType purchaseContextType, @PathVariable String publicIdentifier, @PathVariable String reservationId, Principal principal) {
        this.accessService.checkReservationOwnership(principal, purchaseContextType, publicIdentifier, reservationId);
        return this.adminReservationManager.regenerateBillingDocument(purchaseContextType, publicIdentifier, reservationId, principal.getName());
    }

    @PostMapping(value={"/{purchaseContextType}/{publicIdentifier}/{reservationId}/refund"})
    public Result<Boolean> refund(@PathVariable PurchaseContext.PurchaseContextType purchaseContextType, @PathVariable String publicIdentifier, @PathVariable String reservationId, @RequestBody RefundAmount amount, Principal principal) {
        this.accessService.checkReservationOwnership(principal, purchaseContextType, publicIdentifier, reservationId);
        return this.adminReservationManager.refund(purchaseContextType, publicIdentifier, reservationId, new BigDecimal(amount.amount), principal.getName());
    }

    @GetMapping(value={"/{purchaseContextType}/{publicIdentifier}/{reservationId}/email-list"})
    public Result<List<LightweightMailMessage>> getEmailList(@PathVariable PurchaseContext.PurchaseContextType purchaseContextType, @PathVariable String publicIdentifier, @PathVariable String reservationId, Principal principal) {
        this.accessService.checkReservationOwnership(principal, purchaseContextType, publicIdentifier, reservationId);
        return this.adminReservationManager.getEmailsForReservation(purchaseContextType, publicIdentifier, reservationId, principal.getName());
    }

    @GetMapping(value={"/{purchaseContextType}/{publicIdentifier}/{reservationId}/ticket/{ticketId}/full-data"})
    public ResponseEntity<BookingInfoTicket> loadFullTicketData(@PathVariable PurchaseContext.PurchaseContextType purchaseContextType, @PathVariable String publicIdentifier, @PathVariable String reservationId, @PathVariable(value="ticketId") String ticketUUID, Principal principal) {
        if (purchaseContextType != PurchaseContext.PurchaseContextType.event) {
            return ResponseEntity.notFound().build();
        }
        this.accessService.checkReservationOwnership(principal, purchaseContextType, publicIdentifier, reservationId);
        return ResponseEntity.of(this.adminReservationManager.loadFullTicketInfo(reservationId, publicIdentifier, ticketUUID).map(eventAndTicket -> this.bookingInfoTicketLoader.toBookingInfoTicket((Ticket)eventAndTicket.getRight(), (Event)eventAndTicket.getLeft(), PurchaseContextFieldConfiguration.EVENT_RELATED_CONTEXTS)));
    }

    private TicketReservationDescriptor toReservationDescriptor(String reservationId, Triple<TicketReservation, List<Ticket>, PurchaseContext> triple) {
        List tickets = ((List)triple.getMiddle()).stream().collect(Collectors.groupingBy(Ticket::getCategoryId)).entrySet().stream().map(entry -> SerializablePair.of((Object)this.eventManager.getTicketCategoryById(((Integer)entry.getKey()).intValue(), ((Event)((PurchaseContext)triple.getRight()).event().orElseThrow()).getId()), (Object)((List)entry.getValue()))).collect(Collectors.toList());
        TicketReservation reservation = (TicketReservation)triple.getLeft();
        return new TicketReservationDescriptor(reservation, this.ticketReservationManager.loadAdditionalInfo(reservationId), this.ticketReservationManager.orderSummaryForReservationId(reservationId, (PurchaseContext)triple.getRight()), tickets, this.buildSubscriptionDetails((PurchaseContext)triple.getRight(), reservation));
    }

    private SubscriptionWithUsageDetails buildSubscriptionDetails(PurchaseContext purchaseContext, TicketReservation reservation) {
        if (purchaseContext.ofType(PurchaseContext.PurchaseContextType.subscription)) {
            return this.ticketReservationManager.findSubscriptionDetails(reservation.getId()).orElse(null);
        }
        return null;
    }

    @ConstructorProperties(value={"adminReservationManager", "eventManager", "purchaseContextManager", "purchaseContextSearchManager", "ticketReservationManager", "bookingInfoTicketLoader", "accessService"})
    @Generated
    public AdminReservationApiController(AdminReservationManager adminReservationManager, EventManager eventManager, PurchaseContextManager purchaseContextManager, PurchaseContextSearchManager purchaseContextSearchManager, TicketReservationManager ticketReservationManager, BookingInfoTicketLoader bookingInfoTicketLoader, AccessService accessService) {
        this.adminReservationManager = adminReservationManager;
        this.eventManager = eventManager;
        this.purchaseContextManager = purchaseContextManager;
        this.purchaseContextSearchManager = purchaseContextSearchManager;
        this.ticketReservationManager = ticketReservationManager;
        this.bookingInfoTicketLoader = bookingInfoTicketLoader;
        this.accessService = accessService;
    }
}

