/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.admin;

import alfio.controller.api.admin.AdminWaitingQueueApiController;
import alfio.controller.decorator.SaleableTicketCategory;
import alfio.manager.AccessService;
import alfio.manager.EventManager;
import alfio.manager.EventStatisticsManager;
import alfio.manager.TicketReservationManager;
import alfio.manager.WaitingQueueManager;
import alfio.manager.system.ConfigurationManager;
import alfio.model.CategoryAvailability;
import alfio.model.Event;
import alfio.model.EventAndOrganizationId;
import alfio.model.WaitingQueueSubscription;
import alfio.model.modification.ConfigurationModification;
import alfio.model.system.ConfigurationKeys;
import alfio.util.ClockProvider;
import alfio.util.EventUtil;
import alfio.util.ExportUtils;
import jakarta.servlet.http.HttpServletResponse;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.security.Principal;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/admin/api/event/{eventName}/waiting-queue"})
public class AdminWaitingQueueApiController {
    private final WaitingQueueManager waitingQueueManager;
    private final EventManager eventManager;
    private final TicketReservationManager ticketReservationManager;
    private final ConfigurationManager configurationManager;
    private final EventStatisticsManager eventStatisticsManager;
    private final ClockProvider clockProvider;
    private final AccessService accessService;

    @GetMapping(value={"/status"})
    public Map<String, Boolean> getStatusForEvent(@PathVariable String eventName, Principal principal) {
        this.accessService.checkEventMembership(principal, eventName, AccessService.MEMBERSHIP_ROLES);
        return this.eventManager.getOptionalByName(eventName, principal.getName()).map(arg_0 -> this.loadStatus(arg_0)).orElse(Collections.emptyMap());
    }

    private Map<String, Boolean> loadStatus(Event event) {
        ZonedDateTime now = ZonedDateTime.now(this.clockProvider.getClock().withZone(event.getZoneId()));
        List<SaleableTicketCategory> stcList = this.eventManager.loadTicketCategories((EventAndOrganizationId)event).stream().filter(tc -> !tc.isAccessRestricted()).map(tc -> {
            CategoryAvailability categoryAvailability = this.ticketReservationManager.countAvailableTickets((EventAndOrganizationId)event, tc);
            return new SaleableTicketCategory(tc, now, event, categoryAvailability, tc.getMaxTickets(), null);
        }).toList();
        boolean active = EventUtil.checkWaitingQueuePreconditions((Event)event, stcList, (ConfigurationManager)this.configurationManager, (Predicate)this.eventStatisticsManager.noSeatsAvailable());
        boolean paused = active && this.configurationManager.getFor(ConfigurationKeys.STOP_WAITING_QUEUE_SUBSCRIPTIONS, event.getConfigurationLevel()).getValueAsBooleanOrDefault();
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("active", active);
        result.put("paused", paused);
        return result;
    }

    @PutMapping(value={"/status"})
    public Map<String, Boolean> setStatusForEvent(@PathVariable String eventName, @RequestBody SetStatusForm form, Principal principal) {
        this.accessService.checkEventOwnership(principal, eventName);
        return this.eventManager.getOptionalByName(eventName, principal.getName()).map(event -> {
            this.configurationManager.saveAllEventConfiguration(event.getId(), event.getOrganizationId(), Collections.singletonList(new ConfigurationModification(null, ConfigurationKeys.STOP_WAITING_QUEUE_SUBSCRIPTIONS.name(), String.valueOf(form.status))), principal.getName());
            return this.loadStatus(event);
        }).orElse(Collections.emptyMap());
    }

    @GetMapping(value={"/count"})
    public Integer countWaitingPeople(@PathVariable String eventName, Principal principal, HttpServletResponse response) {
        this.accessService.checkEventMembership(principal, eventName, AccessService.MEMBERSHIP_ROLES);
        Optional<Integer> count = this.eventManager.getOptionalEventAndOrganizationIdByName(eventName, principal.getName()).map(e -> this.waitingQueueManager.countSubscribers(e.getId()));
        if (count.isPresent()) {
            return count.get();
        }
        response.setStatus(404);
        return 0;
    }

    @GetMapping(value={"/load"})
    public List<WaitingQueueSubscription> loadAllSubscriptions(@PathVariable String eventName, Principal principal, HttpServletResponse response) {
        this.accessService.checkEventOwnership(principal, eventName);
        Optional<List> count = this.eventManager.getOptionalEventAndOrganizationIdByName(eventName, principal.getName()).map(e -> this.waitingQueueManager.loadAllSubscriptionsForEvent(e.getId()));
        if (count.isPresent()) {
            return count.get();
        }
        response.setStatus(404);
        return Collections.emptyList();
    }

    @GetMapping(value={"/download"})
    public void downloadAllSubscriptions(@PathVariable String eventName, @RequestParam(name="format", defaultValue="excel") String format, Principal principal, HttpServletResponse response) throws IOException {
        this.accessService.checkEventOwnership(principal, eventName);
        Event event = this.eventManager.getSingleEvent(eventName, principal.getName());
        List found = this.waitingQueueManager.loadAllSubscriptionsForEvent(event.getId());
        String[] header = new String[]{"Type", "Firstname", "Lastname", "Email", "Language", "Status", "Date"};
        Stream lines = AdminWaitingQueueApiController.convertSubscriptions((List)found, (Event)event);
        if ("excel".equals(format)) {
            ExportUtils.exportExcel((String)(event.getShortName() + "-waiting-queue.xlsx"), (String)"waiting-queue", (String[])header, (Stream)lines, (HttpServletResponse)response);
        } else {
            ExportUtils.exportCsv((String)(event.getShortName() + "-waiting-queue.csv"), (String[])header, (Stream)lines, (HttpServletResponse)response);
        }
    }

    private static Stream<String[]> convertSubscriptions(List<WaitingQueueSubscription> l, Event event) {
        return l.stream().map(s -> new String[]{s.getSubscriptionType().toString(), s.getFirstName(), s.getLastName(), s.getEmailAddress(), s.getLocale().toLanguageTag(), s.getStatus().name(), s.getCreation().withZoneSameInstant(event.getZoneId()).toString()});
    }

    @DeleteMapping(value={"/subscriber/{subscriberId}"})
    public ResponseEntity<Map<String, Object>> removeSubscriber(@PathVariable String eventName, @PathVariable int subscriberId, Principal principal) {
        return this.performStatusModification(eventName, subscriberId, principal, WaitingQueueSubscription.Status.CANCELLED, WaitingQueueSubscription.Status.WAITING);
    }

    @PutMapping(value={"/subscriber/{subscriberId}/restore"})
    public ResponseEntity<Map<String, Object>> restoreSubscriber(@PathVariable String eventName, @PathVariable int subscriberId, Principal principal) {
        return this.performStatusModification(eventName, subscriberId, principal, WaitingQueueSubscription.Status.WAITING, WaitingQueueSubscription.Status.CANCELLED);
    }

    private ResponseEntity<Map<String, Object>> performStatusModification(String eventName, int subscriberId, Principal principal, WaitingQueueSubscription.Status newStatus, WaitingQueueSubscription.Status currentStatus) {
        EventAndOrganizationId eventAndOrgId = this.accessService.checkWaitingQueueSubscriberInEvent(principal, subscriberId, eventName);
        return this.waitingQueueManager.updateSubscriptionStatus(subscriberId, newStatus, currentStatus).map(result -> {
            HashMap<String, Object> out = new HashMap<String, Object>();
            out.put("modified", result);
            out.put("list", this.waitingQueueManager.loadAllSubscriptionsForEvent(eventAndOrgId.getId()));
            return out;
        }).map(ResponseEntity::ok).orElseGet(() -> new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST));
    }

    @ConstructorProperties(value={"waitingQueueManager", "eventManager", "ticketReservationManager", "configurationManager", "eventStatisticsManager", "clockProvider", "accessService"})
    @Generated
    public AdminWaitingQueueApiController(WaitingQueueManager waitingQueueManager, EventManager eventManager, TicketReservationManager ticketReservationManager, ConfigurationManager configurationManager, EventStatisticsManager eventStatisticsManager, ClockProvider clockProvider, AccessService accessService) {
        this.waitingQueueManager = waitingQueueManager;
        this.eventManager = eventManager;
        this.ticketReservationManager = ticketReservationManager;
        this.configurationManager = configurationManager;
        this.eventStatisticsManager = eventStatisticsManager;
        this.clockProvider = clockProvider;
        this.accessService = accessService;
    }
}

