/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.admin;

import alfio.manager.AccessService;
import alfio.manager.AdminReservationRequestManager;
import alfio.model.AdminReservationRequestStats;
import alfio.model.modification.AdminReservationModification;
import alfio.model.result.Result;
import java.beans.ConstructorProperties;
import java.security.Principal;
import lombok.Generated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/admin/api/event/{eventName}/attendees/import"})
@RestController
public class AttendeeBulkImportApiController {
    private final AdminReservationRequestManager requestManager;
    private final AccessService accessService;

    @PostMapping(value={""})
    public Result<String> createReservations(@PathVariable String eventName, @RequestBody AdminReservationModification body, @RequestParam(name="oneReservationPerAttendee", defaultValue="false", required=false) boolean oneReservationPerAttendee, Principal principal) {
        this.accessService.checkEventOwnership(principal, eventName);
        return this.requestManager.scheduleReservations(eventName, body, !oneReservationPerAttendee, principal.getName());
    }

    @GetMapping(value={"/{requestId}/status"})
    public Result<AdminReservationRequestStats> getRequestsStatus(@PathVariable String eventName, @PathVariable String requestId, Principal principal) {
        this.accessService.checkEventOwnership(principal, eventName);
        return this.requestManager.getRequestStatus(requestId, eventName, principal.getName());
    }

    @ConstructorProperties(value={"requestManager", "accessService"})
    @Generated
    public AttendeeBulkImportApiController(AdminReservationRequestManager requestManager, AccessService accessService) {
        this.requestManager = requestManager;
        this.accessService = accessService;
    }
}

