/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.admin;

import alfio.controller.api.admin.CheckInApiController;
import alfio.manager.AccessService;
import alfio.manager.CheckInManager;
import alfio.manager.EventManager;
import alfio.manager.support.AccessDeniedException;
import alfio.manager.support.CheckInResult;
import alfio.manager.support.CheckInStatistics;
import alfio.manager.support.CheckInStatus;
import alfio.manager.support.DefaultCheckInResult;
import alfio.manager.support.TicketAndCheckInResult;
import alfio.manager.support.TicketCheckInStatusResult;
import alfio.manager.system.ConfigurationManager;
import alfio.model.EventAndOrganizationId;
import alfio.model.FullTicketInfo;
import alfio.model.checkin.AttendeeSearchResults;
import alfio.model.system.ConfigurationKeys;
import alfio.util.Json;
import alfio.util.MiscUtils;
import alfio.util.Wrappers;
import jakarta.servlet.http.HttpServletResponse;
import java.beans.ConstructorProperties;
import java.security.Principal;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/admin/api"})
public class CheckInApiController {
    private static final Logger log = LoggerFactory.getLogger(CheckInApiController.class);
    private static final String ALFIO_TIMESTAMP_HEADER = "Alfio-TIME";
    private final CheckInManager checkInManager;
    private final EventManager eventManager;
    private final ConfigurationManager configurationManager;
    private final AccessService accessService;

    @GetMapping(value={"/check-in/{eventId}/ticket/{ticketIdentifier}"})
    public TicketAndCheckInResult findTicketWithUUID(@PathVariable int eventId, @PathVariable String ticketIdentifier, @RequestParam(value="qrCode") String qrCode, Principal principal) {
        this.accessService.checkEventTicketIdentifierMembership(principal, eventId, ticketIdentifier, AccessService.CHECKIN_ROLES);
        return this.checkInManager.evaluateTicketStatus(eventId, ticketIdentifier, Optional.ofNullable(qrCode));
    }

    @GetMapping(value={"/check-in/event/{eventName}/ticket/{ticketIdentifier}"})
    public TicketAndCheckInResult findTicketWithUUID(@PathVariable String eventName, @PathVariable String ticketIdentifier, @RequestParam(value="qrCode") String qrCode, Principal principal) {
        this.accessService.checkEventTicketIdentifierMembership(principal, eventName, ticketIdentifier, AccessService.CHECKIN_ROLES);
        return this.checkInManager.evaluateTicketStatus(eventName, ticketIdentifier, Optional.ofNullable(qrCode));
    }

    @GetMapping(value={"/check-in/event/{eventName}/ticket/{ticketIdentifier}/status"})
    public TicketCheckInStatusResult getTicketStatus(@PathVariable String eventName, @PathVariable String ticketIdentifier, Principal principal) {
        this.accessService.checkEventTicketIdentifierMembership(principal, eventName, ticketIdentifier, AccessService.CHECKIN_ROLES);
        return this.checkInManager.retrieveTicketStatus(ticketIdentifier);
    }

    @PostMapping(value={"/check-in/{eventId}/ticket/{ticketIdentifier}"})
    public TicketAndCheckInResult checkIn(@PathVariable int eventId, @PathVariable String ticketIdentifier, @RequestBody TicketCode ticketCode, Principal principal) {
        this.accessService.checkEventTicketIdentifierMembership(principal, eventId, ticketIdentifier, AccessService.CHECKIN_ROLES);
        return this.checkInManager.checkIn(eventId, ticketIdentifier, Optional.ofNullable(ticketCode).map(TicketCode::getCode), principal.getName());
    }

    @PostMapping(value={"/check-in/event/{eventName}/ticket/{ticketIdentifier}"})
    public TicketAndCheckInResult checkIn(@PathVariable String eventName, @PathVariable String ticketIdentifier, @RequestBody TicketCode ticketCode, @RequestParam(value="offlineUser", required=false) String offlineUser, Principal principal) {
        try {
            this.accessService.checkEventTicketIdentifierMembership(principal, eventName, ticketIdentifier, AccessService.CHECKIN_ROLES);
            String username = principal.getName();
            String auditUser = (String)StringUtils.defaultIfBlank((CharSequence)offlineUser, (CharSequence)username);
            return this.checkInManager.checkIn(eventName, ticketIdentifier, Optional.ofNullable(ticketCode).map(TicketCode::getCode), username, auditUser);
        }
        catch (AccessDeniedException e) {
            return new TicketAndCheckInResult(null, (CheckInResult)new DefaultCheckInResult(CheckInStatus.TICKET_NOT_FOUND, "ticket not found"));
        }
    }

    @PostMapping(value={"/check-in/event/{eventName}/bulk"})
    public Map<String, TicketAndCheckInResult> bulkCheckIn(@PathVariable String eventName, @RequestBody List<TicketIdentifierCode> ticketIdentifierCodes, @RequestParam(value="offlineUser", required=false) String offlineUser, @RequestParam(value="forceCheckInPaymentOnSite", required=false, defaultValue="false") boolean forceCheckInPaymentOnSite, Principal principal) {
        this.accessService.checkEventMembership(principal, eventName, AccessService.CHECKIN_ROLES);
        String username = principal.getName();
        String auditUser = (String)StringUtils.defaultIfBlank((CharSequence)offlineUser, (CharSequence)username);
        return ticketIdentifierCodes.stream().distinct().map(t -> {
            TicketAndCheckInResult res = this.checkInManager.checkIn(eventName, t.getIdentifier(), Optional.ofNullable(t.getCode()), username, auditUser, forceCheckInPaymentOnSite);
            return Pair.of((Object)t.identifier, (Object)res);
        }).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    }

    @PostMapping(value={"/check-in/{eventId}/ticket/{ticketIdentifier}/manual-check-in"})
    public boolean manualCheckIn(@PathVariable int eventId, @PathVariable String ticketIdentifier, Principal principal) {
        this.accessService.checkEventTicketIdentifierMembership(principal, eventId, ticketIdentifier, AccessService.CHECKIN_ROLES);
        log.warn("for event id : {} and ticket : {}, a manual check in has been done by {}", new Object[]{eventId, ticketIdentifier, principal.getName()});
        return this.checkInManager.manualCheckIn(eventId, ticketIdentifier, principal.getName());
    }

    @PostMapping(value={"/check-in/event/{eventName}/ticket/{ticketIdentifier}/manual-check-in"})
    public ResponseEntity<Boolean> manualCheckIn(@PathVariable String eventName, @PathVariable String ticketIdentifier, Principal principal) {
        this.accessService.checkEventTicketIdentifierMembership(principal, eventName, ticketIdentifier, AccessService.CHECKIN_ROLES);
        return ResponseEntity.of(this.eventManager.getOptionalEventAndOrganizationIdByName(eventName, principal.getName()).map(ev -> this.manualCheckIn(ev.getId(), ticketIdentifier, principal)));
    }

    @PostMapping(value={"/check-in/{eventId}/ticket/{ticketIdentifier}/revert-check-in"})
    public boolean revertCheckIn(@PathVariable int eventId, @PathVariable String ticketIdentifier, Principal principal) {
        this.accessService.checkEventTicketIdentifierMembership(principal, eventId, ticketIdentifier, AccessService.CHECKIN_ROLES);
        log.warn("for event id : {} and ticket : {}, a revert of the check in has been done by {}", new Object[]{eventId, MiscUtils.removeTabsAndNewlines((String)ticketIdentifier), principal.getName()});
        return this.checkInManager.revertCheckIn(eventId, ticketIdentifier, principal.getName());
    }

    @PostMapping(value={"/check-in/event/{eventName}/ticket/{ticketIdentifier}/revert-check-in"})
    public ResponseEntity<Boolean> revertCheckIn(@PathVariable String eventName, @PathVariable String ticketIdentifier, Principal principal) {
        EventAndOrganizationId eventAndOrgId = this.accessService.checkEventTicketIdentifierMembership(principal, eventName, ticketIdentifier, AccessService.CHECKIN_ROLES);
        return ResponseEntity.ok((Object)this.revertCheckIn(eventAndOrgId.getId(), ticketIdentifier, principal));
    }

    @PostMapping(value={"/check-in/event/{eventName}/ticket/{ticketIdentifier}/confirm-on-site-payment"})
    public TicketAndCheckInResult confirmOnSitePayment(@PathVariable String eventName, @PathVariable String ticketIdentifier, @RequestBody TicketCode ticketCode, @RequestParam(value="offlineUser", required=false) String offlineUser, Principal principal) {
        this.accessService.checkEventTicketIdentifierMembership(principal, eventName, ticketIdentifier, AccessService.CHECKIN_ROLES);
        String username = principal.getName();
        String auditUser = (String)StringUtils.defaultIfBlank((CharSequence)offlineUser, (CharSequence)username);
        return this.checkInManager.confirmOnSitePayment(eventName, ticketIdentifier, Optional.ofNullable(ticketCode).map(TicketCode::getCode), username, auditUser);
    }

    @GetMapping(value={"/check-in/event/{eventName}/statistics"})
    public CheckInStatistics getStatistics(@PathVariable String eventName, Principal principal) {
        this.accessService.checkEventMembership(principal, eventName, AccessService.CHECKIN_ROLES);
        return this.checkInManager.getStatistics(eventName, principal.getName());
    }

    @PostMapping(value={"/check-in/{eventId}/ticket/{ticketIdentifier}/confirm-on-site-payment"})
    public OnSitePaymentConfirmation confirmOnSitePayment(@PathVariable int eventId, @PathVariable String ticketIdentifier, Principal principal) {
        this.accessService.checkEventTicketIdentifierMembership(principal, eventId, ticketIdentifier, AccessService.CHECKIN_ROLES);
        return this.checkInManager.confirmOnSitePayment(ticketIdentifier).map(s -> new OnSitePaymentConfirmation(true, "ok")).orElseGet(() -> new OnSitePaymentConfirmation(false, "Ticket with uuid " + ticketIdentifier + " not found"));
    }

    @GetMapping(value={"/check-in/{eventId}/ticket-identifiers"})
    public List<Integer> findAllIdentifiersForAdminCheckIn(@PathVariable int eventId, @RequestParam(value="changedSince", required=false) Long changedSince, HttpServletResponse response, Principal principal) {
        this.accessService.checkEventMembership(principal, eventId, AccessService.CHECKIN_ROLES);
        response.setHeader("Alfio-TIME", Long.toString(new Date().getTime()));
        return this.checkInManager.getAttendeesIdentifiers(eventId, changedSince == null ? new Date(0L) : new Date(changedSince), principal.getName());
    }

    @GetMapping(value={"/check-in/event/{publicIdentifier}/attendees"})
    public ResponseEntity<AttendeeSearchResults> searchAttendees(@PathVariable String publicIdentifier, @RequestParam(value="query", required=false) String query, @RequestParam(value="page", required=false, defaultValue="0") int page, Principal principal) {
        this.accessService.checkEventMembership(principal, publicIdentifier, AccessService.MEMBERSHIP_ROLES);
        if (StringUtils.isBlank((CharSequence)query) || StringUtils.isBlank((CharSequence)publicIdentifier)) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NO_CONTENT).build();
        }
        return ResponseEntity.of(this.eventManager.getOptionalByName(publicIdentifier, principal.getName()).map(event -> this.checkInManager.searchAttendees(event, query, page, principal)));
    }

    @PostMapping(value={"/check-in/{eventId}/tickets"})
    public List<FullTicketInfo> findAllTicketsForAdminCheckIn(@PathVariable int eventId, @RequestBody List<Integer> ids, Principal principal) {
        this.accessService.checkEventMembership(principal, eventId, AccessService.CHECKIN_ROLES);
        CheckInApiController.validateIdList(ids);
        return this.checkInManager.getAttendeesInformation(eventId, ids, principal.getName());
    }

    @GetMapping(value={"/check-in/{eventName}/label-layout"})
    public ResponseEntity<LabelLayout> getLabelLayoutForEvent(@PathVariable String eventName, Principal principal) {
        EventAndOrganizationId event = this.accessService.canAccessEvent(principal, eventName);
        if (this.checkInManager.isOfflineCheckInEnabled().test(event)) {
            return this.parseLabelLayout(event);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.PRECONDITION_FAILED);
    }

    @GetMapping(value={"/check-in/{eventName}/offline-identifiers"})
    public List<Integer> getOfflineIdentifiers(@PathVariable String eventName, @RequestParam(value="changedSince", required=false) Long changedSince, HttpServletResponse resp, Principal principal) {
        EventAndOrganizationId event = this.accessService.checkEventMembership(principal, eventName, AccessService.CHECKIN_ROLES);
        Date since = changedSince == null ? new Date(0L) : DateUtils.addSeconds((Date)new Date(changedSince), (int)-1);
        boolean offlineEnabled = this.checkInManager.isOfflineCheckInEnabled().test(event);
        List ids = offlineEnabled ? this.checkInManager.getAttendeesIdentifiers(event, since, principal.getName()) : List.of();
        resp.setHeader("Alfio-TIME", offlineEnabled ? Long.toString(new Date().getTime()) : "0");
        return ids;
    }

    @PostMapping(value={"/check-in/{eventName}/offline"})
    public Map<String, String> getOfflineEncryptedInfo(@PathVariable String eventName, @RequestParam(value="additionalField", required=false) List<String> additionalFields, @RequestBody List<Integer> ids, Principal principal) {
        this.accessService.checkEventMembership(principal, eventName, AccessService.CHECKIN_ROLES);
        CheckInApiController.validateIdList(ids);
        return this.eventManager.getOptionalByName(eventName, principal.getName()).map(event -> {
            Set addFields = this.loadLabelLayout((EventAndOrganizationId)event).map(layout -> {
                HashSet union = new HashSet(layout.content.thirdRow);
                union.addAll(layout.content.additionalRows);
                union.addAll(layout.qrCode.additionalInfo);
                if (additionalFields != null && !additionalFields.isEmpty()) {
                    union.addAll(additionalFields);
                }
                return union;
            }).orElseGet(() -> {
                if (additionalFields != null && !additionalFields.isEmpty()) {
                    return new HashSet(additionalFields);
                }
                return Collections.singleton("company");
            });
            return this.checkInManager.getEncryptedAttendeesInformation(event, addFields, ids);
        }).orElse(Collections.emptyMap());
    }

    private static void validateIdList(@RequestBody List<Integer> ids) {
        Validate.isTrue((ids != null && !ids.isEmpty() ? 1 : 0) != 0);
        Validate.isTrue((ids.size() <= 200 ? 1 : 0) != 0, (String)"Cannot ask more than 200 ids", (Object[])new Object[0]);
    }

    private ResponseEntity<LabelLayout> parseLabelLayout(EventAndOrganizationId event) {
        return this.loadLabelLayout(event).map(ResponseEntity::ok).orElseGet(() -> new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT));
    }

    private Optional<LabelLayout> loadLabelLayout(EventAndOrganizationId event) {
        return this.configurationManager.getFor(ConfigurationKeys.LABEL_LAYOUT, event.getConfigurationLevel()).getValue().flatMap(str -> Wrappers.optionally(() -> (LabelLayout)Json.fromJson((String)str, LabelLayout.class)));
    }

    @ConstructorProperties(value={"checkInManager", "eventManager", "configurationManager", "accessService"})
    @Generated
    public CheckInApiController(CheckInManager checkInManager, EventManager eventManager, ConfigurationManager configurationManager, AccessService accessService) {
        this.checkInManager = checkInManager;
        this.eventManager = eventManager;
        this.configurationManager = configurationManager;
        this.accessService = accessService;
    }
}

