/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.admin;

import alfio.controller.api.admin.ConfigurationApiController;
import alfio.controller.api.support.TicketHelper;
import alfio.manager.AccessService;
import alfio.manager.BillingDocumentManager;
import alfio.manager.EventManager;
import alfio.manager.system.AdminJobExecutor;
import alfio.manager.system.AdminJobManager;
import alfio.manager.system.ConfigurationLevel;
import alfio.manager.system.ConfigurationManager;
import alfio.manager.user.UserManager;
import alfio.model.Event;
import alfio.model.EventAndOrganizationId;
import alfio.model.modification.ConfigurationModification;
import alfio.model.system.Configuration;
import alfio.model.system.ConfigurationKeys;
import alfio.util.ClockProvider;
import alfio.util.Json;
import alfio.util.RequestUtils;
import alfio.util.Wrappers;
import com.fasterxml.jackson.core.type.TypeReference;
import java.beans.ConstructorProperties;
import java.security.Principal;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/api/configuration"})
public class ConfigurationApiController {
    private final ConfigurationManager configurationManager;
    private final BillingDocumentManager billingDocumentManager;
    private final AdminJobManager adminJobManager;
    private final EventManager eventManager;
    private final ClockProvider clockProvider;
    private final UserManager userManager;
    private final AccessService accessService;

    @GetMapping(value={"/load"})
    public Map<ConfigurationKeys.SettingCategory, List<Configuration>> loadConfiguration(Principal principal) {
        this.accessService.ensureAdmin(principal);
        return this.configurationManager.loadAllSystemConfigurationIncludingMissing(principal.getName());
    }

    @GetMapping(value={"/basic-configuration-needed"})
    public boolean isBasicConfigurationNeeded() {
        return this.configurationManager.isBasicConfigurationNeeded();
    }

    @PostMapping(value={"/update"})
    public boolean updateConfiguration(@RequestBody ConfigurationModification configuration, Principal principal) {
        this.accessService.ensureAdmin(principal);
        this.configurationManager.saveSystemConfiguration(ConfigurationKeys.fromString((String)configuration.getKey()), configuration.getValue());
        return true;
    }

    @PostMapping(value={"/update-bulk"})
    public boolean updateConfiguration(@RequestBody Map<ConfigurationKeys.SettingCategory, List<ConfigurationModification>> input, Principal principal) {
        this.accessService.ensureAdmin(principal);
        List list = Objects.requireNonNull(input).values().stream().flatMap(Collection::stream).toList();
        this.configurationManager.saveAllSystemConfiguration(list);
        return true;
    }

    @GetMapping(value={"/organizations/{organizationId}/load"})
    public Map<ConfigurationKeys.SettingCategory, List<Configuration>> loadOrganizationConfiguration(@PathVariable int organizationId, Principal principal) {
        this.accessService.checkOrganizationOwnership(principal, Integer.valueOf(organizationId));
        return this.configurationManager.loadOrganizationConfig(organizationId, principal.getName());
    }

    @PostMapping(value={"/organizations/{organizationId}/update"})
    public boolean updateOrganizationConfiguration(@PathVariable int organizationId, @RequestBody Map<ConfigurationKeys.SettingCategory, List<ConfigurationModification>> input, Principal principal) {
        this.accessService.checkOrganizationOwnership(principal, Integer.valueOf(organizationId));
        this.configurationManager.saveAllOrganizationConfiguration(organizationId, input.values().stream().flatMap(Collection::stream).toList(), principal.getName());
        return true;
    }

    @GetMapping(value={"/events/{eventId}/load"})
    public Map<ConfigurationKeys.SettingCategory, List<Configuration>> loadEventConfiguration(@PathVariable int eventId, Principal principal) {
        this.accessService.checkEventOwnership(principal, eventId);
        return this.configurationManager.loadEventConfig(eventId, principal.getName());
    }

    @GetMapping(value={"/events/{eventName}/single/{key}"})
    public ResponseEntity<String> getSingleConfigForEvent(@PathVariable(value="eventName") String eventShortName, @PathVariable String key, Principal principal) {
        this.accessService.checkEventOwnership(principal, eventShortName);
        Optional optionalEvent = this.eventManager.getOptionalByName(eventShortName, principal.getName());
        if (optionalEvent.isEmpty()) {
            return ResponseEntity.notFound().build();
        }
        Event event = (Event)optionalEvent.get();
        String singleConfigForEvent = this.configurationManager.getSingleConfigForEvent(event.getId(), key, principal.getName());
        if (singleConfigForEvent == null) {
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.ok((Object)singleConfigForEvent);
    }

    @GetMapping(value={"/organizations/{organizationId}/single/{key}"})
    public ResponseEntity<String> getSingleConfigForOrganization(@PathVariable int organizationId, @PathVariable String key, Principal principal) {
        this.accessService.checkOrganizationOwnership(principal, Integer.valueOf(organizationId));
        String config = this.configurationManager.getSingleConfigForOrganization(organizationId, key, principal.getName());
        if (config == null) {
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.ok((Object)config);
    }

    @PostMapping(value={"/organizations/{organizationId}/events/{eventId}/update"})
    public boolean updateEventConfiguration(@PathVariable int organizationId, @PathVariable int eventId, @RequestBody Map<ConfigurationKeys.SettingCategory, List<ConfigurationModification>> input, Principal principal) {
        this.accessService.checkEventOwnership(principal, eventId, organizationId);
        this.configurationManager.saveAllEventConfiguration(eventId, organizationId, input.values().stream().flatMap(Collection::stream).toList(), principal.getName());
        return true;
    }

    @PostMapping(value={"/events/{eventId}/categories/{categoryId}/update"})
    public boolean updateCategoryConfiguration(@PathVariable int categoryId, @PathVariable int eventId, @RequestBody Map<ConfigurationKeys.SettingCategory, List<ConfigurationModification>> input, Principal principal) {
        this.accessService.checkCategoryOwnership(principal, eventId, categoryId);
        this.configurationManager.saveCategoryConfiguration(categoryId, eventId, input.values().stream().flatMap(Collection::stream).toList(), principal.getName());
        return true;
    }

    @GetMapping(value={"/events/{eventId}/categories/{categoryId}/load"})
    public Map<ConfigurationKeys.SettingCategory, List<Configuration>> loadCategoryConfiguration(@PathVariable int eventId, @PathVariable int categoryId, Principal principal) {
        this.accessService.checkCategoryOwnership(principal, eventId, categoryId);
        return this.configurationManager.loadCategoryConfig(eventId, categoryId, principal.getName());
    }

    @DeleteMapping(value={"/organization/{organizationId}/key/{key}"})
    public boolean deleteOrganizationLevelKey(@PathVariable int organizationId, @PathVariable ConfigurationKeys key, Principal principal) {
        this.accessService.checkOrganizationOwnership(principal, Integer.valueOf(organizationId));
        this.configurationManager.deleteOrganizationLevelByKey(key.getValue(), organizationId, principal.getName());
        return true;
    }

    @DeleteMapping(value={"/event/{eventId}/key/{key}"})
    public boolean deleteEventLevelKey(@PathVariable int eventId, @PathVariable ConfigurationKeys key, Principal principal) {
        this.accessService.checkEventOwnership(principal, eventId);
        this.configurationManager.deleteEventLevelByKey(key.getValue(), eventId, principal.getName());
        return true;
    }

    @DeleteMapping(value={"/event/{eventId}/category/{categoryId}/key/{key}"})
    public boolean deleteCategoryLevelKey(@PathVariable int eventId, @PathVariable int categoryId, @PathVariable ConfigurationKeys key, Principal principal) {
        this.accessService.checkCategoryOwnership(principal, eventId, categoryId);
        this.configurationManager.deleteCategoryLevelByKey(key.getValue(), eventId, categoryId, principal.getName());
        return true;
    }

    @DeleteMapping(value={"/key/{key}"})
    public boolean deleteKey(@PathVariable String key, Principal principal) {
        this.accessService.ensureAdmin(principal);
        this.configurationManager.deleteKey(key);
        return true;
    }

    @GetMapping(value={"/eu-countries"})
    public List<Pair<String, String>> loadEUCountries() {
        return TicketHelper.getLocalizedEUCountriesForVat((Locale)Locale.ENGLISH, (String)this.configurationManager.getForSystem(ConfigurationKeys.EU_COUNTRIES_LIST).getRequiredValue());
    }

    @GetMapping(value={"/instance-settings"})
    public InstanceSettings loadInstanceSettings() {
        Map settings = this.configurationManager.getFor(EnumSet.of(ConfigurationKeys.DESCRIPTION_MAXLENGTH, ConfigurationKeys.BASE_URL), ConfigurationLevel.system());
        return new InstanceSettings(((ConfigurationManager.MaybeConfiguration)settings.get(ConfigurationKeys.DESCRIPTION_MAXLENGTH)).getValueAsIntOrDefault(4096), ((ConfigurationManager.MaybeConfiguration)settings.get(ConfigurationKeys.BASE_URL)).getRequiredValue());
    }

    @GetMapping(value={"/platform-mode/status/{organizationId}"})
    public Map<String, Boolean> loadPlatformModeStatus(@PathVariable int organizationId, Principal principal) {
        this.accessService.checkOrganizationOwnership(principal, Integer.valueOf(organizationId));
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        boolean platformModeEnabled = this.configurationManager.getForSystem(ConfigurationKeys.PLATFORM_MODE_ENABLED).getValueAsBooleanOrDefault();
        result.put("enabled", platformModeEnabled);
        if (platformModeEnabled) {
            Map options = this.configurationManager.getFor(List.of(ConfigurationKeys.STRIPE_CONNECTED_ID, ConfigurationKeys.MOLLIE_CONNECT_REFRESH_TOKEN), ConfigurationLevel.organization((int)organizationId));
            result.put("stripeConnected", ((ConfigurationManager.MaybeConfiguration)options.get(ConfigurationKeys.STRIPE_CONNECTED_ID)).isPresent());
            result.put("mollieConnected", ((ConfigurationManager.MaybeConfiguration)options.get(ConfigurationKeys.MOLLIE_CONNECT_REFRESH_TOKEN)).isPresent());
        }
        return result;
    }

    @GetMapping(value={"/setting-categories"})
    public Collection<ConfigurationKeys.SettingCategory> getSettingCategories() {
        return EnumSet.allOf(ConfigurationKeys.SettingCategory.class);
    }

    @GetMapping(value={"/event/{eventId}/invoice-first-date"})
    public ResponseEntity<ZonedDateTime> getFirstInvoiceDate(@PathVariable Integer eventId, Principal principal) {
        this.accessService.checkEventOwnership(principal, eventId.intValue());
        return ResponseEntity.of(Wrappers.optionally(() -> this.eventManager.getSingleEventById(eventId.intValue(), principal.getName())).map(event -> this.billingDocumentManager.findFirstInvoiceDate(event.getId()).orElseGet(() -> ZonedDateTime.now(this.clockProvider.getClock().withZone(event.getZoneId())))));
    }

    @GetMapping(value={"/event/{eventId}/matching-invoices"})
    public ResponseEntity<List<Integer>> getMatchingInvoicesForEvent(@PathVariable Integer eventId, @RequestParam(value="from") long fromInstant, @RequestParam(value="to") long toInstant, Principal principal) {
        ZonedDateTime to;
        this.accessService.checkEventOwnership(principal, eventId.intValue());
        Optional eventOptional = Wrappers.optionally(() -> this.eventManager.getSingleEventById(eventId.intValue(), principal.getName()));
        if (eventOptional.isEmpty()) {
            return ResponseEntity.badRequest().build();
        }
        ZoneId zoneId = ((Event)eventOptional.get()).getZoneId();
        ZonedDateTime from = ZonedDateTime.ofInstant(Instant.ofEpochMilli(fromInstant), zoneId);
        if (from.isAfter(to = ZonedDateTime.ofInstant(Instant.ofEpochMilli(toInstant), zoneId))) {
            return ResponseEntity.badRequest().build();
        }
        return ResponseEntity.ok((Object)this.billingDocumentManager.findMatchingInvoiceIds(eventId, from, to));
    }

    @PostMapping(value={"/event/{eventId}/regenerate-invoices"})
    public ResponseEntity<Boolean> regenerateInvoices(@PathVariable Integer eventId, @RequestBody List<Long> documentIds, Principal principal) {
        this.accessService.checkBillingDocumentsOwnership(principal, eventId, documentIds);
        if (!this.eventManager.eventExistsById(eventId.intValue()) || documentIds.isEmpty()) {
            return ResponseEntity.badRequest().build();
        }
        return ResponseEntity.ok((Object)this.adminJobManager.scheduleExecution(AdminJobExecutor.JobName.REGENERATE_INVOICES, Map.of("username", principal.getName(), "eventId", eventId, "ids", documentIds.stream().map(String::valueOf).collect(Collectors.joining(",")))));
    }

    @PutMapping(value={"/generate-tickets-for-subscriptions"})
    public ResponseEntity<Boolean> generateTicketsForSubscriptions(@RequestParam(value="eventId", required=false) Integer eventId, @RequestParam(value="organizationId", required=false) Integer organizationId, Principal principal) {
        boolean admin = RequestUtils.isAdmin((Principal)principal);
        Map<String, Integer> jobMetadata = null;
        if (!(admin || organizationId != null && this.userManager.isOwnerOfOrganization(principal.getName(), organizationId.intValue()))) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build();
        }
        if (eventId != null && organizationId != null) {
            this.accessService.checkEventOwnership(principal, eventId.intValue(), organizationId.intValue());
            jobMetadata = Map.of("eventId", eventId, "organizationId", organizationId);
        } else if (organizationId != null) {
            this.accessService.checkOrganizationOwnership(principal, organizationId);
            jobMetadata = Map.of("organizationId", organizationId);
        }
        return ResponseEntity.ok((Object)this.adminJobManager.scheduleExecution(AdminJobExecutor.JobName.ASSIGN_TICKETS_TO_SUBSCRIBERS, Objects.requireNonNullElse(jobMetadata, Map.of())));
    }

    @GetMapping(value={"/global-translations-override"})
    public Map<String, Map<String, String>> loadTranslations() {
        return this.configurationManager.getFor(ConfigurationKeys.TRANSLATION_OVERRIDE, ConfigurationLevel.system()).getValue().map(v -> (Map)Json.fromJson((String)v, (TypeReference)new /* Unavailable Anonymous Inner Class!! */)).orElse(Map.of());
    }

    @GetMapping(value={"/organizations/{organizationId}/translations-override"})
    public Map<String, Map<String, String>> loadTranslationsOverrideForOrganization(@PathVariable int organizationId, Principal principal) {
        this.accessService.checkOrganizationOwnership(principal, Integer.valueOf(organizationId));
        return this.configurationManager.getFor(ConfigurationKeys.TRANSLATION_OVERRIDE, ConfigurationLevel.organization((int)organizationId)).getValue().map(v -> (Map)Json.fromJson((String)v, (TypeReference)new /* Unavailable Anonymous Inner Class!! */)).orElse(Map.of());
    }

    @GetMapping(value={"/events/{eventId}/translations-override"})
    public Map<String, Map<String, String>> loadTranslationsOverrideForEvent(@PathVariable int eventId, Principal principal) {
        EventAndOrganizationId eventAndOrgId = this.accessService.checkEventOwnership(principal, eventId);
        return this.configurationManager.getFor(ConfigurationKeys.TRANSLATION_OVERRIDE, ConfigurationLevel.event((EventAndOrganizationId)eventAndOrgId)).getValue().map(v -> (Map)Json.fromJson((String)v, (TypeReference)new /* Unavailable Anonymous Inner Class!! */)).orElse(Map.of());
    }

    @ConstructorProperties(value={"configurationManager", "billingDocumentManager", "adminJobManager", "eventManager", "clockProvider", "userManager", "accessService"})
    @Generated
    public ConfigurationApiController(ConfigurationManager configurationManager, BillingDocumentManager billingDocumentManager, AdminJobManager adminJobManager, EventManager eventManager, ClockProvider clockProvider, UserManager userManager, AccessService accessService) {
        this.configurationManager = configurationManager;
        this.billingDocumentManager = billingDocumentManager;
        this.adminJobManager = adminJobManager;
        this.eventManager = eventManager;
        this.clockProvider = clockProvider;
        this.userManager = userManager;
        this.accessService = accessService;
    }
}

