/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.admin;

import alfio.manager.AccessService;
import alfio.manager.support.CustomMessageManager;
import alfio.model.modification.MessageModification;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/api/events/{eventName}/messages"})
public class CustomMessagesApiController {
    private static final Logger log = LoggerFactory.getLogger(CustomMessagesApiController.class);
    private final CustomMessageManager customMessageManager;
    private final AccessService accessService;

    public CustomMessagesApiController(CustomMessageManager customMessageManager, AccessService accessService) {
        this.customMessageManager = customMessageManager;
        this.accessService = accessService;
    }

    @ExceptionHandler(value={IllegalStateException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public String handleException(IllegalStateException ex) {
        log.warn("Exception in CustomMessagesApiController", (Throwable)ex);
        return Optional.ofNullable(ex.getCause()).map(Throwable::getMessage).orElseGet(ex::getMessage);
    }

    @PostMapping(value={"/preview"})
    public Map<String, Object> preview(@PathVariable String eventName, @RequestParam(required=false, value="categoryId") Integer categoryId, @RequestBody List<MessageModification> messageModifications, Principal principal) {
        this.accessService.checkEventOwnership(principal, eventName);
        return this.customMessageManager.generatePreview(eventName, Optional.ofNullable(categoryId), messageModifications, principal.getName());
    }

    @PostMapping(value={"/send"})
    public void send(@PathVariable String eventName, @RequestParam(required=false, value="categoryId") Integer categoryId, @RequestBody List<MessageModification> messageModifications, Principal principal) {
        this.accessService.checkEventOwnership(principal, eventName);
        this.customMessageManager.sendMessages(eventName, Optional.ofNullable(categoryId), messageModifications, principal.getName());
    }
}

