/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.admin;

import alfio.controller.api.admin.EmailMessageApiController;
import alfio.controller.api.support.PageAndContent;
import alfio.manager.AccessService;
import alfio.manager.NotificationManager;
import alfio.manager.PurchaseContextManager;
import alfio.model.EmailMessage;
import alfio.model.PurchaseContext;
import java.beans.ConstructorProperties;
import java.security.Principal;
import java.time.ZoneId;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/api/{purchaseContextType}/{publicIdentifier}/email"})
public class EmailMessageApiController {
    private final NotificationManager notificationManager;
    private final PurchaseContextManager purchaseContextManager;
    private final AccessService accessService;

    @GetMapping
    public PageAndContent<List<LightweightEmailMessage>> loadEmailMessages(@PathVariable PurchaseContext.PurchaseContextType purchaseContextType, @PathVariable String publicIdentifier, @RequestParam(value="page", required=false) Integer page, @RequestParam(value="search", required=false) String search, Principal principal) {
        this.accessService.checkPurchaseContextOwnership(principal, purchaseContextType, publicIdentifier);
        PurchaseContext purchaseContext = (PurchaseContext)this.purchaseContextManager.findBy(purchaseContextType, publicIdentifier).orElseThrow();
        ZoneId zoneId = purchaseContext.getZoneId();
        Pair found = this.notificationManager.loadAllMessagesForPurchaseContext(purchaseContext, page, search);
        return new PageAndContent(((List)found.getRight()).stream().map(m -> new LightweightEmailMessage((EmailMessage)m, zoneId, true)).collect(Collectors.toList()), (Integer)found.getLeft());
    }

    @GetMapping(value={"/{messageId}"})
    public LightweightEmailMessage loadEmailMessage(@PathVariable PurchaseContext.PurchaseContextType purchaseContextType, @PathVariable String publicIdentifier, @PathVariable int messageId, Principal principal) {
        PurchaseContext purchaseContext = (PurchaseContext)this.purchaseContextManager.findBy(purchaseContextType, publicIdentifier).orElseThrow();
        this.accessService.checkOrganizationOwnership(principal, Integer.valueOf(purchaseContext.getOrganizationId()));
        return this.notificationManager.loadSingleMessageForPurchaseContext(purchaseContext, messageId).map(m -> new LightweightEmailMessage((EmailMessage)m, purchaseContext.getZoneId(), false)).orElseThrow(IllegalArgumentException::new);
    }

    @ConstructorProperties(value={"notificationManager", "purchaseContextManager", "accessService"})
    @Generated
    public EmailMessageApiController(NotificationManager notificationManager, PurchaseContextManager purchaseContextManager, AccessService accessService) {
        this.notificationManager = notificationManager;
        this.purchaseContextManager = purchaseContextManager;
        this.accessService = accessService;
    }
}

