/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.admin;

import alfio.controller.api.admin.EventApiController;
import alfio.controller.api.admin.SerializablePair;
import alfio.controller.api.support.EventListItem;
import alfio.controller.api.support.PageAndContent;
import alfio.controller.api.support.TicketHelper;
import alfio.controller.support.TemplateProcessor;
import alfio.extension.exception.AlfioScriptingException;
import alfio.manager.AccessService;
import alfio.manager.EventManager;
import alfio.manager.EventStatisticsManager;
import alfio.manager.ExtensionManager;
import alfio.manager.FileUploadManager;
import alfio.manager.PaymentManager;
import alfio.manager.TicketReservationManager;
import alfio.manager.i18n.I18nManager;
import alfio.manager.support.extension.ExtensionCapability;
import alfio.manager.system.ConfigurationLevel;
import alfio.manager.system.ConfigurationManager;
import alfio.manager.user.UserManager;
import alfio.model.BillingDetails;
import alfio.model.BillingDocument;
import alfio.model.Configurable;
import alfio.model.ContentLanguage;
import alfio.model.DetailedScanData;
import alfio.model.Event;
import alfio.model.EventAndOrganizationId;
import alfio.model.EventStatistic;
import alfio.model.LocalizedContent;
import alfio.model.PurchaseContext;
import alfio.model.PurchaseContextFieldConfiguration;
import alfio.model.SponsorScan;
import alfio.model.Ticket;
import alfio.model.TicketCategory;
import alfio.model.TicketReservation;
import alfio.model.TicketReservationInvoicingAdditionalInfo;
import alfio.model.TicketReservationWithTransaction;
import alfio.model.metadata.AlfioMetadata;
import alfio.model.modification.AdditionalFieldRequest;
import alfio.model.modification.CategoryOrdinalModification;
import alfio.model.modification.EventModification;
import alfio.model.modification.MetadataModification;
import alfio.model.modification.TicketAllocationModification;
import alfio.model.modification.TicketCategoryModification;
import alfio.model.modification.TicketWithStatistic;
import alfio.model.modification.TransactionMetadataModification;
import alfio.model.modification.UploadBase64FileModification;
import alfio.model.result.Result;
import alfio.model.result.ValidationResult;
import alfio.model.system.ConfigurationKeys;
import alfio.model.transaction.PaymentProxy;
import alfio.model.transaction.Transaction;
import alfio.model.user.Organization;
import alfio.model.user.Role;
import alfio.model.user.User;
import alfio.repository.EventDescriptionRepository;
import alfio.repository.PurchaseContextFieldRepository;
import alfio.repository.SponsorScanRepository;
import alfio.util.ClockProvider;
import alfio.util.ExportUtils;
import alfio.util.FileUtil;
import alfio.util.LocaleUtil;
import alfio.util.MonetaryUtil;
import alfio.util.TemplateManager;
import alfio.util.Validator;
import alfio.util.Wrappers;
import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvParser;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/admin/api"})
public class EventApiController {
    private static final Logger log = LoggerFactory.getLogger(EventApiController.class);
    private static final String OK = "OK";
    private static final String CUSTOM_FIELDS_PREFIX = "custom:";
    public static final String UNHANDLED_EXCEPTION = "unhandled exception";
    private final EventManager eventManager;
    private final EventStatisticsManager eventStatisticsManager;
    private final I18nManager i18nManager;
    private final TicketReservationManager ticketReservationManager;
    private final PurchaseContextFieldRepository purchaseContextFieldRepository;
    private final EventDescriptionRepository eventDescriptionRepository;
    private final TicketHelper ticketHelper;
    private final UserManager userManager;
    private final SponsorScanRepository sponsorScanRepository;
    private final PaymentManager paymentManager;
    private final TemplateManager templateManager;
    private final FileUploadManager fileUploadManager;
    private final ConfigurationManager configurationManager;
    private final ExtensionManager extensionManager;
    private final ClockProvider clockProvider;
    private final AccessService accessService;
    private static final String PAYMENT_METHOD = "Payment Method";
    private static final String EXTERNAL_REFERENCE = "External Reference";
    static final List<String> FIXED_FIELDS = Arrays.asList("ID", "Category", "Event", "Status", "OriginalPrice", "PaidPrice", "Discount", "VAT", "ReservationID", "Full Name", "First Name", "Last Name", "E-Mail", "Locked", "Language", "Confirmation", "Billing Address", "Country Code", "Payment ID", "Payment Method", "External Reference");
    private static final List<SerializablePair<String, String>> FIXED_PAIRS = FIXED_FIELDS.stream().map(f -> SerializablePair.of((Object)f, (Object)f)).collect(Collectors.toList());
    private static final String FISCAL_CODE = "Fiscal Code";
    private static final String REFERENCE_TYPE = "Reference Type";
    private static final List<String> ITALIAN_E_INVOICING_FIELDS = List.of("Fiscal Code", "Reference Type", "Addressee Code", "PEC");

    @ExceptionHandler(value={DataAccessException.class})
    public String exception(DataAccessException e) {
        log.warn("unhandled exception", (Throwable)e);
        return "unexpected error. More info in the application log";
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public String unhandledException(Exception e) {
        log.warn("unhandled exception", (Throwable)e);
        return e.getMessage();
    }

    @ExceptionHandler(value={IllegalStateException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public String unhandledIllegalStateException(IllegalStateException e) {
        log.warn("unhandled exception", (Throwable)e);
        if (e.getCause() instanceof AlfioScriptingException) {
            return e.getCause().getMessage();
        }
        return e.getMessage();
    }

    @GetMapping(value={"/paymentProxies/{organizationId}"})
    @ResponseStatus(value=HttpStatus.OK)
    public List<PaymentManager.PaymentMethodDTO> getPaymentProxies(@PathVariable int organizationId, Principal principal) {
        this.accessService.checkOrganizationMembership(principal, organizationId, AccessService.MEMBERSHIP_ROLES);
        return this.userManager.findUserOrganizations(principal.getName()).stream().filter(o -> o.getId() == organizationId).findFirst().map(o -> this.paymentManager.getPaymentMethods(o.getId())).orElse(Collections.emptyList());
    }

    @GetMapping(value={"/events"}, headers={"Authorization"})
    public List<EventListItem> getAllEventsForExternal(Authentication authentication, HttpServletRequest request, @RequestParam(value="includeOnline", required=false, defaultValue="false") boolean includeOnline) {
        List<Integer> userOrganizations = this.userManager.findUserOrganizations(authentication.getName()).stream().map(Organization::getId).toList();
        int dateRangeForEvents = EventApiController.isSponsor((Authentication)authentication) ? 10 : 1;
        return this.eventManager.getEventsByDateRange(dateRangeForEvents).stream().filter(e -> userOrganizations.contains(e.getOrganizationId()) && (includeOnline || e.getFormat() != Event.EventFormat.ONLINE)).sorted(Comparator.comparing(e -> e.getBegin().withZoneSameInstant(ZoneId.systemDefault()))).map(s -> new EventListItem(s, request.getContextPath(), this.eventDescriptionRepository.findByEventId(s.getId()))).collect(Collectors.toList());
    }

    @GetMapping(value={"/events"})
    public List<EventStatistic> getAllEvents(Principal principal) {
        return this.eventStatisticsManager.getAllEventsWithStatistics(principal.getName());
    }

    @GetMapping(value={"/events-count"})
    public ResponseEntity<Integer> getEventsCount() {
        return ResponseEntity.ok((Object)this.eventManager.getEventsCount());
    }

    @GetMapping(value={"/active-events"})
    public List<EventStatistic> getAllActiveEvents(Principal principal) {
        return this.eventStatisticsManager.getAllEventsWithStatisticsFilteredBy(principal.getName(), event -> !event.expiredSince(14));
    }

    @GetMapping(value={"/expired-events"})
    public List<EventStatistic> getAllExpiredEvents(Principal principal) {
        ArrayList<EventStatistic> results = new ArrayList<EventStatistic>(this.eventStatisticsManager.getAllEventsWithStatisticsFilteredBy(principal.getName(), event -> event.expiredSince(14)));
        Collections.reverse(results);
        return results;
    }

    @GetMapping(value={"/events/{name}"})
    public ResponseEntity<EventAndOrganization> getSingleEvent(@PathVariable(value="name") String eventName, Principal principal) {
        this.accessService.checkEventMembership(principal, eventName, AccessService.MEMBERSHIP_ROLES);
        String username = principal.getName();
        return Wrappers.optionally(() -> this.eventStatisticsManager.getEventWithAdditionalInfo(eventName, username)).map(event -> {
            EventAndOrganization out = new EventAndOrganization(event, this.eventManager.loadOrganizer((EventAndOrganizationId)event.getEvent(), username));
            return ResponseEntity.ok((Object)out);
        }).orElseGet(() -> new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND));
    }

    @DeleteMapping(value={"/events/{eventId}"})
    public void deleteEvent(@PathVariable int eventId, Principal principal) {
        this.accessService.checkEventOwnership(principal, eventId);
        this.eventManager.deleteEvent(eventId, principal.getName());
    }

    @GetMapping(value={"/events/id/{eventId}"})
    public Event getSingleEventById(@PathVariable int eventId, Principal principal) {
        this.accessService.checkEventOwnership(principal, eventId);
        return this.eventManager.getSingleEventById(eventId, principal.getName());
    }

    @PostMapping(value={"/events/check"})
    public ValidationResult validateEventRequest(@RequestBody EventModification eventModification, Errors errors, Principal principal) {
        if (eventModification.getId() != null) {
            this.accessService.checkEventOwnership(principal, eventModification.getId().intValue());
        }
        int descriptionMaxLength = this.getDescriptionLength();
        return EventApiController.validateEvent((EventModification)eventModification, (Errors)errors, (int)descriptionMaxLength);
    }

    private int getDescriptionLength() {
        return this.configurationManager.getFor(ConfigurationKeys.DESCRIPTION_MAXLENGTH, ConfigurationLevel.system()).getValueAsIntOrDefault(4096);
    }

    public static ValidationResult validateEvent(EventModification eventModification, Errors errors, int descriptionMaxLength) {
        ValidationResult base = Validator.validateEventHeader(Optional.empty(), (EventModification)eventModification, (int)descriptionMaxLength, (Errors)errors).or(Validator.validateEventDates((EventModification)eventModification, (Errors)errors)).or(Validator.validateTicketCategories((EventModification)eventModification, (Errors)errors)).or(Validator.validateEventPrices((EventModification)eventModification, (Errors)errors)).or(eventModification.getAdditionalServices().stream().map(as -> Validator.validateAdditionalService((EventModification.AdditionalService)as, (EventModification)eventModification, (Errors)errors)).reduce(ValidationResult::or).orElse(ValidationResult.success()));
        AtomicInteger counter = new AtomicInteger();
        return base.or(eventModification.getTicketCategories().stream().map(c -> Validator.validateCategory((TicketCategoryModification)c, (Errors)errors, (String)("ticketCategories[" + counter.getAndIncrement() + "]."), (EventModification)eventModification, (int)descriptionMaxLength)).reduce(ValidationResult::or).orElse(ValidationResult.success())).or(EventApiController.validateAdditionalTicketFields((List)eventModification.getTicketFields(), (Errors)errors));
    }

    private static ValidationResult validateAdditionalTicketFields(List<AdditionalFieldRequest> ticketFields, Errors errors) {
        AtomicInteger cnt = new AtomicInteger();
        return Optional.ofNullable(ticketFields).orElseGet(Collections::emptyList).stream().map(field -> {
            String prefix = "ticketFields[" + cnt.getAndIncrement() + "]";
            if (StringUtils.isBlank((CharSequence)field.getName())) {
                errors.rejectValue(prefix + ".name", "error.required");
            }
            return Validator.evaluateValidationResult((Errors)errors);
        }).reduce(ValidationResult::or).orElseGet(ValidationResult::success);
    }

    @GetMapping(value={"/events/name-by-ids"})
    public Map<Integer, String> getEventNamesByIds(@RequestParam(value="eventIds") List<Integer> eventIds, Principal principal) {
        this.accessService.ensureAdmin(principal);
        return this.eventManager.getEventNamesByIds(eventIds, principal);
    }

    @GetMapping(value={"/events/names-in-organization/{orgId}"})
    public Map<Integer, String> getEventsNameInOrganization(@PathVariable int orgId, Principal principal) {
        this.accessService.checkOrganizationOwnership(principal, Integer.valueOf(orgId));
        return this.eventManager.getEventsNameInOrganization(orgId, principal);
    }

    @PostMapping(value={"/events/new"})
    public String insertEvent(@RequestBody EventModification eventModification, Principal principal) {
        this.accessService.checkOrganizationOwnership(principal, Integer.valueOf(eventModification.getOrganizationId()));
        this.eventManager.createEvent(eventModification, principal.getName());
        return "OK";
    }

    @PutMapping(value={"/events/{id}/status"})
    public String activateEvent(@PathVariable int id, @RequestParam(value="active") boolean active, Principal principal) {
        this.accessService.checkEventOwnership(principal, id);
        this.eventManager.toggleActiveFlag(id, principal.getName(), active);
        return "OK";
    }

    @PostMapping(value={"/events/{id}/header/update"})
    public ValidationResult updateHeader(@PathVariable int id, @RequestBody EventModification eventModification, Errors errors, Principal principal) {
        this.accessService.checkEventOwnership(principal, id);
        Event event = this.eventManager.getSingleEventById(id, principal.getName());
        return Validator.validateEventHeader(Optional.of(event), (EventModification)eventModification, (int)this.getDescriptionLength(), (Errors)errors).ifSuccess(() -> this.eventManager.updateEventHeader(event, eventModification, principal.getName()));
    }

    @PostMapping(value={"/events/{id}/prices/update"})
    public ValidationResult updatePrices(@PathVariable int id, @RequestBody EventModification eventModification, Errors errors, Principal principal) {
        this.accessService.checkEventOwnership(principal, id);
        Event event = this.eventManager.getSingleEventById(id, principal.getName());
        return Validator.validateEventPrices((EventModification)eventModification, (Errors)errors).ifSuccess(() -> this.eventManager.updateEventSeatsAndPrices(event, eventModification, principal.getName()));
    }

    @PostMapping(value={"/events/{eventId}/categories/{categoryId}/update"})
    public ValidationResult updateExistingCategory(@PathVariable int eventId, @PathVariable int categoryId, @RequestBody TicketCategoryModification category, Errors errors, Principal principal) {
        this.accessService.checkCategoryOwnership(principal, eventId, categoryId);
        Assert.isTrue((categoryId == category.getId() ? 1 : 0) != 0, (String)"categoryId must be equal to category.getId()");
        return Validator.validateCategory((TicketCategoryModification)category, (Errors)errors, (int)this.getDescriptionLength()).ifSuccess(() -> this.eventManager.updateCategory(categoryId, eventId, category, principal.getName()));
    }

    @PostMapping(value={"/events/{eventId}/categories/new"})
    public ValidationResult createCategory(@PathVariable int eventId, @RequestBody TicketCategoryModification category, Errors errors, Principal principal) {
        this.accessService.checkEventOwnership(principal, eventId);
        return Validator.validateCategory((TicketCategoryModification)category, (Errors)errors, (int)this.getDescriptionLength()).ifSuccess(() -> this.eventManager.insertCategory(eventId, category, principal.getName()));
    }

    @PutMapping(value={"/events/reallocate"})
    public String reallocateTickets(@RequestBody TicketAllocationModification form, Principal principal) {
        EventAndOrganizationId event = this.accessService.checkCategoryOwnership(principal, form.getEventId(), Set.of(Integer.valueOf(form.getSrcCategoryId()), Integer.valueOf(form.getTargetCategoryId())));
        this.eventManager.reallocateTickets(form.getSrcCategoryId(), form.getTargetCategoryId(), event);
        return "OK";
    }

    @PutMapping(value={"/events/{eventName}/category/{categoryId}/unbind-tickets"})
    public String unbindTickets(@PathVariable String eventName, @PathVariable int categoryId, Principal principal) {
        this.accessService.checkCategoryOwnership(principal, eventName, categoryId);
        this.eventManager.unbindTickets(eventName, categoryId, principal.getName());
        return "OK";
    }

    @DeleteMapping(value={"/events/{eventName}/category/{categoryId}"})
    public String deleteCategory(@PathVariable String eventName, @PathVariable int categoryId, Principal principal) {
        this.accessService.checkCategoryOwnership(principal, eventName, categoryId);
        this.eventManager.deleteCategory(eventName, categoryId, principal.getName());
        return "OK";
    }

    @PutMapping(value={"/events/{eventName}/rearrange-categories"})
    public ResponseEntity<String> rearrangeCategories(@PathVariable String eventName, @RequestBody List<CategoryOrdinalModification> categories, Principal principal) {
        this.accessService.checkCategoryOwnership(principal, eventName, categories.stream().map(CategoryOrdinalModification::getId).collect(Collectors.toSet()));
        if (CollectionUtils.isEmpty(categories)) {
            return ResponseEntity.badRequest().build();
        }
        this.eventManager.rearrangeCategories(eventName, categories, principal.getName());
        return ResponseEntity.ok((Object)"OK");
    }

    @GetMapping(value={"/events/{eventName}/export"})
    public void downloadAllTicketsCSV(@PathVariable String eventName, @RequestParam(name="format", defaultValue="excel") String format, HttpServletRequest request, HttpServletResponse response, Principal principal) throws IOException {
        this.accessService.checkEventOwnership(principal, eventName);
        List<String> fields = Arrays.asList(Optional.ofNullable(request.getParameterValues("fields")).orElse(new String[0]));
        Event event = this.loadEvent(eventName, principal);
        Map categoriesMap = this.eventManager.loadTicketCategories((EventAndOrganizationId)event).stream().collect(Collectors.toMap(TicketCategory::getId, Function.identity()));
        ZoneId eventZoneId = event.getZoneId();
        if ("excel".equals(format)) {
            this.exportTicketExcel(event.getShortName(), response, principal, fields, categoriesMap, eventZoneId);
        } else {
            this.exportTicketCSV(event.getShortName(), response, principal, fields, categoriesMap, eventZoneId);
        }
    }

    private void exportTicketExcel(String eventName, HttpServletResponse response, Principal principal, List<String> fields, Map<Integer, TicketCategory> categoriesMap, ZoneId eventZoneId) throws IOException {
        ExportUtils.exportExcel((String)(eventName + "-export.xlsx"), (String)(eventName + " export"), (String[])this.exportHeader(fields), (Stream)this.exportLines(eventName, principal, fields, categoriesMap, eventZoneId), (HttpServletResponse)response);
    }

    private void exportTicketCSV(String eventName, HttpServletResponse response, Principal principal, List<String> fields, Map<Integer, TicketCategory> categoriesMap, ZoneId eventZoneId) throws IOException {
        ExportUtils.exportCsv((String)(eventName + "-export.csv"), (String[])this.exportHeader(fields), (Stream)this.exportLines(eventName, principal, fields, categoriesMap, eventZoneId), (HttpServletResponse)response);
    }

    private String[] exportHeader(List<String> fields) {
        return (String[])fields.stream().map(f -> {
            if (f.startsWith("custom:")) {
                return f.substring("custom:".length());
            }
            return f;
        }).toArray(String[]::new);
    }

    private Stream<String[]> exportLines(String eventName, Principal principal, List<String> fields, Map<Integer, TicketCategory> categoriesMap, ZoneId eventZoneId) {
        String username = principal.getName();
        boolean eInvoicingEnabled = this.configurationManager.isItalianEInvoicingEnabled((Configurable)this.eventManager.getEventAndOrganizationId(eventName, username));
        return this.eventManager.findAllConfirmedTicketsForCSV(eventName, username).stream().map(trs -> {
            Ticket t = trs.getTicket();
            String currencyCode = t.getCurrencyCode();
            TicketReservation reservation = trs.getTicketReservation();
            ArrayList<String> line = new ArrayList<String>();
            if (fields.contains("ID")) {
                line.add(t.getUuid());
            }
            if (fields.contains("Category")) {
                line.add(((TicketCategory)categoriesMap.get(t.getCategoryId())).getName());
            }
            if (fields.contains("Event")) {
                line.add(eventName);
            }
            if (fields.contains("Status")) {
                line.add(t.getStatus().toString());
            }
            if (fields.contains("OriginalPrice")) {
                line.add(MonetaryUtil.centsToUnit((int)t.getSrcPriceCts(), (String)currencyCode).toString());
            }
            if (fields.contains("PaidPrice")) {
                line.add(MonetaryUtil.centsToUnit((int)t.getFinalPriceCts(), (String)currencyCode).toString());
            }
            if (fields.contains("Discount")) {
                line.add(MonetaryUtil.centsToUnit((int)t.getDiscountCts(), (String)currencyCode).toString());
            }
            if (fields.contains("VAT")) {
                line.add(MonetaryUtil.centsToUnit((int)t.getVatCts(), (String)currencyCode).toString());
            }
            if (fields.contains("ReservationID")) {
                line.add(t.getTicketsReservationId());
            }
            if (fields.contains("Full Name")) {
                line.add(t.getFullName());
            }
            if (fields.contains("First Name")) {
                line.add(t.getFirstName());
            }
            if (fields.contains("Last Name")) {
                line.add(t.getLastName());
            }
            if (fields.contains("E-Mail")) {
                line.add(t.getEmail());
            }
            if (fields.contains("Locked")) {
                line.add(String.valueOf(t.getLockedAssignment()));
            }
            if (fields.contains("Language")) {
                line.add(String.valueOf(t.getUserLanguage()));
            }
            if (fields.contains("Confirmation")) {
                line.add(reservation.getConfirmationTimestamp().withZoneSameInstant(eventZoneId).toString());
            }
            if (fields.contains("Billing Address")) {
                line.add(reservation.getBillingAddress());
            }
            if (fields.contains("Country Code")) {
                line.add(reservation.getVatCountryCode());
            }
            boolean paymentIdRequested = fields.contains("Payment ID");
            boolean paymentGatewayRequested = fields.contains("Payment Method");
            if (paymentIdRequested || paymentGatewayRequested) {
                Optional transaction = trs.getTransaction();
                if (paymentIdRequested) {
                    line.add(Objects.toString(transaction.map(Transaction::getPaymentId).orElse(null), transaction.map(Transaction::getTransactionId).orElse("")));
                }
                if (paymentGatewayRequested) {
                    line.add(transaction.map(tr -> tr.getPaymentProxy().name()).orElse(""));
                }
            }
            if (fields.contains("External Reference")) {
                line.add(t.getExtReference());
            }
            if (eInvoicingEnabled) {
                BillingDetails billingDetails = trs.getBillingDetails();
                Optional<TicketReservationInvoicingAdditionalInfo.ItalianEInvoicing> optionalInvoicingData = Optional.ofNullable(billingDetails.getInvoicingAdditionalInfo()).map(TicketReservationInvoicingAdditionalInfo::getItalianEInvoicing);
                if (fields.contains("Fiscal Code")) {
                    line.add(optionalInvoicingData.map(TicketReservationInvoicingAdditionalInfo.ItalianEInvoicing::getFiscalCode).orElse(""));
                }
                if (fields.contains("Reference Type")) {
                    line.add(optionalInvoicingData.map(TicketReservationInvoicingAdditionalInfo.ItalianEInvoicing::getReferenceTypeAsString).orElse(""));
                }
                if (fields.contains("Addressee Code")) {
                    line.add(optionalInvoicingData.map(TicketReservationInvoicingAdditionalInfo.ItalianEInvoicing::getAddresseeCode).orElse(""));
                }
                if (fields.contains("PEC")) {
                    line.add(optionalInvoicingData.map(TicketReservationInvoicingAdditionalInfo.ItalianEInvoicing::getPec).orElse(""));
                }
            }
            Map additionalValues = this.purchaseContextFieldRepository.findAllValuesForTicketId(t.getId());
            Predicate<String> contains = FIXED_FIELDS::contains;
            fields.stream().filter(contains.negate()).filter(f -> f.startsWith("custom:")).forEachOrdered(field -> {
                String customFieldName = field.substring("custom:".length());
                line.add(additionalValues.getOrDefault(customFieldName, "").replace("\"", ""));
            });
            return line.toArray(new String[0]);
        });
    }

    @GetMapping(value={"/events/{eventName}/sponsor-scan/export"})
    public void downloadSponsorScanExport(@PathVariable String eventName, @RequestParam(name="format", defaultValue="excel") String format, HttpServletResponse response, Principal principal) throws IOException {
        this.accessService.checkEventOwnership(principal, eventName);
        Event event = this.eventManager.getSingleEvent(eventName, principal.getName());
        List fields = this.purchaseContextFieldRepository.findAdditionalFieldsForEvent(event.getId());
        ArrayList<String> header = new ArrayList<String>();
        header.add("Username/Api Key");
        header.add("Description");
        header.add("Timestamp");
        header.add("Full name");
        header.add("Email");
        header.addAll(fields.stream().map(PurchaseContextFieldConfiguration::getName).toList());
        header.add("Sponsor notes");
        header.add("Lead Status");
        header.add("Operator");
        Stream<String[]> sponsorScans = this.userManager.findAllEnabledUsers(principal.getName()).stream().map(u -> Pair.of((Object)u, (Object)this.userManager.getUserRole(u))).filter(p -> p.getRight() == Role.SPONSOR).flatMap(p -> this.sponsorScanRepository.loadSponsorData(event.getId(), ((User)p.getKey()).getId(), SponsorScanRepository.DEFAULT_TIMESTAMP).stream().map(v -> Pair.of((Object)v, (Object)this.purchaseContextFieldRepository.findAllValuesForTicketId(v.getTicket().getId())))).map(p -> {
            DetailedScanData data = (DetailedScanData)p.getLeft();
            Map descriptions = (Map)p.getRight();
            return Pair.of((Object)data, fields.stream().map(x -> descriptions.getOrDefault(x.getName(), "")).collect(Collectors.toList()));
        }).map(p -> {
            ArrayList<String> line = new ArrayList<String>();
            Ticket ticket = ((DetailedScanData)p.getLeft()).getTicket();
            SponsorScan sponsorScan = ((DetailedScanData)p.getLeft()).getSponsorScan();
            User user = this.userManager.findUser(sponsorScan.getUserId(), principal);
            line.add(user.getUsername());
            line.add(user.getDescription());
            line.add(sponsorScan.getTimestamp().toString());
            line.add(ticket.getFullName());
            line.add(ticket.getEmail());
            line.addAll((Collection)p.getRight());
            line.add(sponsorScan.getNotes());
            line.add(sponsorScan.getLeadStatus().name());
            line.add(sponsorScan.getOperator());
            return line.toArray(new String[0]);
        });
        if ("excel".equals(format)) {
            this.exportSponsorScanExcel(event.getShortName(), header, sponsorScans, response);
        } else {
            this.exportSponsorScanCSV(event.getShortName(), header, sponsorScans, response);
        }
    }

    private void exportSponsorScanExcel(String eventName, List<String> header, Stream<String[]> sponsorScans, HttpServletResponse response) throws IOException {
        ExportUtils.exportExcel((String)(eventName + "-sponsor-scan.xlsx"), (String)(eventName + " sponsor scan"), (String[])header.toArray(new String[0]), sponsorScans, (HttpServletResponse)response);
    }

    private void exportSponsorScanCSV(String eventName, List<String> header, Stream<String[]> sponsorScans, HttpServletResponse response) throws IOException {
        ExportUtils.exportCsv((String)(eventName + "-sponsor-scan.csv"), (String[])header.toArray(new String[0]), sponsorScans, (HttpServletResponse)response);
    }

    @GetMapping(value={"/events/{eventName}/fields"})
    public List<SerializablePair<String, String>> getAllFields(@PathVariable String eventName, Principal principal) {
        this.accessService.checkEventOwnership(principal, eventName);
        EventAndOrganizationId eventAndOrganizationId = this.eventManager.getEventAndOrganizationId(eventName, principal.getName());
        ArrayList<SerializablePair<String, String>> fields = new ArrayList<SerializablePair<String, String>>(FIXED_PAIRS);
        if (this.configurationManager.isItalianEInvoicingEnabled((Configurable)eventAndOrganizationId)) {
            fields.addAll(ITALIAN_E_INVOICING_FIELDS.stream().map(f -> SerializablePair.of((Object)f, (Object)f)).collect(Collectors.toList()));
        }
        fields.addAll(this.purchaseContextFieldRepository.findFieldsForEvent(eventName).stream().map(f -> SerializablePair.of((Object)("custom:" + f), (Object)f)).collect(Collectors.toList()));
        return fields;
    }

    @GetMapping(value={"/events/{eventName}/pending-payments"})
    public List<TicketReservationWithTransaction> getPendingPayments(@PathVariable String eventName, Principal principal) {
        this.accessService.checkEventOwnership(principal, eventName);
        return this.ticketReservationManager.getPendingPayments(eventName);
    }

    @GetMapping(value={"/events/{eventName}/pending-payments-count"})
    public Integer getPendingPaymentsCount(@PathVariable String eventName, Principal principal) {
        this.accessService.checkEventMembership(principal, eventName, AccessService.MEMBERSHIP_ROLES);
        return this.eventManager.getOptionalEventAndOrganizationIdByName(eventName, principal.getName()).map(e -> this.ticketReservationManager.getPendingPaymentsCount(e.getId())).orElse(0);
    }

    @PostMapping(value={"/events/{eventName}/pending-payments/{reservationId}/confirm"})
    public String confirmPayment(@PathVariable String eventName, @PathVariable String reservationId, @RequestBody TransactionMetadataModification transactionMetadataModification, Principal principal) {
        this.accessService.checkEventAndReservationOwnership(principal, eventName, Set.of(reservationId));
        Event event = this.loadEvent(eventName, principal);
        this.ticketReservationManager.confirmOfflinePayment(event, reservationId, transactionMetadataModification, principal.getName());
        this.ticketReservationManager.findById(reservationId).filter(TicketReservation::isDirectAssignmentRequested).ifPresent(reservation -> {
            Locale locale = LocaleUtil.forLanguageTag((String)reservation.getUserLanguage(), (LocalizedContent)event);
            this.ticketHelper.directTicketAssignment(eventName, reservationId, reservation.getEmail(), reservation.getFullName(), reservation.getFirstName(), reservation.getLastName(), reservation.getUserLanguage(), Optional.empty(), locale);
        });
        return "OK";
    }

    @DeleteMapping(value={"/events/{eventName}/pending-payments/{reservationId}"})
    public String deletePendingPayment(@PathVariable String eventName, @PathVariable String reservationId, @RequestParam(required=false, value="credit", defaultValue="false") Boolean creditReservation, @RequestParam(required=false, value="notify", defaultValue="true") Boolean notify, Principal principal) {
        this.accessService.checkEventAndReservationOwnership(principal, eventName, Set.of(reservationId));
        this.ticketReservationManager.deleteOfflinePayment(this.loadEvent(eventName, principal), reservationId, false, Boolean.TRUE.equals(creditReservation), notify.booleanValue(), principal.getName());
        return "OK";
    }

    @PostMapping(value={"/events/{eventName}/pending-payments/bulk-confirmation"})
    public List<Triple<Boolean, String, String>> bulkConfirmation(@PathVariable String eventName, Principal principal, @RequestBody UploadBase64FileModification file) throws IOException {
        try (InputStreamReader isr = new InputStreamReader(file.getInputStream(), StandardCharsets.UTF_8);){
            MappingIterator iterator = new CsvMapper().readerForListOf(String.class).with((FormatSchema)CsvSchema.emptySchema().withoutHeader()).with((FormatFeature)CsvParser.Feature.WRAP_AS_ARRAY).readValues((Reader)isr);
            List<Transaction> all = iterator.readAll().stream().filter(line -> line.size() > 1).map(line -> new Transaction((String)line.get(0), new BigDecimal((String)line.get(1)))).toList();
            Set reservationIds = all.stream().map(Transaction::reservationId).collect(Collectors.toSet());
            this.accessService.checkEventAndReservationOwnership(principal, eventName, reservationIds, true);
            Event event = this.loadEvent(eventName, principal);
            List<Triple<Boolean, String, String>> list = all.stream().map(line -> {
                try {
                    this.ticketReservationManager.validateAndConfirmOfflinePayment(line.reservationId, event, line.price, principal.getName());
                    return Triple.of((Object)Boolean.TRUE, (Object)line.reservationId, (Object)"");
                }
                catch (Exception e) {
                    return Triple.of((Object)Boolean.FALSE, (Object)Optional.ofNullable(line.reservationId).orElse(""), (Object)e.getMessage());
                }
            }).collect(Collectors.toList());
            return list;
        }
    }

    @PutMapping(value={"/events/{eventName}/categories/{categoryId}/tickets/{ticketId}/toggle-locking"})
    public boolean toggleTicketLocking(@PathVariable String eventName, @PathVariable int categoryId, @PathVariable int ticketId, Principal principal) {
        this.accessService.checkCategoryOwnershipAndTicket(principal, eventName, categoryId, ticketId);
        return this.eventManager.toggleTicketLocking(eventName, categoryId, ticketId, principal.getName());
    }

    @GetMapping(value={"/events/{eventName}/languages"})
    public List<ContentLanguage> getAvailableLocales(@PathVariable String eventName, Principal principal) {
        this.accessService.checkEventOwnership(principal, eventName);
        return this.i18nManager.getEventLanguages(eventName);
    }

    @GetMapping(value={"/events/{eventName}/invoices/count"})
    public Integer countBillingDocumentsForEvent(@PathVariable String eventName, Principal principal) {
        this.accessService.checkEventOwnership(principal, eventName);
        return this.eventManager.getOptionalEventAndOrganizationIdByName(eventName, principal.getName()).map(e -> this.ticketReservationManager.countBillingDocuments(e.getId())).orElse(0);
    }

    @GetMapping(value={"/events/{eventName}/all-documents"})
    public void getAllInvoices(@PathVariable String eventName, HttpServletResponse response, Principal principal) throws IOException {
        this.accessService.checkEventOwnership(principal, eventName);
        Event event = this.loadEvent(eventName, principal);
        response.setContentType("application/zip");
        response.setHeader("Content-Disposition", "attachment; filename=" + event.getShortName() + "-invoices.zip");
        try (ServletOutputStream os = response.getOutputStream();
             ZipOutputStream zipOS = new ZipOutputStream((OutputStream)os);){
            this.ticketReservationManager.streamAllDocumentsFor(event.getId()).forEach(pair -> {
                TicketReservation reservation = ((TicketReservationWithTransaction)pair.getLeft()).getTicketReservation();
                for (BillingDocument document : (List)pair.getRight()) {
                    this.addPdfToZip(event, zipOS, reservation, document);
                }
            });
        }
    }

    private void addPdfToZip(Event event, ZipOutputStream zipOS, TicketReservation reservation, BillingDocument document) {
        Optional pdf;
        Map reservationModel = document.getModel();
        Locale language = LocaleUtil.forLanguageTag((String)reservation.getUserLanguage());
        switch (1.$SwitchMap$alfio$model$BillingDocument$Type[document.getType().ordinal()]) {
            case 1: {
                Optional optional = TemplateProcessor.buildCreditNotePdf((PurchaseContext)event, (FileUploadManager)this.fileUploadManager, (Locale)language, (TemplateManager)this.templateManager, (Map)reservationModel, (ExtensionManager)this.extensionManager);
                break;
            }
            case 2: {
                Optional optional = TemplateProcessor.buildReceiptPdf((PurchaseContext)event, (FileUploadManager)this.fileUploadManager, (Locale)language, (TemplateManager)this.templateManager, (Map)reservationModel, (ExtensionManager)this.extensionManager);
                break;
            }
            default: {
                Optional optional = pdf = TemplateProcessor.buildInvoicePdf((PurchaseContext)event, (FileUploadManager)this.fileUploadManager, (Locale)language, (TemplateManager)this.templateManager, (Map)reservationModel, (ExtensionManager)this.extensionManager);
            }
        }
        if (pdf.isPresent()) {
            String fileName = FileUtil.getBillingDocumentFileName((String)event.getShortName(), (String)reservation.getId(), (BillingDocument)document);
            ZipEntry entry = new ZipEntry(fileName);
            entry.setTimeLocal(document.getGenerationTimestamp().withZoneSameInstant(event.getZoneId()).toLocalDateTime());
            zipOS.putNextEntry(entry);
            StreamUtils.copy((byte[])((byte[])pdf.get()), (OutputStream)zipOS);
        }
    }

    @GetMapping(value={"/events/{eventName}/all-documents-xls"})
    public void getAllDocumentsXls(@PathVariable String eventName, HttpServletResponse response, Principal principal) throws IOException {
        this.accessService.checkEventOwnership(principal, eventName);
        Event event = this.loadEvent(eventName, principal);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
        boolean italianEInvoicingEnabled = this.configurationManager.isItalianEInvoicingEnabled((Configurable)event);
        ArrayList<String> header = new ArrayList<String>();
        header.add("Reservation ID");
        header.add("Type");
        header.add("Number");
        header.add("To");
        header.add("Tax ID");
        if (italianEInvoicingEnabled) {
            header.add("Fiscal Code");
            header.add("Reference Type");
            header.add("Reference");
            header.add("Split Payment");
        }
        header.add("Total Before Tax");
        header.add("Tax");
        header.add("Total");
        header.add("Currency");
        header.add("Payment Method");
        header.add("Generated on");
        ExportUtils.exportExcel((String)(event.getShortName() + "-billing-documents.xlsx"), (String)"Documents", (String[])((String[])header.toArray(String[]::new)), this.ticketReservationManager.streamAllDocumentsFor(event.getId()).flatMap(entry -> {
            TicketReservationWithTransaction reservationWithTransaction = (TicketReservationWithTransaction)entry.getKey();
            TicketReservation reservation = reservationWithTransaction.getTicketReservation();
            return ((List)entry.getValue()).stream().map(bd -> {
                Map orderSummary = (Map)bd.getModel().get("orderSummary");
                ArrayList<String> fields = new ArrayList<String>();
                fields.add(reservation.getId());
                fields.add(bd.getType().name());
                fields.add(bd.getNumber());
                fields.add(reservation.getLineSplittedBillingAddress().stream().findFirst().orElse(""));
                fields.add(reservation.getVatNr());
                if (italianEInvoicingEnabled) {
                    TicketReservationInvoicingAdditionalInfo additionalInfo = reservationWithTransaction.getBillingDetails().getInvoicingAdditionalInfo();
                    boolean hasEInvoicingInfo = !additionalInfo.isEmpty();
                    TicketReservationInvoicingAdditionalInfo.ItalianEInvoicing eInvoicingInfo = additionalInfo.getItalianEInvoicing();
                    fields.add(hasEInvoicingInfo ? eInvoicingInfo.getFiscalCode() : "");
                    fields.add(hasEInvoicingInfo ? eInvoicingInfo.getReferenceTypeAsString() : "");
                    fields.add(hasEInvoicingInfo ? eInvoicingInfo.getReference() : "");
                    fields.add(hasEInvoicingInfo ? Boolean.toString(eInvoicingInfo.isSplitPayment()) : "");
                }
                fields.add(StringUtils.trimToEmpty((String)((String)orderSummary.get("totalNetPrice"))));
                fields.add(StringUtils.trimToEmpty((String)((String)orderSummary.get("totalVAT"))));
                fields.add(StringUtils.trimToEmpty((String)((String)orderSummary.get("totalPrice"))));
                fields.add(reservation.getCurrencyCode());
                fields.add(Objects.requireNonNullElse(reservation.getPaymentMethod(), PaymentProxy.NONE).name());
                fields.add(bd.getGenerationTimestamp().withZoneSameInstant(event.getZoneId()).format(formatter));
                return (String[])fields.toArray(String[]::new);
            });
        }), (HttpServletResponse)response);
    }

    @GetMapping(value={"/events-all-languages"})
    public List<ContentLanguage> getAllLanguages() {
        return this.i18nManager.getAvailableLanguages();
    }

    @GetMapping(value={"/events-supported-languages"})
    public List<ContentLanguage> getSupportedLanguages() {
        return this.i18nManager.getAvailableLanguages();
    }

    @GetMapping(value={"/events/{eventName}/category/{categoryId}/ticket"})
    public PageAndContent<List<TicketWithStatistic>> getTicketsInCategory(@PathVariable String eventName, @PathVariable int categoryId, @RequestParam(value="page", required=false) Integer page, @RequestParam(value="search", required=false) String search, Principal principal) {
        this.accessService.checkCategoryOwnership(principal, eventName, categoryId);
        EventAndOrganizationId event = this.eventManager.getEventAndOrganizationId(eventName, principal.getName());
        return new PageAndContent((Object)this.eventStatisticsManager.loadModifiedTickets(event.getId(), categoryId, page == null ? 0 : page, search), this.eventStatisticsManager.countModifiedTicket(event.getId(), categoryId, search));
    }

    @GetMapping(value={"/events/{eventName}/ticket-sold-statistics"})
    public ResponseEntity<TicketsStatistics> getTicketsStatistics(@PathVariable String eventName, @RequestParam(value="from", required=false) String f, @RequestParam(value="to", required=false) String t, Principal principal) {
        this.accessService.checkEventOwnership(principal, eventName);
        return ResponseEntity.of(this.eventManager.getOptionalByName(eventName, principal.getName()).map(event -> {
            int eventId = event.getId();
            ZoneId zoneId = event.getZoneId();
            ZonedDateTime from = this.parseDate(f, zoneId, () -> this.eventStatisticsManager.getFirstReservationConfirmedTimestamp(event.getId()), () -> ZonedDateTime.now(this.clockProvider.getClock().withZone(zoneId)).minusDays(1L));
            ZonedDateTime reservedFrom = this.parseDate(f, zoneId, () -> this.eventStatisticsManager.getFirstReservationCreatedTimestamp(event.getId()), () -> ZonedDateTime.now(this.clockProvider.getClock().withZone(zoneId)).minusDays(1L));
            ZonedDateTime to = this.parseDate(t, zoneId, Optional::empty, () -> ZonedDateTime.now(this.clockProvider.getClock().withZone(zoneId))).plusDays(1L);
            String granularity = this.getGranularity(reservedFrom, to);
            List ticketSoldStatistics = this.eventStatisticsManager.getTicketSoldStatistics(eventId, from, to, granularity);
            List ticketReservedStatistics = this.eventStatisticsManager.getTicketReservedStatistics(eventId, reservedFrom, to, granularity);
            return new TicketsStatistics(granularity, ticketSoldStatistics, ticketReservedStatistics);
        }));
    }

    private String getGranularity(ZonedDateTime from, ZonedDateTime to) {
        if (ChronoUnit.MONTHS.between(from, to) > 12L) {
            return "month";
        }
        if (ChronoUnit.MONTHS.between(from, to) > 3L) {
            return "week";
        }
        return "day";
    }

    private ZonedDateTime parseDate(String dateToParse, ZoneId zoneId, Supplier<Optional<ZonedDateTime>> dateLoader, Supplier<ZonedDateTime> orElseGet) {
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("uuuu-MM-dd");
        return Optional.ofNullable(dateToParse).map(p -> LocalDate.parse(p, dateFormatter).atTime(23, 59, 59).atZone(zoneId)).or(dateLoader).map(z -> z.withZoneSameInstant(zoneId)).orElseGet(orElseGet).truncatedTo(ChronoUnit.DAYS);
    }

    @DeleteMapping(value={"/events/{eventName}/reservation/{reservationId}/transaction/{transactionId}/discard"})
    public ResponseEntity<String> discardMatchingPayment(@PathVariable String eventName, @PathVariable String reservationId, @PathVariable int transactionId, Principal principal) {
        this.accessService.checkEventAndReservationAndTransactionOwnership(principal, eventName, reservationId, transactionId);
        Result result = this.ticketReservationManager.discardMatchingPayment(eventName, reservationId, transactionId);
        if (result.isSuccess()) {
            return ResponseEntity.ok((Object)"OK");
        }
        return ResponseEntity.notFound().build();
    }

    @PutMapping(value={"/events/{eventName}/metadata"})
    public ResponseEntity<Boolean> updateMetadata(@PathVariable String eventName, @RequestBody MetadataModification metadataModification, Principal principal) {
        this.accessService.checkEventOwnership(principal, eventName);
        if (!metadataModification.isValid()) {
            return ResponseEntity.badRequest().build();
        }
        return ResponseEntity.of(this.eventManager.getOptionalByName(eventName, principal.getName()).map(event -> this.eventManager.updateMetadata(event, metadataModification.toMetadataObj())));
    }

    @GetMapping(value={"/events/{eventName}/metadata"})
    public ResponseEntity<AlfioMetadata> loadMetadata(@PathVariable String eventName, Principal principal) {
        this.accessService.checkEventOwnership(principal, eventName);
        return ResponseEntity.of(this.eventManager.getOptionalEventAndOrganizationIdByName(eventName, principal.getName()).map(arg_0 -> ((EventManager)this.eventManager).getMetadataForEvent(arg_0)));
    }

    @PutMapping(value={"/events/{eventName}/category/{categoryId}/metadata"})
    public ResponseEntity<Boolean> updateCategoryMetadata(@PathVariable String eventName, @PathVariable int categoryId, @RequestBody MetadataModification metadataModification, Principal principal) {
        this.accessService.checkCategoryOwnership(principal, eventName, categoryId);
        if (!metadataModification.isValid()) {
            return ResponseEntity.badRequest().build();
        }
        return ResponseEntity.of(this.eventManager.getOptionalEventAndOrganizationIdByName(eventName, principal.getName()).map(event -> this.eventManager.updateCategoryMetadata(event, categoryId, metadataModification.toMetadataObj())));
    }

    @GetMapping(value={"/events/{eventName}/category/{categoryId}/metadata"})
    public ResponseEntity<AlfioMetadata> loadCategoryMetadata(@PathVariable String eventName, @PathVariable int categoryId, Principal principal) {
        this.accessService.checkCategoryOwnership(principal, eventName, categoryId);
        return ResponseEntity.of(this.eventManager.getOptionalEventAndOrganizationIdByName(eventName, principal.getName()).map(event -> this.eventManager.getMetadataForCategory(event, categoryId)));
    }

    @PostMapping(value={"/events/{eventName}/capability/{capability}"})
    public ResponseEntity<String> executeCapabilityForEvent(@PathVariable String eventName, @PathVariable ExtensionCapability capability, @RequestBody Map<String, String> params, Principal principal) {
        this.accessService.checkEventOwnership(principal, eventName);
        try {
            return ResponseEntity.of((Optional)this.eventManager.executeCapability(eventName, principal.getName(), capability, params));
        }
        catch (AlfioScriptingException ex) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).header("Alfio-Extension-Error-Class", new String[]{((Object)((Object)ex)).getClass().getSimpleName()})).body((Object)ex.getMessage());
        }
    }

    private Event loadEvent(String eventName, Principal principal) {
        Optional singleEvent = this.eventManager.getOptionalByName(eventName, principal.getName());
        Validate.isTrue((boolean)singleEvent.isPresent(), (String)"event not found", (Object[])new Object[0]);
        return (Event)singleEvent.orElseThrow();
    }

    private static boolean isSponsor(Authentication authentication) {
        return CollectionUtils.emptyIfNull((Collection)authentication.getAuthorities()).stream().anyMatch(ga -> ga.getAuthority().equals("ROLE_SPONSOR"));
    }

    @ConstructorProperties(value={"eventManager", "eventStatisticsManager", "i18nManager", "ticketReservationManager", "purchaseContextFieldRepository", "eventDescriptionRepository", "ticketHelper", "userManager", "sponsorScanRepository", "paymentManager", "templateManager", "fileUploadManager", "configurationManager", "extensionManager", "clockProvider", "accessService"})
    @Generated
    public EventApiController(EventManager eventManager, EventStatisticsManager eventStatisticsManager, I18nManager i18nManager, TicketReservationManager ticketReservationManager, PurchaseContextFieldRepository purchaseContextFieldRepository, EventDescriptionRepository eventDescriptionRepository, TicketHelper ticketHelper, UserManager userManager, SponsorScanRepository sponsorScanRepository, PaymentManager paymentManager, TemplateManager templateManager, FileUploadManager fileUploadManager, ConfigurationManager configurationManager, ExtensionManager extensionManager, ClockProvider clockProvider, AccessService accessService) {
        this.eventManager = eventManager;
        this.eventStatisticsManager = eventStatisticsManager;
        this.i18nManager = i18nManager;
        this.ticketReservationManager = ticketReservationManager;
        this.purchaseContextFieldRepository = purchaseContextFieldRepository;
        this.eventDescriptionRepository = eventDescriptionRepository;
        this.ticketHelper = ticketHelper;
        this.userManager = userManager;
        this.sponsorScanRepository = sponsorScanRepository;
        this.paymentManager = paymentManager;
        this.templateManager = templateManager;
        this.fileUploadManager = fileUploadManager;
        this.configurationManager = configurationManager;
        this.extensionManager = extensionManager;
        this.clockProvider = clockProvider;
        this.accessService = accessService;
    }
}

