/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.admin;

import alfio.manager.ExportManager;
import alfio.model.ReservationsByEvent;
import alfio.model.support.ReservationInfo;
import alfio.model.support.TicketInfo;
import alfio.util.ExportUtils;
import alfio.util.MonetaryUtil;
import ch.digitalfondue.basicxlsx.StreamingWorkbook;
import ch.digitalfondue.basicxlsx.Style;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.security.Principal;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/admin/api/export"})
public class ExportApiController {
    private final ExportManager exportManager;

    public ExportApiController(ExportManager exportManager) {
        this.exportManager = exportManager;
    }

    @GetMapping(value={"/reservations"})
    public void downloadAllEvents(@RequestParam(name="from") String from, @RequestParam(name="to") String to, HttpServletResponse response, Principal principal) throws IOException {
        List allEvents = this.exportManager.reservationsForInterval(LocalDate.parse(Objects.requireNonNull(from)), LocalDate.parse(Objects.requireNonNull(to)), Objects.requireNonNull(principal));
        if (allEvents.isEmpty()) {
            response.setContentType("text/plain");
            response.setStatus(HttpStatus.PRECONDITION_REQUIRED.value());
            response.getWriter().write("No reservations found for the selected period");
        } else {
            ExportUtils.exportExcel((String)"all-reservations.xlsx", (HttpServletResponse)response, workbook -> ExportApiController.writeSheets((List)allEvents, (StreamingWorkbook)workbook));
        }
    }

    private static void writeSheets(List<ReservationsByEvent> allEvents, StreamingWorkbook workbook) {
        String[] header = new String[]{"Event Name", "Reservation ID", "Confirmation Date", "Billed to", "Tax ID", "Tax Code", "Invoice #", "Amount", "Tax", "Currency", "Payment Type", "Ticket ID", "Ticket Type", "Ticket Amount", "Ticket Tax", "Attendee", "Status"};
        Style headerStyle = workbook.defineStyle().font().bold(true).build();
        allEvents.stream().sorted(Comparator.comparing(ReservationsByEvent::getEventShortName)).forEach(e -> ExportApiController.addSheet((StreamingWorkbook)workbook, (String[])header, (Style)headerStyle, (ReservationsByEvent)e));
    }

    private static void addSheet(StreamingWorkbook workbook, String[] header, Style headerStyle, ReservationsByEvent eventWithReservations) {
        Stream rowData = eventWithReservations.getReservations().stream().sorted(Comparator.comparing(ReservationInfo::getConfirmationTimestamp)).flatMap(r -> ExportApiController.ticketRows((ReservationsByEvent)eventWithReservations, (ReservationInfo)r));
        ExportUtils.addSheetToWorkbook((String)eventWithReservations.getEventShortName(), (String[])header, rowData, (StreamingWorkbook)workbook, (Style)headerStyle);
    }

    private static Stream<String[]> ticketRows(ReservationsByEvent eventWithReservations, ReservationInfo r) {
        return r.getTickets().stream().map(t -> ExportApiController.buildTicketRow((ReservationsByEvent)eventWithReservations, (ReservationInfo)r, (TicketInfo)t));
    }

    private static String[] buildTicketRow(ReservationsByEvent eventWithReservations, ReservationInfo r, TicketInfo t) {
        return new String[]{eventWithReservations.getDisplayName(), r.getId(), r.getConfirmationTimestamp(), ExportApiController.billingCompanyOrFullName((ReservationInfo)r), r.getTaxId(), r.getTaxCode(), r.getInvoiceNumber(), ExportApiController.formatAmount((Integer)r.getSrcPriceCts(), (String)r.getCurrency()), ExportApiController.formatAmount((Integer)r.getTaxCts(), (String)r.getCurrency()), r.getCurrency(), r.getPaymentType().name(), t.getId(), t.getType(), ExportApiController.formatAmount((Integer)t.getSrcPriceCts(), (String)r.getCurrency()), ExportApiController.formatAmount((Integer)t.getTaxCts(), (String)r.getCurrency()), (Objects.requireNonNullElse(t.getFirstName(), "") + " " + Objects.requireNonNullElse(t.getLastName(), "")).trim(), t.getStatus()};
    }

    private static String billingCompanyOrFullName(ReservationInfo r) {
        return Objects.requireNonNullElseGet(r.getCompanyName(), () -> r.getFirstName() + " " + r.getLastName());
    }

    private static String formatAmount(Integer originalCts, String currency) {
        if (originalCts == null) {
            return "";
        }
        return MonetaryUtil.formatCents((int)originalCts, (String)currency);
    }
}

