/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.admin;

import alfio.controller.api.admin.SerializablePair;
import alfio.controller.api.support.PageAndContent;
import alfio.extension.Extension;
import alfio.extension.ExtensionService;
import alfio.manager.AccessService;
import alfio.manager.EventManager;
import alfio.manager.user.UserManager;
import alfio.model.EventAndOrganizationId;
import alfio.model.ExtensionLog;
import alfio.model.ExtensionSupport;
import alfio.model.user.Organization;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/admin/api/extensions"})
public class ExtensionApiController {
    private static final Logger log = LoggerFactory.getLogger(ExtensionApiController.class);
    private static final String SAMPLE_JS;
    private final ExtensionService extensionService;
    private final UserManager userManager;
    private final EventManager eventManager;
    private final AccessService accessService;

    @GetMapping(value={""})
    public List<ExtensionSupport> listAll(Principal principal) {
        this.accessService.ensureAdmin(principal);
        return this.extensionService.listAll();
    }

    @GetMapping(value={"/sample"})
    public ExtensionSupport getSample() {
        return new ExtensionSupport(null, "-", "", null, true, true, SAMPLE_JS, null);
    }

    @PostMapping(value={""})
    public ResponseEntity<SerializablePair<Boolean, String>> create(@RequestBody Extension script, Principal principal) {
        return this.createOrUpdate(null, null, script, principal);
    }

    @PostMapping(value={"{path}/{name}"})
    public ResponseEntity<SerializablePair<Boolean, String>> update(@PathVariable String path, @PathVariable String name, @RequestBody Extension script, Principal principal) {
        return this.createOrUpdate(path, name, script, principal);
    }

    private ResponseEntity<SerializablePair<Boolean, String>> createOrUpdate(String previousPath, String previousName, Extension script, Principal principal) {
        try {
            this.accessService.ensureAdmin(principal);
            this.extensionService.createOrUpdate(previousPath, previousName, script);
            return ResponseEntity.ok((Object)SerializablePair.of((Object)true, null));
        }
        catch (Throwable t) {
            log.error("unexpected exception", t);
            return ResponseEntity.badRequest().body((Object)SerializablePair.of((Object)false, (Object)t.getMessage()));
        }
    }

    @GetMapping(value={"{path}/{name}"})
    public ResponseEntity<ExtensionSupport> loadSingle(@PathVariable String path, @PathVariable String name, Principal principal) {
        this.accessService.ensureAdmin(principal);
        return this.extensionService.getSingle(URLDecoder.decode(path, StandardCharsets.UTF_8), name).map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @DeleteMapping(value={"{path}/{name}"})
    public void delete(@PathVariable String path, @PathVariable String name, Principal principal) {
        this.accessService.ensureAdmin(principal);
        this.extensionService.delete(path, name);
    }

    @PostMapping(value={"/{path}/{name}/toggle/{enable}"})
    public void toggle(@PathVariable String path, @PathVariable String name, @PathVariable boolean enable, Principal principal) {
        this.accessService.ensureAdmin(principal);
        this.extensionService.toggle(path, name, enable);
    }

    @GetMapping(value={"/setting/system"})
    public Map<Integer, List<ExtensionSupport.ExtensionParameterMetadataAndValue>> getParametersFor(Principal principal) {
        if (this.userManager.isAdmin(this.userManager.findUserByUsername(principal.getName()))) {
            return this.extensionService.getConfigurationParametersFor("-", "-%", "SYSTEM").stream().collect(Collectors.groupingBy(ExtensionSupport.ExtensionParameterMetadataAndValue::getExtensionId));
        }
        return Map.of();
    }

    @PostMapping(value={"/setting/system/bulk-update"})
    public void bulkUpdateSystem(@RequestBody List<ExtensionSupport.ExtensionMetadataValue> toUpdate, Principal principal) {
        this.accessService.ensureAdmin(principal);
        ExtensionApiController.ensureIdsArePresent(toUpdate, (List)this.extensionService.getConfigurationParametersFor("-", "-%", "SYSTEM"));
        this.extensionService.bulkUpdateSystemSettings(toUpdate);
    }

    @DeleteMapping(value={"/setting/system/{id}"})
    public void deleteSystemSettingValue(@PathVariable int id, Principal principal) {
        this.accessService.ensureAdmin(principal);
        this.extensionService.deleteSettingValue(id, "-");
    }

    @GetMapping(value={"/setting/organization/{orgId}"})
    public Map<Integer, List<ExtensionSupport.ExtensionParameterMetadataAndValue>> getParametersFor(@PathVariable int orgId, Principal principal) {
        this.accessService.checkOrganizationOwnership(principal, Integer.valueOf(orgId));
        Organization org = this.userManager.findOrganizationById(orgId, principal.getName());
        return this.extensionService.getConfigurationParametersFor("-" + org.getId(), "-" + org.getId() + "-%", "ORGANIZATION").stream().collect(Collectors.groupingBy(ExtensionSupport.ExtensionParameterMetadataAndValue::getExtensionId));
    }

    @PostMapping(value={"/setting/organization/{orgId}/bulk-update"})
    public void bulkUpdateOrganization(@PathVariable int orgId, @RequestBody List<ExtensionSupport.ExtensionMetadataValue> toUpdate, Principal principal) {
        this.accessService.checkOrganizationOwnership(principal, Integer.valueOf(orgId));
        Organization org = this.userManager.findOrganizationById(orgId, principal.getName());
        ExtensionApiController.ensureIdsArePresent(toUpdate, (List)this.extensionService.getConfigurationParametersFor("-" + org.getId(), "-" + org.getId() + "-%", "ORGANIZATION"));
        this.extensionService.bulkUpdateOrganizationSettings(org, toUpdate);
    }

    @DeleteMapping(value={"/setting/organization/{orgId}/{id}"})
    public void deleteOrganizationSettingValue(@PathVariable int orgId, @PathVariable int id, Principal principal) {
        this.accessService.checkOrganizationOwnership(principal, Integer.valueOf(orgId));
        this.extensionService.deleteSettingValue(id, "-" + orgId);
    }

    @GetMapping(value={"/setting/organization/{orgId}/event/{shortName}"})
    public Map<Integer, List<ExtensionSupport.ExtensionParameterMetadataAndValue>> getParametersFor(@PathVariable int orgId, @PathVariable(value="shortName") String eventShortName, Principal principal) {
        this.accessService.checkEventOwnership(principal, eventShortName, orgId);
        EventAndOrganizationId event = (EventAndOrganizationId)this.eventManager.getOptionalEventAndOrganizationIdByName(eventShortName, principal.getName()).orElseThrow(IllegalStateException::new);
        String pattern = ExtensionApiController.generatePatternFrom((EventAndOrganizationId)event);
        return this.extensionService.getConfigurationParametersFor(pattern, pattern, "EVENT").stream().collect(Collectors.groupingBy(ExtensionSupport.ExtensionParameterMetadataAndValue::getExtensionId));
    }

    @PostMapping(value={"/setting/organization/{orgId}/event/{shortName}/bulk-update"})
    public void bulkUpdateEvent(@PathVariable int orgId, @PathVariable(value="shortName") String eventShortName, @RequestBody List<ExtensionSupport.ExtensionMetadataValue> toUpdate, Principal principal) {
        this.accessService.checkEventOwnership(principal, eventShortName, orgId);
        Organization org = this.userManager.findOrganizationById(orgId, principal.getName());
        EventAndOrganizationId event = (EventAndOrganizationId)this.eventManager.getOptionalEventAndOrganizationIdByName(eventShortName, principal.getName()).orElseThrow(IllegalStateException::new);
        String pattern = ExtensionApiController.generatePatternFrom((EventAndOrganizationId)event);
        ExtensionApiController.ensureIdsArePresent(toUpdate, (List)this.extensionService.getConfigurationParametersFor(pattern, pattern, "EVENT"));
        this.extensionService.bulkUpdateEventSettings(org, event, toUpdate);
    }

    @DeleteMapping(value={"/setting/organization/{orgId}/event/{shortName}/{id}"})
    public void deleteEventSettingValue(@PathVariable int orgId, @PathVariable(value="shortName") String eventShortName, @PathVariable int id, Principal principal) {
        this.accessService.checkEventOwnership(principal, eventShortName, orgId);
        EventAndOrganizationId event = (EventAndOrganizationId)this.eventManager.getOptionalEventAndOrganizationIdByName(eventShortName, principal.getName()).orElseThrow(IllegalStateException::new);
        this.extensionService.deleteSettingValue(id, ExtensionApiController.generatePatternFrom((EventAndOrganizationId)event));
    }

    private static String generatePatternFrom(EventAndOrganizationId event) {
        return String.format("-%d-%d", event.getOrganizationId(), event.getId());
    }

    private static void ensureIdsArePresent(List<ExtensionSupport.ExtensionMetadataValue> toUpdate, List<ExtensionSupport.ExtensionParameterMetadataAndValue> system) {
        Set toUpdateIds;
        Set validIds = system.stream().map(ExtensionSupport.ExtensionParameterMetadataAndValue::getId).collect(Collectors.toSet());
        if (!validIds.containsAll(toUpdateIds = toUpdate.stream().map(ExtensionSupport.ExtensionMetadataValue::getId).collect(Collectors.toSet()))) {
            throw new IllegalStateException();
        }
    }

    @GetMapping(value={"/log"})
    public PageAndContent<List<ExtensionLog>> getLog(@RequestParam(required=false, name="path") String path, @RequestParam(required=false, name="name") String name, @RequestParam(required=false, name="type") ExtensionLog.Type type, @RequestParam(required=false, name="page", defaultValue="0") Integer page, Principal principal) {
        this.accessService.ensureAdmin(principal);
        int pageSize = 50;
        Pair res = this.extensionService.getLog(StringUtils.trimToNull((String)path), StringUtils.trimToNull((String)name), type, 50, (page == null ? 0 : page) * 50);
        return new PageAndContent((Object)((List)res.getLeft()), (Integer)res.getRight());
    }

    @ConstructorProperties(value={"extensionService", "userManager", "eventManager", "accessService"})
    @Generated
    public ExtensionApiController(ExtensionService extensionService, UserManager userManager, EventManager eventManager, AccessService accessService) {
        this.extensionService = extensionService;
        this.userManager = userManager;
        this.eventManager = eventManager;
        this.accessService = accessService;
    }

    static {
        try (InputStream is = new ClassPathResource("/alfio/extension/sample.js").getInputStream();){
            SAMPLE_JS = StreamUtils.copyToString((InputStream)is, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalStateException("cannot read sample file", e);
        }
    }
}

