/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.admin;

import alfio.manager.FileUploadManager;
import alfio.model.modification.UploadBase64FileModification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/api"})
public class FileUploadApiController {
    private static final Logger log = LoggerFactory.getLogger(FileUploadApiController.class);
    private final FileUploadManager fileUploadManager;

    public FileUploadApiController(FileUploadManager fileUploadManager) {
        this.fileUploadManager = fileUploadManager;
    }

    @PostMapping(value={"/file/upload"})
    public ResponseEntity<String> uploadFile(@RequestBody UploadBase64FileModification upload) {
        try {
            return ResponseEntity.ok((Object)this.fileUploadManager.insertFile(upload));
        }
        catch (Exception e) {
            log.error("error while uploading image", (Throwable)e);
            return ResponseEntity.badRequest().build();
        }
    }
}

