/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.admin;

import alfio.manager.AccessService;
import alfio.manager.EventManager;
import alfio.manager.GroupManager;
import alfio.model.EventAndOrganizationId;
import alfio.model.group.Group;
import alfio.model.group.LinkedGroup;
import alfio.model.modification.GroupModification;
import alfio.model.modification.LinkedGroupModification;
import alfio.model.result.ErrorCode;
import alfio.model.result.Result;
import java.beans.ConstructorProperties;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/api/group"})
public class GroupApiController {
    private final GroupManager groupManager;
    private final EventManager eventManager;
    private final AccessService accessService;

    @ExceptionHandler(value={GroupManager.DuplicateGroupItemException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public String handleDuplicateGroupItemException(GroupManager.DuplicateGroupItemException exc) {
        return exc.getMessage();
    }

    @GetMapping(value={"/for/{organizationId}"})
    public ResponseEntity<List<Group>> loadAllGroupsForOrganization(@PathVariable int organizationId, @RequestParam(name="showAll", defaultValue="false", required=false) boolean showAll, Principal principal) {
        this.accessService.checkOrganizationOwnership(principal, Integer.valueOf(organizationId));
        if (showAll) {
            return ResponseEntity.ok((Object)this.groupManager.getAllForOrganization(organizationId));
        }
        return ResponseEntity.ok((Object)this.groupManager.getAllActiveForOrganization(organizationId));
    }

    @GetMapping(value={"/for/{organizationId}/detail/{listId}"})
    public ResponseEntity<GroupModification> loadDetail(@PathVariable int organizationId, @PathVariable int listId, Principal principal) {
        this.accessService.checkGroupOwnership(principal, listId, organizationId);
        return this.groupManager.loadComplete(listId).map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @PostMapping(value={"/for/{organizationId}/update/{groupId}"})
    public ResponseEntity<GroupModification> updateGroup(@PathVariable int organizationId, @PathVariable(value="groupId") int listId, @RequestBody GroupModification modification, Principal principal) {
        this.accessService.checkGroupUpdateRequest(principal, listId, organizationId, modification);
        return this.groupManager.update(listId, modification).map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @PostMapping(value={"/for/{organizationId}/new"})
    public ResponseEntity<String> createNew(@PathVariable int organizationId, @RequestBody GroupModification request, Principal principal) {
        this.accessService.checkGroupCreateRequest(principal, organizationId, request);
        if (request.getOrganizationId() != organizationId) {
            return ResponseEntity.badRequest().build();
        }
        Result result = this.groupManager.createNew(request);
        if (result.isSuccess()) {
            return ResponseEntity.ok((Object)String.valueOf(result.getData()));
        }
        ErrorCode error = result.getFirstErrorOrNull();
        if (error != null && error.getCode().equals("value.duplicate")) {
            return ResponseEntity.badRequest().body((Object)error.getDescription());
        }
        return ResponseEntity.badRequest().build();
    }

    @GetMapping(value={"/for/event/{eventName}/all"})
    public ResponseEntity<List<LinkedGroup>> findLinked(@PathVariable String eventName, Principal principal) {
        this.accessService.checkEventMembership(principal, eventName, AccessService.MEMBERSHIP_ROLES);
        return this.eventManager.getOptionalEventAndOrganizationIdByName(eventName, principal.getName()).map(event -> ResponseEntity.ok((Object)this.groupManager.getLinksForEvent(event.getId()))).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @GetMapping(value={"/for/event/{eventName}"})
    public ResponseEntity<LinkedGroup> findActiveGroup(@PathVariable String eventName, Principal principal) {
        this.accessService.checkEventOwnership(principal, eventName);
        return this.eventManager.getOptionalEventAndOrganizationIdByName(eventName, principal.getName()).map(event -> {
            Optional<LinkedGroup> configuration = this.groupManager.getLinksForEvent(event.getId()).stream().filter(c -> c.getTicketCategoryId() == null).findFirst();
            return configuration.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.noContent().build());
        }).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @GetMapping(value={"/for/event/{eventName}/category/{categoryId}"})
    public ResponseEntity<LinkedGroup> findActiveGroup(@PathVariable String eventName, @PathVariable int categoryId, Principal principal) {
        this.accessService.checkCategoryOwnership(principal, eventName, categoryId);
        return this.eventManager.getOptionalEventAndOrganizationIdByName(eventName, principal.getName()).map(event -> {
            Optional<LinkedGroup> configuration = this.groupManager.findLinks(event.getId(), categoryId).stream().filter(c -> c.getTicketCategoryId() != null && c.getTicketCategoryId() == categoryId).findFirst();
            return configuration.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.noContent().build());
        }).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @PostMapping(value={"/{groupId}/link"})
    public ResponseEntity<Integer> linkGroup(@PathVariable int groupId, @RequestBody LinkedGroupModification body, Principal principal) {
        if (body == null || groupId != body.getGroupId()) {
            return ResponseEntity.badRequest().build();
        }
        EventAndOrganizationId event = body.getTicketCategoryId() != null ? this.accessService.checkCategoryOwnership(principal, body.getEventId(), body.getTicketCategoryId().intValue()) : this.accessService.checkEventOwnership(principal, body.getEventId());
        Optional<LinkedGroup> existing = this.groupManager.getLinksForEvent(event.getId()).stream().filter(c -> Objects.equals(body.getTicketCategoryId(), c.getTicketCategoryId())).findFirst();
        LinkedGroup link = existing.isPresent() ? this.groupManager.updateLink(existing.get().getId(), body) : this.groupManager.createLink(groupId, event.getId(), body);
        return ResponseEntity.ok((Object)link.getId());
    }

    @DeleteMapping(value={"/for/{organizationId}/event/{eventId}/link/{configurationId}"})
    public ResponseEntity<String> unlinkGroup(@PathVariable int organizationId, @PathVariable int configurationId, @PathVariable int eventId, @RequestParam(name="categoryId", required=false) Integer categoryId, Principal principal) {
        this.accessService.checkGroupLinkOwnership(principal, configurationId, organizationId, eventId, categoryId);
        this.groupManager.disableLink(configurationId);
        return ResponseEntity.ok((Object)"OK");
    }

    @DeleteMapping(value={"/for/{organizationId}/id/{groupId}/member/{memberId}"})
    public ResponseEntity<Boolean> deactivateMember(@PathVariable int groupId, @PathVariable int memberId, @PathVariable int organizationId, Principal principal) {
        this.accessService.checkGroupOwnership(principal, groupId, organizationId);
        return ResponseEntity.ok((Object)this.groupManager.deactivateMembers(Collections.singletonList(memberId), groupId));
    }

    @DeleteMapping(value={"/for/{organizationId}/id/{groupId}"})
    public ResponseEntity<Boolean> deactivateGroup(@PathVariable int groupId, @PathVariable int organizationId, Principal principal) {
        this.accessService.checkGroupOwnership(principal, groupId, organizationId);
        return ResponseEntity.ok((Object)this.groupManager.deactivateGroup(groupId));
    }

    @ConstructorProperties(value={"groupManager", "eventManager", "accessService"})
    @Generated
    public GroupApiController(GroupManager groupManager, EventManager eventManager, AccessService accessService) {
        this.groupManager = groupManager;
        this.eventManager = eventManager;
        this.accessService = accessService;
    }
}

