/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.admin;

import alfio.controller.api.admin.LocationApiController;
import alfio.manager.system.ConfigurationLevel;
import alfio.manager.system.ConfigurationManager;
import alfio.model.modification.support.LocationDescriptor;
import alfio.model.system.ConfigurationKeys;
import com.moodysalem.TimezoneMapper;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/api"})
public class LocationApiController {
    private static final Logger log = LoggerFactory.getLogger(LocationApiController.class);
    private final ConfigurationManager configurationManager;

    @Autowired
    public LocationApiController(ConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public String unhandledException(Exception e) {
        log.error("Exception in location api", (Throwable)e);
        return e.getMessage();
    }

    @GetMapping(value={"/location/timezones"})
    public List<String> getTimezones() {
        ArrayList<String> s = new ArrayList<String>(ZoneId.getAvailableZoneIds());
        s.sort(String::compareTo);
        return s;
    }

    @GetMapping(value={"/location/timezone"})
    public String getTimezone(@RequestParam(value="lat") double lat, @RequestParam(value="lng") double lng) {
        String tzId = TimezoneMapper.tzNameAt((double)lat, (double)lng);
        return this.getTimezones().contains(tzId) ? tzId : null;
    }

    @GetMapping(value={"/location/static-map-image"})
    public String getMapImage(@RequestParam(name="lat", required=false) String lat, @RequestParam(name="lng", required=false) String lng) {
        return LocationDescriptor.getMapUrl((String)lat, (String)lng, (Map)this.getGeoConf());
    }

    private Map<ConfigurationKeys, ConfigurationManager.MaybeConfiguration> getGeoConf() {
        Set<ConfigurationKeys> keys = Set.of(ConfigurationKeys.MAPS_PROVIDER, ConfigurationKeys.MAPS_CLIENT_API_KEY, ConfigurationKeys.MAPS_HERE_API_KEY);
        return this.configurationManager.getFor(keys, ConfigurationLevel.system());
    }

    @GetMapping(value={"/location/map-provider-client-api-key"})
    public ProviderAndKeys getGeoInfoProviderAndKeys() {
        Map geoInfoConfiguration = this.getGeoConf();
        ConfigurationKeys.GeoInfoProvider provider = LocationDescriptor.getProvider((Map)geoInfoConfiguration);
        EnumMap apiKeys = new EnumMap(ConfigurationKeys.class);
        geoInfoConfiguration.forEach((k, v) -> v.getValue().ifPresent(value -> apiKeys.put((ConfigurationKeys)k, value)));
        return new ProviderAndKeys(provider, apiKeys);
    }
}

