/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.admin;

import alfio.controller.api.admin.PollAdminApiController;
import alfio.manager.AccessService;
import alfio.manager.PollManager;
import alfio.model.EventAndOrganizationId;
import alfio.model.modification.PollModification;
import alfio.model.poll.Poll;
import alfio.model.poll.PollParticipant;
import alfio.model.poll.PollStatistics;
import java.beans.ConstructorProperties;
import java.security.Principal;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/api/{eventName}/poll"})
public class PollAdminApiController {
    private final PollManager pollManager;
    private final AccessService accessService;

    @GetMapping
    ResponseEntity<List<PollModification>> getAllForEvent(@PathVariable String eventName, Principal principal) {
        if (StringUtils.isEmpty((CharSequence)eventName)) {
            return ResponseEntity.badRequest().build();
        }
        this.accessService.checkEventOwnership(principal, eventName);
        return ResponseEntity.ok(this.pollManager.getAllForEvent(eventName).stream().map(PollModification::from).collect(Collectors.toList()));
    }

    @GetMapping(value={"/{pollId}"})
    ResponseEntity<PollModification> getPollDetail(@PathVariable String eventName, @PathVariable Long pollId, Principal principal) {
        if (StringUtils.isEmpty((CharSequence)eventName) || pollId == null) {
            return ResponseEntity.badRequest().build();
        }
        this.accessService.checkEventOwnership(principal, eventName);
        return ResponseEntity.of(this.pollManager.getSingleForEvent(pollId, eventName).map(PollModification::from));
    }

    @PostMapping
    ResponseEntity<Long> createNewPoll(@PathVariable String eventName, @RequestBody PollModification form, Principal principal) {
        if (form == null || !form.isValid()) {
            return ResponseEntity.badRequest().build();
        }
        this.accessService.checkEventOwnership(principal, eventName);
        return ResponseEntity.of((Optional)this.pollManager.createNewPoll(eventName, form));
    }

    @PostMapping(value={"/{pollId}"})
    ResponseEntity<PollModification> updatePoll(@PathVariable String eventName, @PathVariable Long pollId, @RequestBody PollModification form, Principal principal) {
        if (form == null || !form.isValid(pollId)) {
            return ResponseEntity.badRequest().build();
        }
        this.accessService.checkEventOwnership(principal, eventName);
        return ResponseEntity.of(this.pollManager.updatePoll(eventName, form).map(PollModification::from));
    }

    @DeleteMapping(value={"/{pollId}"})
    ResponseEntity<Boolean> deletePoll(@PathVariable String eventName, @PathVariable Long pollId, Principal principal) {
        EventAndOrganizationId eventAndOrganizationId = this.accessService.checkEventOwnership(principal, eventName);
        return ResponseEntity.ok((Object)this.pollManager.deletePoll(eventAndOrganizationId, pollId));
    }

    @DeleteMapping(value={"/{pollId}/option/{optionId}"})
    ResponseEntity<PollModification> removeOption(@PathVariable String eventName, @PathVariable Long pollId, @PathVariable Long optionId, Principal principal) {
        EventAndOrganizationId event = this.accessService.checkEventOwnership(principal, eventName);
        return ResponseEntity.of(this.pollManager.removeOption(event, pollId, optionId).map(PollModification::from));
    }

    @PutMapping(value={"/{pollId}"})
    ResponseEntity<PollModification> updateStatus(@PathVariable String eventName, @PathVariable Long pollId, @RequestBody UpdatePollStatusForm form, Principal principal) {
        if (form.status == Poll.PollStatus.DRAFT) {
            return ResponseEntity.badRequest().build();
        }
        EventAndOrganizationId eventAndOrgId = this.accessService.checkEventOwnership(principal, eventName);
        return ResponseEntity.of(this.pollManager.updateStatus(pollId, eventAndOrgId, form.status).map(PollModification::from));
    }

    @GetMapping(value={"/{pollId}/filter-tickets"})
    ResponseEntity<List<PollParticipant>> findAdditionalAttendees(@PathVariable String eventName, @PathVariable Long pollId, @RequestParam(value="filter") String filter, Principal principal) {
        if (StringUtils.isBlank((CharSequence)filter)) {
            return ResponseEntity.badRequest().build();
        }
        EventAndOrganizationId eventAndOrgId = this.accessService.checkEventOwnership(principal, eventName);
        return ResponseEntity.of((Optional)this.pollManager.searchTicketsToAllow(eventAndOrgId, pollId, filter));
    }

    @PostMapping(value={"/{pollId}/allow"})
    ResponseEntity<Boolean> allowAttendees(@PathVariable String eventName, @PathVariable Long pollId, @RequestBody UpdateParticipantsForm form, Principal principal) {
        if (CollectionUtils.isEmpty((Collection)form.ticketIds)) {
            return ResponseEntity.badRequest().build();
        }
        EventAndOrganizationId eventAndOrgId = this.accessService.checkEventOwnership(principal, eventName);
        return ResponseEntity.ok((Object)this.pollManager.allowTicketsToVote(eventAndOrgId, form.ticketIds, pollId.longValue()));
    }

    @GetMapping(value={"/{pollId}/allowed"})
    ResponseEntity<List<PollParticipant>> getAllowedAttendees(@PathVariable String eventName, @PathVariable Long pollId, Principal principal) {
        EventAndOrganizationId eventAndOrgId = this.accessService.checkEventOwnership(principal, eventName);
        return ResponseEntity.ok((Object)this.pollManager.fetchAllowedTickets(eventAndOrgId, pollId.longValue()));
    }

    @DeleteMapping(value={"/{pollId}/allowed"})
    ResponseEntity<List<PollParticipant>> forbidAttendees(@PathVariable String eventName, @PathVariable Long pollId, @RequestBody UpdateParticipantsForm form, Principal principal) {
        EventAndOrganizationId eventAndOrgId = this.accessService.checkEventOwnership(principal, eventName);
        return ResponseEntity.ok((Object)this.pollManager.removeParticipants(eventAndOrgId, form.ticketIds, pollId.longValue()));
    }

    @GetMapping(value={"/{pollId}/stats"})
    ResponseEntity<PollStatistics> getStatisticsForEvent(@PathVariable String eventName, @PathVariable Long pollId, Principal principal) {
        EventAndOrganizationId eventAndOrgId = this.accessService.checkEventOwnership(principal, eventName);
        return ResponseEntity.of((Optional)this.pollManager.getStatisticsFor(eventAndOrgId, pollId.longValue()));
    }

    @ConstructorProperties(value={"pollManager", "accessService"})
    @Generated
    public PollAdminApiController(PollManager pollManager, AccessService accessService) {
        this.pollManager = pollManager;
        this.accessService = accessService;
    }
}

