/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.admin;

import alfio.manager.AccessService;
import alfio.manager.EventManager;
import alfio.manager.PromoCodeRequestManager;
import alfio.model.PromoCodeDiscount;
import alfio.model.PromoCodeUsageResult;
import alfio.model.modification.PromoCodeDiscountModification;
import alfio.model.modification.PromoCodeDiscountWithFormattedTimeAndAmount;
import alfio.repository.EventRepository;
import java.beans.ConstructorProperties;
import java.security.Principal;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/api"})
public class PromoCodeDiscountApiController {
    private final EventRepository eventRepository;
    private final EventManager eventManager;
    private final PromoCodeRequestManager promoCodeRequestManager;
    private final AccessService accessService;

    @PostMapping(value={"/promo-code"})
    public void addPromoCode(@RequestBody PromoCodeDiscountModification promoCode, Principal principal) {
        Integer eventId = promoCode.getEventId();
        Integer organizationId = promoCode.getOrganizationId();
        ZoneId zoneId = this.zoneIdFromEventId(eventId, promoCode.getUtcOffset());
        this.accessService.checkAccessToPromoCodeEventOrganization(principal, eventId, organizationId);
        if (eventId != null && PromoCodeDiscount.supportsCurrencyCode((PromoCodeDiscount.CodeType)promoCode.getCodeType(), (PromoCodeDiscount.DiscountType)promoCode.getDiscountType())) {
            String eventCurrencyCode = this.eventRepository.getEventCurrencyCode(eventId.intValue());
            Validate.isTrue((boolean)eventCurrencyCode.equals(promoCode.getCurrencyCode()), (String)"Currency code does not match", (Object[])new Object[0]);
        }
        int discount = promoCode.getDiscountValue();
        this.eventManager.addPromoCode(promoCode.getPromoCode(), eventId, organizationId, promoCode.getStart().toZonedDateTime(zoneId), promoCode.getEnd().toZonedDateTime(zoneId), discount, promoCode.getDiscountType(), promoCode.getCategories(), promoCode.getMaxUsage(), promoCode.getDescription(), promoCode.getEmailReference(), promoCode.getCodeType(), promoCode.getHiddenCategoryId(), promoCode.getCurrencyCode());
    }

    @PostMapping(value={"/promo-code/{promoCodeId}"})
    public void updatePromoCode(@PathVariable int promoCodeId, @RequestBody PromoCodeDiscountModification promoCode, Principal principal) {
        this.accessService.checkAccessToPromoCodeEventOrganization(principal, promoCode.getEventId(), promoCode.getOrganizationId());
        PromoCodeDiscount pcd = (PromoCodeDiscount)this.promoCodeRequestManager.findById(promoCodeId).orElseThrow();
        ZoneId zoneId = this.zoneIdFromEventId(pcd.getEventId(), promoCode.getUtcOffset());
        this.eventManager.updatePromoCode(promoCodeId, promoCode.getStart().toZonedDateTime(zoneId), promoCode.getEnd().toZonedDateTime(zoneId), promoCode.getMaxUsage(), promoCode.getCategories(), promoCode.getDescription(), promoCode.getEmailReference(), promoCode.getHiddenCategoryId());
    }

    private ZoneId zoneIdFromEventId(Integer eventId, Integer utcOffset) {
        if (eventId != null) {
            return this.eventRepository.getZoneIdByEventId(eventId.intValue());
        }
        return ZoneId.ofOffset("UTC", ZoneOffset.ofTotalSeconds(utcOffset != null ? utcOffset : 0));
    }

    @GetMapping(value={"/events/{eventId}/promo-code"})
    public List<PromoCodeDiscountWithFormattedTimeAndAmount> listPromoCodeInEvent(@PathVariable int eventId, Principal principal) {
        this.accessService.checkEventOwnership(principal, eventId);
        return this.eventManager.findPromoCodesInEvent(eventId);
    }

    @GetMapping(value={"/organization/{organizationId}/promo-code"})
    public List<PromoCodeDiscountWithFormattedTimeAndAmount> listPromoCodeInOrganization(@PathVariable int organizationId, Principal principal) {
        this.accessService.checkOrganizationOwnership(principal, Integer.valueOf(organizationId));
        return this.eventManager.findPromoCodesInOrganization(organizationId);
    }

    @DeleteMapping(value={"/promo-code/{promoCodeId}"})
    public void removePromoCode(@PathVariable int promoCodeId, Principal principal) {
        this.accessService.checkAccessToPromoCode(principal, promoCodeId);
        this.eventManager.deletePromoCode(promoCodeId);
    }

    @PostMapping(value={"/promo-code/{promoCodeId}/disable"})
    public void disablePromoCode(@PathVariable int promoCodeId, Principal principal) {
        this.accessService.checkAccessToPromoCode(principal, promoCodeId);
        this.promoCodeRequestManager.disablePromoCode(promoCodeId);
    }

    @GetMapping(value={"/promo-code/{promoCodeId}/count-use"})
    public int countPromoCodeUse(@PathVariable int promoCodeId, Principal principal) {
        this.accessService.checkAccessToPromoCode(principal, promoCodeId);
        return this.promoCodeRequestManager.countUsage(promoCodeId);
    }

    @GetMapping(value={"/promo-code/{promoCodeId}/detailed-usage"})
    public List<PromoCodeUsageResult> retrieveDetailedUsage(@PathVariable int promoCodeId, @RequestParam(value="eventShortName", required=false) String eventShortName, Principal principal) {
        Integer eventId = null;
        if (StringUtils.isNotBlank((CharSequence)eventShortName)) {
            eventId = this.eventManager.getEventAndOrganizationId(eventShortName, principal.getName()).getId();
        }
        this.accessService.checkAccessToPromoCode(principal, promoCodeId);
        return this.promoCodeRequestManager.retrieveDetailedUsage(promoCodeId, eventId);
    }

    @ConstructorProperties(value={"eventRepository", "eventManager", "promoCodeRequestManager", "accessService"})
    @Generated
    public PromoCodeDiscountApiController(EventRepository eventRepository, EventManager eventManager, PromoCodeRequestManager promoCodeRequestManager, AccessService accessService) {
        this.eventRepository = eventRepository;
        this.eventManager = eventManager;
        this.promoCodeRequestManager = promoCodeRequestManager;
        this.accessService = accessService;
    }
}

